/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.particle.entity;

import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL14;
import thebetweenlands.client.render.model.SpikeRenderer;
import thebetweenlands.client.render.particle.ParticleFactory;
import thebetweenlands.client.render.particle.ParticleTextureStitcher;
import thebetweenlands.common.registries.SoundRegistry;

@SideOnly(value=Side.CLIENT)
public class ParticleUrchinSpike
extends Particle
implements ParticleTextureStitcher.IParticleSpriteReceiver {
    public static final ResourceLocation SPRITE = new ResourceLocation("thebetweenlands", "entity/urchin_spike");
    private SpikeRenderer renderer;
    private int length;
    private float scale;
    private float width;
    private long seed;
    private double prevMotionX;
    private double prevMotionY;
    private double prevMotionZ;
    private boolean sound = false;

    protected ParticleUrchinSpike(World worldIn, double posXIn, double posYIn, double posZIn, double xSpeedIn, double ySpeedIn, double zSpeedIn, int length, float width, float scale, long seed) {
        super(worldIn, posXIn, posYIn, posZIn);
        this.prevMotionX = this.field_187129_i = xSpeedIn;
        this.prevMotionY = this.field_187130_j = ySpeedIn;
        this.prevMotionZ = this.field_187131_k = zSpeedIn;
        this.length = length;
        this.width = width;
        this.scale = scale;
        this.seed = seed;
        this.field_70545_g = 1.0f;
        this.field_70547_e = 60;
    }

    public void func_187117_a(TextureAtlasSprite texture) {
        this.field_187119_C = texture;
    }

    public void setUseSound(boolean sound) {
        this.sound = sound;
    }

    public int func_70537_b() {
        return 3;
    }

    public void func_189213_a() {
        this.prevMotionX = this.field_187129_i;
        this.prevMotionY = this.field_187130_j;
        this.prevMotionZ = this.field_187131_k;
        super.func_189213_a();
        if (this.field_187132_l) {
            this.field_187129_i *= (double)0.01f;
            this.field_187130_j *= (double)0.01f;
            this.field_187131_k *= (double)0.01f;
            if (this.sound) {
                this.sound = false;
                this.field_187122_b.func_184134_a(this.field_187126_f, this.field_187127_g, this.field_187128_h, (SoundEvent)SoundRegistry.ROOT_SPIKE_PARTICLE_HIT, SoundCategory.HOSTILE, 1.0f, 0.9f + this.field_187136_p.nextFloat() * 0.2f, false);
            }
        }
    }

    public void func_180434_a(BufferBuilder buffer, Entity entityIn, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
        if (this.renderer == null) {
            this.renderer = new SpikeRenderer(this.length, this.width, 1.0f, 1.0f, this.seed).build(DefaultVertexFormats.field_181703_c, this.field_187119_C);
        }
        int i = this.func_189214_a(partialTicks);
        int j = i % 65536;
        int k = i / 65536;
        RenderHelper.func_74519_b();
        GlStateManager.func_179145_e();
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)j, (float)k);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
        float rx = (float)(this.field_187123_c + (this.field_187126_f - this.field_187123_c) * (double)partialTicks - field_70556_an);
        float ry = (float)(this.field_187124_d + (this.field_187127_g - this.field_187124_d) * (double)partialTicks - field_70554_ao);
        float rz = (float)(this.field_187125_e + (this.field_187128_h - this.field_187125_e) * (double)partialTicks - field_70555_ap);
        GlStateManager.func_179094_E();
        float alpha = 1.0f;
        if ((float)this.field_70546_d + partialTicks >= (float)(this.field_70547_e - 10)) {
            alpha = 1.0f - ((float)this.field_70546_d + partialTicks - (float)(this.field_70547_e - 10)) / 10.0f;
        }
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.CONSTANT_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_CONSTANT_ALPHA);
        GL14.glBlendColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        GlStateManager.func_179109_b((float)rx, (float)ry, (float)rz);
        double mx = this.prevMotionX + (this.field_187129_i - this.prevMotionX) * (double)partialTicks;
        double my = this.prevMotionY + (this.field_187130_j - this.prevMotionY) * (double)partialTicks;
        double mz = this.prevMotionZ + (this.field_187131_k - this.prevMotionZ) * (double)partialTicks;
        GlStateManager.func_179114_b((float)(-((float)Math.toDegrees(Math.atan2(mz, mx)))), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((float)Math.toDegrees(Math.atan2(Math.sqrt(mx * mx + mz * mz), -my)) + 180.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)(-0.5f * this.scale), (float)0.0f);
        GlStateManager.func_179152_a((float)this.scale, (float)this.scale, (float)this.scale);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
        this.renderer.render();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GL14.glBlendColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }

    public static final class Factory
    extends ParticleFactory<Factory, ParticleUrchinSpike> {
        public Factory() {
            super(ParticleUrchinSpike.class, ParticleTextureStitcher.create(ParticleUrchinSpike.class, SPRITE));
        }

        @Override
        public ParticleUrchinSpike createParticle(ParticleFactory.ImmutableParticleArgs args) {
            return new ParticleUrchinSpike(args.world, args.x, args.y, args.z, args.motionX, args.motionY, args.motionZ, args.data.getInt(0), args.data.getFloat(2), args.scale, args.data.getLong(1));
        }

        @Override
        protected void setBaseArguments(ParticleFactory.ParticleArgs<?> args) {
            ((ParticleFactory.ParticleArgs)args.withData(2, 1234L, Float.valueOf(0.25f))).withScale(0.5f);
        }

        @Override
        protected void setDefaultArguments(World world, double x, double y, double z, ParticleFactory.ParticleArgs<?> args) {
            args.withData(2, world.field_73012_v.nextLong(), Float.valueOf(0.25f));
        }
    }
}

