/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.particle.entity;

import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class ParticleSwirl
extends Particle {
    protected float progress = 0.0f;
    protected float startRotation;
    protected float endRadius;
    protected double dragX;
    protected double dragY;
    protected double dragZ;
    protected double offsetX;
    protected double offsetY;
    protected double offsetZ;
    protected double targetX;
    protected double targetY;
    protected double targetZ;
    protected double targetMotionX;
    protected double targetMotionY;
    protected double targetMotionZ;
    protected boolean rotate3D = false;
    private boolean firstUpdate = true;
    private static final float VELOCITY_OFFSET_MULTIPLIER = 4.0f;
    protected double prevRotSinX;
    protected double prevRotCosZ;
    protected double rotSinX;
    protected double rotCosZ;
    protected double rotationSpeed = 4.0;

    public ParticleSwirl(World world, double x, double y, double z, int maxAge, float scale, float progress) {
        super(world, x, y, z, 0.0, 0.0, 0.0);
        this.field_187131_k = 0.0;
        this.field_187130_j = 0.0;
        this.field_187129_i = 0.0;
        this.progress = progress;
        this.startRotation = (float)((double)this.field_187136_p.nextFloat() * Math.PI * 2.0);
        this.endRadius = 0.35f + this.field_187136_p.nextFloat() * 0.35f;
        this.field_70547_e = maxAge;
        this.field_70544_f = scale;
    }

    public ParticleSwirl setOffset(double x, double y, double z) {
        this.offsetX = x;
        this.offsetY = y;
        this.offsetZ = z;
        return this;
    }

    public ParticleSwirl setTarget(double x, double y, double z) {
        this.targetX = x;
        this.targetY = y;
        this.targetZ = z;
        if (this.firstUpdate) {
            this.updatePosition();
            this.field_187123_c = this.field_187126_f;
            this.field_187124_d = this.field_187127_g;
            this.field_187125_e = this.field_187128_h;
        }
        return this;
    }

    public ParticleSwirl setTargetMotion(double x, double y, double z) {
        this.targetMotionX = x;
        this.targetMotionY = y;
        this.targetMotionZ = z;
        if (this.firstUpdate) {
            double tmx = this.targetMotionX;
            double tmy = this.targetMotionY;
            double my = tmy * 4.0;
            double tmz = this.targetMotionZ;
            this.dragX = MathHelper.func_151237_a((double)(tmx * 4.0), (double)-1.0, (double)1.0);
            this.dragY = MathHelper.func_151237_a((double)my, (double)-0.3, (double)1.0);
            this.dragZ = MathHelper.func_151237_a((double)(tmz * 4.0), (double)-1.0, (double)1.0);
        }
        return this;
    }

    public ParticleSwirl setRotationSpeed(double speed) {
        this.rotationSpeed = speed;
        return this;
    }

    public ParticleSwirl setRotate3D(boolean rotate3D) {
        this.rotate3D = rotate3D;
        return this;
    }

    public void func_180434_a(BufferBuilder buffer, Entity entityIn, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
        if (this.field_70546_d > 2) {
            if (this.rotate3D) {
                float minU = (float)this.field_94054_b / 16.0f;
                float maxU = minU + 0.0624375f;
                float minV = (float)this.field_94055_c / 16.0f;
                float maxV = minV + 0.0624375f;
                float scale = 0.1f * this.field_70544_f;
                if (this.field_187119_C != null) {
                    minU = this.field_187119_C.func_94209_e();
                    maxU = this.field_187119_C.func_94212_f();
                    minV = this.field_187119_C.func_94206_g();
                    maxV = this.field_187119_C.func_94210_h();
                }
                float rx = (float)(this.field_187123_c + (this.field_187126_f - this.field_187123_c) * (double)partialTicks - field_70556_an);
                float ry = (float)(this.field_187124_d + (this.field_187127_g - this.field_187124_d) * (double)partialTicks - field_70554_ao);
                float rz = (float)(this.field_187125_e + (this.field_187128_h - this.field_187125_e) * (double)partialTicks - field_70555_ap);
                int brightness = this.func_189214_a(partialTicks);
                int lightmapX = brightness >> 16 & 0xFFFF;
                int lightmapY = brightness & 0xFFFF;
                float irx = (float)(this.prevRotSinX + (this.rotSinX - this.prevRotSinX) * (double)partialTicks);
                float irz = (float)(this.prevRotCosZ + (this.rotCosZ - this.prevRotCosZ) * (double)partialTicks);
                double tilt = -30.0;
                double h = Math.cos(tilt / 360.0 * 2.0 * Math.PI);
                double v = Math.sin(tilt / 360.0 * 2.0 * Math.PI);
                double side = h;
                double out = v;
                double sidex = -irz * scale;
                double sidez = irx * scale;
                double outx = irx * scale;
                double outz = irz * scale;
                Vec3d[] vertices = new Vec3d[]{new Vec3d(-sidex * side + (outx * out - sidex * (1.0 - side)), (double)(-scale) * side, -sidez * side + (outz * out - sidez * (1.0 - side))), new Vec3d(-sidex * side + (-outx * out - sidex * (1.0 - side)), (double)scale * side, -sidez * side + (-outz * out - sidez * (1.0 - side))), new Vec3d(sidex * side + (-outx * out + sidex * (1.0 - side)), (double)scale * side, sidez * side + (-outz * out + sidez * (1.0 - side))), new Vec3d(sidex * side + (outx * out + sidex * (1.0 - side)), (double)(-scale) * side, sidez * side + (outz * out + sidez * (1.0 - side)))};
                buffer.func_181662_b((double)rx + vertices[0].field_72450_a, (double)ry + vertices[0].field_72448_b, (double)rz + vertices[0].field_72449_c).func_187315_a((double)maxU, (double)maxV).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(lightmapX, lightmapY).func_181675_d();
                buffer.func_181662_b((double)rx + vertices[1].field_72450_a, (double)ry + vertices[1].field_72448_b, (double)rz + vertices[1].field_72449_c).func_187315_a((double)maxU, (double)minV).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(lightmapX, lightmapY).func_181675_d();
                buffer.func_181662_b((double)rx + vertices[2].field_72450_a, (double)ry + vertices[2].field_72448_b, (double)rz + vertices[2].field_72449_c).func_187315_a((double)minU, (double)minV).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(lightmapX, lightmapY).func_181675_d();
                buffer.func_181662_b((double)rx + vertices[3].field_72450_a, (double)ry + vertices[3].field_72448_b, (double)rz + vertices[3].field_72449_c).func_187315_a((double)minU, (double)maxV).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(lightmapX, lightmapY).func_181675_d();
                buffer.func_181662_b((double)rx + vertices[3].field_72450_a, (double)ry + vertices[3].field_72448_b, (double)rz + vertices[3].field_72449_c).func_187315_a((double)minU, (double)maxV).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(lightmapX, lightmapY).func_181675_d();
                buffer.func_181662_b((double)rx + vertices[2].field_72450_a, (double)ry + vertices[2].field_72448_b, (double)rz + vertices[2].field_72449_c).func_187315_a((double)minU, (double)minV).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(lightmapX, lightmapY).func_181675_d();
                buffer.func_181662_b((double)rx + vertices[1].field_72450_a, (double)ry + vertices[1].field_72448_b, (double)rz + vertices[1].field_72449_c).func_187315_a((double)maxU, (double)minV).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(lightmapX, lightmapY).func_181675_d();
                buffer.func_181662_b((double)rx + vertices[0].field_72450_a, (double)ry + vertices[0].field_72448_b, (double)rz + vertices[0].field_72449_c).func_187315_a((double)maxU, (double)maxV).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(lightmapX, lightmapY).func_181675_d();
            } else {
                super.func_180434_a(buffer, entityIn, partialTicks, rotationX, rotationZ, rotationYZ, rotationXY, rotationXZ);
            }
        }
    }

    public void func_189213_a() {
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
        if (this.field_70546_d++ >= this.field_70547_e) {
            this.func_187112_i();
        }
        if (this.progress > 1.0f) {
            this.func_187112_i();
        }
        this.progress += 0.01f;
        this.updateDrag();
        this.updatePosition();
        this.firstUpdate = false;
    }

    protected void updateDrag() {
        double tmx = this.targetMotionX;
        double tmy = this.targetMotionY;
        double my = tmy * 4.0;
        double tmz = this.targetMotionZ;
        float dragIncrement = 0.1f;
        if (this.dragX > tmx * 4.0) {
            this.dragX -= (double)dragIncrement;
        } else if (this.dragX < tmx * 4.0) {
            this.dragX += (double)dragIncrement;
        }
        if (Math.abs(this.dragX - tmx * 4.0) <= (double)dragIncrement) {
            this.dragX = tmx * 4.0;
        }
        if (this.dragY > my) {
            this.dragY -= (double)dragIncrement;
        } else if (this.dragY < my) {
            this.dragY += (double)dragIncrement;
        }
        if (Math.abs(this.dragY - my) <= (double)dragIncrement) {
            this.dragY = my;
        }
        if (this.dragZ > tmz * 4.0) {
            this.dragZ -= (double)dragIncrement;
        } else if (this.dragZ < tmz * 4.0) {
            this.dragZ += (double)dragIncrement;
        }
        if (Math.abs(this.dragZ - tmz * 4.0) <= (double)dragIncrement) {
            this.dragZ = tmz * 4.0;
        }
        this.dragX = MathHelper.func_151237_a((double)this.dragX, (double)-1.0, (double)1.0);
        this.dragY = MathHelper.func_151237_a((double)this.dragY, (double)-0.3, (double)1.0);
        this.dragZ = MathHelper.func_151237_a((double)this.dragZ, (double)-1.0, (double)1.0);
    }

    protected void updatePosition() {
        double sx = this.targetX + this.offsetX - this.dragX;
        double sy = this.targetY + this.offsetY - this.dragY;
        double sz = this.targetZ + this.offsetZ - this.dragZ;
        double dx = this.targetX - sx;
        double dy = this.targetY - sy;
        double dz = this.targetZ - sz;
        this.prevRotSinX = this.rotSinX;
        this.prevRotCosZ = this.rotCosZ;
        this.rotSinX = Math.sin((double)this.startRotation + (double)this.progress * this.rotationSpeed * Math.PI * 2.0);
        this.rotCosZ = Math.cos((double)this.startRotation + (double)this.progress * this.rotationSpeed * Math.PI * 2.0);
        this.field_187126_f = sx + dx * (1.0 - Math.pow(1.0f - this.progress, 3.0)) + this.rotSinX * (double)this.progress * (double)this.endRadius;
        this.field_187127_g = sy + dy * (double)this.progress;
        this.field_187128_h = sz + dz * (1.0 - Math.pow(1.0f - this.progress, 3.0)) + this.rotCosZ * (double)this.progress * (double)this.endRadius;
    }
}

