/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.model.baked;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonParser;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.common.model.IModelState;
import thebetweenlands.client.render.model.loader.IBakedModelDependant;
import thebetweenlands.client.render.model.loader.extension.LoaderExtension;
import thebetweenlands.common.item.misc.ItemMob;

public class ModelMobItem
implements IModel {
    private final Map<ResourceLocation, ResourceLocation> modelMap;

    public ModelMobItem() {
        this.modelMap = new HashMap<ResourceLocation, ResourceLocation>();
    }

    protected ModelMobItem(Map<ResourceLocation, ResourceLocation> modelMap) {
        this.modelMap = modelMap;
    }

    public Collection<ResourceLocation> getDependencies() {
        return Collections.unmodifiableCollection(this.modelMap.values());
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        return new ModelBakedMobItem(this.modelMap, bakedTextureGetter.apply(TextureMap.field_174945_f));
    }

    public IModel process(ImmutableMap<String, String> customData) {
        if (customData.containsKey((Object)"map")) {
            HashMap<ResourceLocation, ResourceLocation> newModelMap = new HashMap<ResourceLocation, ResourceLocation>();
            newModelMap.putAll(this.modelMap);
            JsonParser parser = new JsonParser();
            ImmutableMap<String, String> jsonMap = LoaderExtension.parseJsonElementList(parser, (String)customData.get((Object)"map"), "map");
            for (Map.Entry entry : jsonMap.entrySet()) {
                newModelMap.put(new ResourceLocation((String)entry.getKey()), new ResourceLocation(parser.parse((String)entry.getValue()).getAsString()));
            }
            return new ModelMobItem(newModelMap);
        }
        return this;
    }

    private static class ModelBakedMobItem
    implements IBakedModel,
    IBakedModelDependant {
        private final Map<ResourceLocation, ResourceLocation> modelMap;
        private final TextureAtlasSprite missingTexture;
        private final ItemOverrideList overrides;

        private ModelBakedMobItem(Map<ResourceLocation, ResourceLocation> modelMap, TextureAtlasSprite missingTexture) {
            this.modelMap = modelMap;
            this.missingTexture = missingTexture;
            this.overrides = new ItemOverrideList(Collections.emptyList()){

                public ResourceLocation func_188021_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                    if (stack.func_77973_b() instanceof ItemMob) {
                        ResourceLocation id = ((ItemMob)stack.func_77973_b()).getCapturedEntityId(stack);
                        ResourceLocation modelLocation = (ResourceLocation)modelMap.get(id);
                        return modelLocation;
                    }
                    return null;
                }
            };
        }

        public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
            return ImmutableList.of();
        }

        public boolean func_177555_b() {
            return false;
        }

        public boolean func_177556_c() {
            return false;
        }

        public boolean func_188618_c() {
            return false;
        }

        public TextureAtlasSprite func_177554_e() {
            return this.missingTexture;
        }

        public ItemOverrideList func_188617_f() {
            return this.overrides;
        }

        @Override
        public Collection<ModelResourceLocation> getDependencies(ResourceLocation modelLocation) {
            return Collections.emptyList();
        }

        @Override
        public void setDependencies(ResourceLocation modelLocation, Map<ModelResourceLocation, IBakedModel> dependencies) {
        }

        @Override
        public VertexFormat getVertexFormat(IModel dependencyModel) {
            return DefaultVertexFormats.field_176599_b;
        }
    }
}

