/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.model.baked;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.model.IModelState;
import org.apache.commons.lang3.tuple.Pair;
import thebetweenlands.client.render.model.loader.extension.LoaderExtension;

public class ModelItemMultiPart
implements IModel {
    protected final PartsMapper mapper;
    protected final Map<String, Map<String, Pair<ResourceLocation, IModel>>> baseModelsMapping;
    protected final String category;
    protected final String key;
    protected final ResourceLocation particleTexture;

    public ModelItemMultiPart(PartsMapper mapper, ResourceLocation particleTexture) {
        this.mapper = mapper;
        this.particleTexture = particleTexture;
        this.baseModelsMapping = new HashMap<String, Map<String, Pair<ResourceLocation, IModel>>>();
        this.key = null;
        this.category = null;
    }

    private ModelItemMultiPart(PartsMapper mapper, Map<String, Map<String, Pair<ResourceLocation, IModel>>> baseModelsMapping, ResourceLocation particleTexture) {
        this.mapper = mapper;
        this.particleTexture = particleTexture;
        this.baseModelsMapping = baseModelsMapping;
        this.key = null;
        this.category = null;
    }

    public Collection<ResourceLocation> getDependencies() {
        ArrayList<ResourceLocation> dependencies = new ArrayList<ResourceLocation>();
        if (this.baseModelsMapping != null) {
            for (Map<String, Pair<ResourceLocation, IModel>> map : this.baseModelsMapping.values()) {
                dependencies.addAll(map.values().stream().map(pair -> (ResourceLocation)pair.getLeft()).collect(Collectors.toList()));
            }
        }
        return dependencies;
    }

    public Collection<ResourceLocation> getTextures() {
        ArrayList<ResourceLocation> textures = new ArrayList<ResourceLocation>();
        if (this.baseModelsMapping != null) {
            for (Map<String, Pair<ResourceLocation, IModel>> map : this.baseModelsMapping.values()) {
                for (Pair<ResourceLocation, IModel> pair : map.values()) {
                    textures.addAll(((IModel)pair.getRight()).getTextures());
                }
            }
        }
        return textures;
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        HashMap<String, Map<String, IBakedModel>> bakedModelsMapping = new HashMap<String, Map<String, IBakedModel>>();
        for (Map.Entry<String, Map<String, Pair<ResourceLocation, IModel>>> categoryPair : this.baseModelsMapping.entrySet()) {
            HashMap<String, IBakedModel> map = new HashMap<String, IBakedModel>();
            bakedModelsMapping.put(categoryPair.getKey(), map);
            for (Map.Entry<String, Pair<ResourceLocation, IModel>> modelPair : categoryPair.getValue().entrySet()) {
                IBakedModel baked = ((IModel)modelPair.getValue().getRight()).bake(state, format, bakedTextureGetter);
                map.put(modelPair.getKey(), baked);
            }
        }
        return new BakedItemMultiPartModel(this.mapper, bakedModelsMapping, this.particleTexture, bakedTextureGetter);
    }

    public IModel process(ImmutableMap<String, String> customData) {
        HashMap<String, Map<String, Pair<ResourceLocation, IModel>>> baseModelsMapping = new HashMap<String, Map<String, Pair<ResourceLocation, IModel>>>();
        for (Map.Entry<String, Map<String, Pair<ResourceLocation, IModel>>> entry1 : this.baseModelsMapping.entrySet()) {
            HashMap<String, Pair<ResourceLocation, IModel>> map = new HashMap<String, Pair<ResourceLocation, IModel>>();
            baseModelsMapping.put(entry1.getKey(), map);
            for (Map.Entry<String, Pair<ResourceLocation, IModel>> entry2 : entry1.getValue().entrySet()) {
                map.put(entry2.getKey(), entry2.getValue());
            }
        }
        JsonParser parser = new JsonParser();
        if (customData.containsKey((Object)"map")) {
            ImmutableMap<String, String> categoryMap = LoaderExtension.parseJsonElementList(parser, (String)customData.get((Object)"map"), "map");
            for (Map.Entry entry : categoryMap.entrySet()) {
                String category = (String)entry.getKey();
                String partsMapJson = (String)entry.getValue();
                HashMap<String, Pair> partsMapping = (HashMap<String, Pair>)baseModelsMapping.get(category);
                if (partsMapping == null) {
                    partsMapping = new HashMap<String, Pair>();
                    baseModelsMapping.put(category, partsMapping);
                }
                ImmutableMap<String, String> partsMap = LoaderExtension.parseJsonElementList(parser, partsMapJson, "");
                for (Map.Entry partEntry : partsMap.entrySet()) {
                    String part = (String)partEntry.getKey();
                    JsonObject partJson = parser.parse((String)partEntry.getValue()).getAsJsonObject();
                    ResourceLocation modelName = new ResourceLocation(JsonUtils.func_151200_h((JsonObject)partJson, (String)"model"));
                    IModel partModel = ModelLoaderRegistry.getModelOrLogError((ResourceLocation)modelName, (String)("Could not find model '" + part + "' for multipart model"));
                    if (partJson.has("custom")) {
                        ImmutableMap<String, String> partCustomData = LoaderExtension.parseJsonElementList(partJson);
                        partModel = partModel.process(partCustomData);
                    }
                    partsMapping.put(part, Pair.of((Object)modelName, (Object)partModel));
                }
            }
        }
        ResourceLocation particle = this.particleTexture;
        if (customData.containsKey((Object)"particle")) {
            particle = new ResourceLocation((String)customData.get((Object)"particle"));
        }
        return new ModelItemMultiPart(this.mapper, baseModelsMapping, particle);
    }

    private class BakedItemMultiPartModel
    implements IBakedModel {
        private final Map<String, Map<String, IBakedModel>> bakedModelsMapping;
        private final ItemOverrideList overrides;
        private final List<IBakedModel> models;
        private final TextureAtlasSprite sprite;

        public BakedItemMultiPartModel(final PartsMapper mapper, Map<String, Map<String, IBakedModel>> bakedModelsMapping, ResourceLocation particleTexture, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
            this.bakedModelsMapping = bakedModelsMapping;
            this.models = null;
            this.sprite = particleTexture == null ? bakedTextureGetter.apply(TextureMap.field_174945_f) : bakedTextureGetter.apply(particleTexture);
            this.overrides = new ItemOverrideList((List)ImmutableList.of()){

                public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, World world, EntityLivingBase entity) {
                    ArrayList<IBakedModel> models = new ArrayList<IBakedModel>();
                    Map<String, String> partsMapping = mapper.getPartsMapping(stack, world, entity);
                    if (partsMapping != null) {
                        for (Map.Entry<String, String> entry : partsMapping.entrySet()) {
                            IBakedModel bakedPart;
                            Map partMapping = (Map)BakedItemMultiPartModel.this.bakedModelsMapping.get(entry.getKey());
                            if (partMapping == null || (bakedPart = (IBakedModel)partMapping.get(entry.getValue())) == null) continue;
                            models.add(bakedPart);
                        }
                        return new BakedItemMultiPartModel(models, BakedItemMultiPartModel.this.sprite);
                    }
                    return BakedItemMultiPartModel.this;
                }
            };
        }

        private BakedItemMultiPartModel(List<IBakedModel> models, TextureAtlasSprite sprite) {
            this.bakedModelsMapping = null;
            this.models = models;
            this.overrides = ItemOverrideList.field_188022_a;
            this.sprite = sprite;
        }

        public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
            if (this.models != null) {
                ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
                for (IBakedModel model : this.models) {
                    quads.addAll(model.func_188616_a(state, side, rand));
                }
                return quads;
            }
            return ImmutableList.of();
        }

        public boolean func_177555_b() {
            return false;
        }

        public boolean func_177556_c() {
            return false;
        }

        public boolean func_188618_c() {
            return false;
        }

        public TextureAtlasSprite func_177554_e() {
            return this.sprite;
        }

        public ItemOverrideList func_188617_f() {
            return this.overrides;
        }
    }

    public static interface PartsMapper {
        public Map<String, String> getPartsMapping(ItemStack var1, World var2, EntityLivingBase var3);
    }
}

