/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.entity;

import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MultiPartEntityPart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.render.model.entity.ModelSmolSludgeWorm;
import thebetweenlands.common.entity.mobs.EntitySludgeWorm;

@SideOnly(value=Side.CLIENT)
public class RenderSludgeWorm<T extends EntitySludgeWorm>
extends RenderLiving<T> {
    public static final ResourceLocation TEXTURE_HEAD = new ResourceLocation("thebetweenlands:textures/entity/smol_sludge_worm_head.png");
    public static final ResourceLocation TEXTURE_BODY = new ResourceLocation("thebetweenlands:textures/entity/smol_sludge_worm_body.png");
    private final ModelSmolSludgeWorm model;

    public RenderSludgeWorm(RenderManager manager) {
        super(manager, (ModelBase)new ModelSmolSludgeWorm(), 0.0f);
        this.model = (ModelSmolSludgeWorm)this.field_77045_g;
    }

    public RenderSludgeWorm(RenderManager manager, ModelBase model, float shadow) {
        super(manager, model, shadow);
        this.model = null;
    }

    public void doRender(T entity, double x, double y, double z, float yaw, float partialTicks) {
        boolean isTranslucentToPlayer;
        super.func_76986_a(entity, x, y, z, yaw, partialTicks);
        boolean isVisible = this.func_193115_c((EntityLivingBase)entity);
        boolean bl = isTranslucentToPlayer = !isVisible && !entity.func_98034_c((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        if (!isVisible && !isTranslucentToPlayer) {
            return;
        }
        boolean useBrightness = this.func_177090_c((EntityLivingBase)entity, partialTicks);
        if (isTranslucentToPlayer) {
            GlStateManager.func_187408_a((GlStateManager.Profile)GlStateManager.Profile.TRANSPARENT_MODEL);
        }
        boolean useTeamColors = false;
        if (this.field_188301_f) {
            useTeamColors = this.func_177088_c((EntityLivingBase)entity);
            GlStateManager.func_179142_g();
            GlStateManager.func_187431_e((int)this.func_188298_c((Entity)entity));
        }
        GlStateManager.func_179094_E();
        float totalAngleDiff = 0.0f;
        for (int i = 1; i < ((EntitySludgeWorm)entity).parts.length; ++i) {
            MultiPartEntityPart prevPart = ((EntitySludgeWorm)entity).parts[i - 1];
            MultiPartEntityPart part = ((EntitySludgeWorm)entity).parts[i];
            double yawDiff = (prevPart.field_70177_z - part.field_70177_z) % 360.0f;
            double yawInterpolant = 2.0 * yawDiff % 360.0 - yawDiff;
            totalAngleDiff += (float)Math.abs(yawInterpolant);
        }
        float avgAngleDiff = totalAngleDiff;
        if (((EntitySludgeWorm)entity).parts.length > 1) {
            avgAngleDiff /= (float)(((EntitySludgeWorm)entity).parts.length - 1);
        }
        float avgWibbleStrength = MathHelper.func_76131_a((float)(1.0f - avgAngleDiff / 60.0f), (float)0.0f, (float)1.0f);
        this.renderHead(entity, 1, x, y + 1.5, z, ((EntitySludgeWorm)entity).parts[0].field_70177_z, avgWibbleStrength, partialTicks);
        double ex = ((EntitySludgeWorm)entity).field_70142_S + (((EntitySludgeWorm)entity).field_70165_t - ((EntitySludgeWorm)entity).field_70142_S) * (double)partialTicks;
        double ey = ((EntitySludgeWorm)entity).field_70137_T + (((EntitySludgeWorm)entity).field_70163_u - ((EntitySludgeWorm)entity).field_70137_T) * (double)partialTicks;
        double ez = ((EntitySludgeWorm)entity).field_70136_U + (((EntitySludgeWorm)entity).field_70161_v - ((EntitySludgeWorm)entity).field_70136_U) * (double)partialTicks;
        double rx = ex - x;
        double ry = ey - y;
        double rz = ez - z;
        float zOffset = 0.0f;
        for (int i = 1; i < ((EntitySludgeWorm)entity).parts.length - 1; ++i) {
            this.renderBodyPart(entity, ((EntitySludgeWorm)entity).parts[i], ((EntitySludgeWorm)entity).parts[i - 1], rx, ry, rz, i, avgWibbleStrength, zOffset -= 0.001f, partialTicks);
        }
        this.renderTailPart(entity, ((EntitySludgeWorm)entity).parts[((EntitySludgeWorm)entity).parts.length - 1], ((EntitySludgeWorm)entity).parts[((EntitySludgeWorm)entity).parts.length - 2], rx, ry, rz, ((EntitySludgeWorm)entity).parts.length - 1, avgWibbleStrength, partialTicks);
        GlStateManager.func_179121_F();
        if (this.field_188301_f) {
            GlStateManager.func_187417_n();
            GlStateManager.func_179119_h();
        }
        if (useTeamColors) {
            this.func_180565_e();
        }
        if (isTranslucentToPlayer) {
            GlStateManager.func_187440_b((GlStateManager.Profile)GlStateManager.Profile.TRANSPARENT_MODEL);
        }
        if (useBrightness) {
            this.func_177091_f();
        }
    }

    private void renderHead(T entity, int frame, double x, double y, double z, float yaw, float avgWibbleStrength, float partialTicks) {
        double yawDiff = (yaw - ((EntitySludgeWorm)entity).parts[1].field_70177_z) % 360.0f;
        double yawInterpolant = 2.0 * yawDiff % 360.0 - yawDiff;
        float wibbleStrength = Math.min(avgWibbleStrength, MathHelper.func_76131_a((float)(1.0f - (float)Math.abs(yawInterpolant) / 60.0f), (float)0.0f, (float)1.0f));
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)(180.0f + yaw), (float)0.0f, (float)1.0f, (float)0.0f);
        this.renderHeadPartModel(entity, frame, wibbleStrength, partialTicks);
        GlStateManager.func_179121_F();
    }

    protected void renderHeadPartModel(T entity, int frame, float wibbleStrength, float partialTicks) {
        this.func_110776_a(TEXTURE_HEAD);
        this.model.renderHead((EntitySludgeWorm)entity, frame, wibbleStrength, partialTicks);
    }

    protected void renderBodyPart(T entity, MultiPartEntityPart part, MultiPartEntityPart prevPart, double rx, double ry, double rz, int frame, float avgWibbleStrength, float zOffset, float partialTicks) {
        double x = part.field_70142_S + (part.field_70165_t - part.field_70142_S) * (double)partialTicks - rx;
        double y = part.field_70137_T + (part.field_70163_u - part.field_70137_T) * (double)partialTicks - ry;
        double z = part.field_70136_U + (part.field_70161_v - part.field_70136_U) * (double)partialTicks - rz;
        float yaw = part.field_70126_B + (part.field_70177_z - part.field_70126_B) * partialTicks;
        double yawDiff = (prevPart.field_70177_z - part.field_70177_z) % 360.0f;
        double yawInterpolant = 2.0 * yawDiff % 360.0 - yawDiff;
        float wibbleStrength = Math.min(avgWibbleStrength, MathHelper.func_76131_a((float)(1.0f - (float)Math.abs(yawInterpolant) / 60.0f), (float)0.0f, (float)1.0f));
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)(y - 1.125 + (double)zOffset), (double)z);
        GlStateManager.func_179114_b((float)(-yaw), (float)0.0f, (float)1.0f, (float)0.0f);
        this.renderBodyPartModel(entity, frame, wibbleStrength, partialTicks);
        GlStateManager.func_179121_F();
    }

    protected void renderBodyPartModel(T entity, int frame, float wibbleStrength, float partialTicks) {
        this.func_110776_a(TEXTURE_BODY);
        this.model.renderBody((EntitySludgeWorm)entity, frame, wibbleStrength, partialTicks);
    }

    protected void renderTailPart(T entity, MultiPartEntityPart part, MultiPartEntityPart prevPart, double rx, double ry, double rz, int frame, float avgWibbleStrength, float partialTicks) {
        double x = part.field_70142_S + (part.field_70165_t - part.field_70142_S) * (double)partialTicks - rx;
        double y = part.field_70137_T + (part.field_70163_u - part.field_70137_T) * (double)partialTicks - ry;
        double z = part.field_70136_U + (part.field_70161_v - part.field_70136_U) * (double)partialTicks - rz;
        float yaw = part.field_70126_B + (part.field_70177_z - part.field_70126_B) * partialTicks;
        double yawDiff = (prevPart.field_70177_z - part.field_70177_z) % 360.0f;
        double yawInterpolant = 2.0 * yawDiff % 360.0 - yawDiff;
        float wibbleStrength = Math.min(avgWibbleStrength, MathHelper.func_76131_a((float)(1.0f - (float)Math.abs(yawInterpolant) / 60.0f), (float)0.0f, (float)1.0f));
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)(y + (double)1.525f), (double)z);
        GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)(180.0f + yaw), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179129_p();
        this.renderTailPartModel(entity, frame, wibbleStrength, partialTicks);
        GlStateManager.func_179089_o();
        GlStateManager.func_179121_F();
    }

    protected void renderTailPartModel(T entity, int frame, float wibbleStrength, float partialTicks) {
        this.func_110776_a(TEXTURE_BODY);
        this.model.renderTail((EntitySludgeWorm)entity, frame, wibbleStrength, partialTicks);
    }

    protected ResourceLocation getEntityTexture(EntitySludgeWorm entity) {
        return TEXTURE_HEAD;
    }
}

