/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.entity;

import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.EntityLiving;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.render.model.entity.ModelSludge;
import thebetweenlands.common.entity.mobs.EntitySludge;
import thebetweenlands.common.world.event.EventSpoopy;

@SideOnly(value=Side.CLIENT)
public class RenderSludge
extends RenderLiving<EntitySludge> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("thebetweenlands:textures/entity/sludge.png");
    private final ItemStack pumpkin = new ItemStack(Blocks.field_150428_aP);

    public RenderSludge(RenderManager renderManager) {
        this(renderManager, new ModelSludge());
    }

    public RenderSludge(RenderManager renderManager, ModelBase model) {
        super(renderManager, model, 0.0f);
    }

    protected void preRenderCallback(EntitySludge entity, float partialTicks) {
        float squishFactor = entity.getSquishFactor(partialTicks) / 1.5f;
        float scale = 1.0f / (squishFactor + 1.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)((1.0f - entity.scale.getAnimationProgressSin(partialTicks)) * 2.5f), (float)0.0f);
        GlStateManager.func_179152_a((float)scale, (float)(1.0f / scale), (float)scale);
        if (EventSpoopy.isSpoooopy(entity.field_70170_p)) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179109_b((float)0.37f, (float)-0.13f, (float)0.37f);
            GlStateManager.func_179152_a((float)(-scale * 0.65f), (float)(-1.0f / scale * 0.65f), (float)(scale * 0.65f));
            this.func_110776_a(TextureMap.field_110575_b);
            Minecraft.func_71410_x().func_175602_ab().func_175016_a(Blocks.field_150428_aP.func_176223_P(), 1.0f);
            GlStateManager.func_179121_F();
        }
    }

    public void doRender(EntitySludge entity, double x, double y, double z, float entityYaw, float partialTicks) {
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_187407_a((GlStateManager.CullFace)GlStateManager.CullFace.FRONT);
        super.func_76986_a((EntityLiving)entity, x, y, z, entityYaw, partialTicks);
        GlStateManager.func_187407_a((GlStateManager.CullFace)GlStateManager.CullFace.BACK);
        super.func_76986_a((EntityLiving)entity, x, y, z, entityYaw, partialTicks);
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179135_a((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        super.func_76986_a((EntityLiving)entity, x, y, z, entityYaw, partialTicks);
        GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
    }

    protected ResourceLocation getEntityTexture(EntitySludge entity) {
        return TEXTURE;
    }
}

