/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.entity;

import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.render.model.entity.ModelRockSnotGrabber;
import thebetweenlands.common.entity.mobs.EntityRockSnotTendril;

@SideOnly(value=Side.CLIENT)
public class RenderRockSnotTendril
extends Render<EntityRockSnotTendril> {
    public static final ResourceLocation TEXTURE = new ResourceLocation("thebetweenlands:textures/entity/rock_snot_grabber.png");
    public static final ResourceLocation VERTICAL_RING_TEXTURE = new ResourceLocation("thebetweenlands:textures/entity/decay_pit_vertical_ring.png");
    public final ModelRockSnotGrabber GRABBER_MODEL = new ModelRockSnotGrabber();

    public RenderRockSnotTendril(RenderManager rendermanagerIn) {
        super(rendermanagerIn);
    }

    public void doRender(EntityRockSnotTendril entity, double x, double y, double z, float yaw, float partialTicks) {
        super.func_76986_a((Entity)entity, x, y, z, yaw, partialTicks);
        if (entity.getParentEntity() != null) {
            float smoothedYaw = entity.field_70126_B + (entity.field_70177_z - entity.field_70126_B) * partialTicks;
            float smoothedPitch = entity.field_70127_C + (entity.field_70125_A - entity.field_70127_C) * partialTicks;
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)((float)x), (float)((float)y + 0.125f), (float)((float)z));
            if (entity.getExtending()) {
                GlStateManager.func_179114_b((float)(smoothedYaw + 180.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            } else {
                GlStateManager.func_179114_b((float)smoothedYaw, (float)0.0f, (float)1.0f, (float)0.0f);
            }
            GlStateManager.func_179114_b((float)(smoothedPitch + 90.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            this.func_110776_a(TEXTURE);
            this.GRABBER_MODEL.func_78088_a(entity, 0.0f, 0.0f, entity.field_70173_aa, 0.0f, 0.0f, 0.0625f);
            GlStateManager.func_179121_F();
            GlStateManager.func_179094_E();
            GlStateManager.func_179147_l();
            GlStateManager.func_179140_f();
            GlStateManager.func_179112_b((int)770, (int)771);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder buffer = tessellator.func_178180_c();
            this.func_110776_a(VERTICAL_RING_TEXTURE);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            for (int part = 0; part < 8; ++part) {
                RenderRockSnotTendril.buildRingQuads(buffer, x, y, z, x + entity.getParentEntity().field_70165_t - entity.field_70165_t, y + entity.getParentEntity().field_70163_u - entity.field_70163_u, z + entity.getParentEntity().field_70161_v - entity.field_70161_v, 45.0f * (float)part, 0.125, 0.125, 0.25, 0.25);
            }
            tessellator.func_78381_a();
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179084_k();
            GlStateManager.func_179145_e();
            GlStateManager.func_179121_F();
        }
    }

    public static void buildRingQuads(BufferBuilder buffer, double x, double y, double z, double xp, double yp, double zp, double angle, double offsetXInner, double offsetZInner, double offsetXInnerP, double offsetZInnerP) {
        double startAngle = Math.toRadians(angle);
        double endAngle = Math.toRadians(angle + 45.0);
        double startAngleP = Math.toRadians(angle + 180.0);
        double endAngleP = Math.toRadians(angle + 235.0);
        double offSetXIn1 = -Math.sin(startAngle) * offsetXInner;
        double offSetZIn1 = Math.cos(startAngle) * offsetZInner;
        double offSetXIn2 = -Math.sin(endAngle) * offsetXInner;
        double offSetZIn2 = Math.cos(endAngle) * offsetZInner;
        double offSetXIn1P = -Math.sin(startAngleP) * offsetXInnerP;
        double offSetZIn1P = Math.cos(startAngleP) * offsetZInnerP;
        double offSetXIn2P = -Math.sin(endAngleP) * offsetXInnerP;
        double offSetZIn2P = Math.cos(endAngleP) * offsetZInnerP;
        buffer.func_181662_b(xp - offSetXIn1P, yp + 0.0625, zp + offSetZIn1P).func_187315_a(1.0, 1.0).func_181675_d();
        buffer.func_181662_b(x - offSetXIn1, y + 0.125, z + offSetZIn1).func_187315_a(1.0, 0.0).func_181675_d();
        buffer.func_181662_b(x - offSetXIn2, y + 0.125, z + offSetZIn2).func_187315_a(0.0, 0.0).func_181675_d();
        buffer.func_181662_b(xp - offSetXIn2P, yp + 0.0625, zp + offSetZIn2P).func_187315_a(0.0, 1.0).func_181675_d();
        buffer.func_181662_b(xp + offSetXIn1P, yp + 0.0625, zp + offSetZIn1P).func_187315_a(1.0, 1.0).func_181675_d();
        buffer.func_181662_b(x + offSetXIn1, y + 0.125, z + offSetZIn1).func_187315_a(1.0, 0.0).func_181675_d();
        buffer.func_181662_b(x + offSetXIn2, y + 0.125, z + offSetZIn2).func_187315_a(0.0, 0.0).func_181675_d();
        buffer.func_181662_b(xp + offSetXIn2P, yp + 0.0625, zp + offSetZIn2P).func_187315_a(0.0, 1.0).func_181675_d();
    }

    protected ResourceLocation getEntityTexture(EntityRockSnotTendril entity) {
        return null;
    }
}

