/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.entity;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.render.entity.layer.LayerOverlay;
import thebetweenlands.client.render.model.entity.ModelChiromawMatriarch;
import thebetweenlands.common.entity.mobs.EntityChiromawMatriarch;

@SideOnly(value=Side.CLIENT)
public class RenderChiromawMatriarch
extends RenderLiving<EntityChiromawMatriarch> {
    public static final ResourceLocation TEXTURE = new ResourceLocation("thebetweenlands:textures/entity/chiromaw_matriarch.png");

    public RenderChiromawMatriarch(RenderManager rendermanagerIn) {
        super(rendermanagerIn, (ModelBase)new ModelChiromawMatriarch(), 1.5f);
        this.func_177094_a(new LayerOverlay(this, new ResourceLocation("thebetweenlands:textures/entity/chiromaw_matriarch_glow.png")).setGlow(true));
    }

    protected void preRenderCallback(EntityChiromawMatriarch chiromaw, float partialTickTime) {
        GlStateManager.func_179152_a((float)1.5f, (float)1.5f, (float)1.5f);
        float flyingPercent = Math.max(0.0f, 1.0f - chiromaw.landingTimer.getAnimationProgressSmooth(partialTickTime) - chiromaw.nestingTimer.getAnimationProgressSmooth(partialTickTime) - chiromaw.spinningTimer.getAnimationProgressSmooth(partialTickTime));
        float flap = MathHelper.func_76126_a((float)(((float)chiromaw.field_70173_aa + partialTickTime) * 0.5f)) * 0.6f;
        GlStateManager.func_179109_b((float)0.0f, (float)(-flap * 0.5f * flyingPercent), (float)0.0f);
        GlStateManager.func_179114_b((float)(20.0f * flyingPercent), (float)1.0f, (float)0.0f, (float)0.0f);
        if (chiromaw.getIsSpinning()) {
            float spinningRotation = chiromaw.previousSpinAngle + (chiromaw.spinAngle - chiromaw.previousSpinAngle) * partialTickTime;
            GlStateManager.func_179114_b((float)spinningRotation, (float)0.0f, (float)1.0f, (float)0.0f);
        }
    }

    protected ResourceLocation getEntityTexture(EntityChiromawMatriarch entity) {
        return TEXTURE;
    }
}

