/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.entity;

import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.render.model.entity.ModelChiromawEgg;
import thebetweenlands.client.render.model.entity.ModelChiromawHatchling;
import thebetweenlands.common.entity.mobs.EntityChiromawHatchling;

@SideOnly(value=Side.CLIENT)
public class RenderChiromawHatchling
extends RenderLiving<EntityChiromawHatchling> {
    private static final ResourceLocation TEXTURE_HATCHLING = new ResourceLocation("thebetweenlands", "textures/entity/chiromaw_hatchling.png");
    private static final ResourceLocation TEXTURE_HATCHLING_BLINK_1 = new ResourceLocation("thebetweenlands", "textures/entity/chiromaw_hatchling_blink_1.png");
    private static final ResourceLocation TEXTURE_HATCHLING_BLINK_2 = new ResourceLocation("thebetweenlands", "textures/entity/chiromaw_hatchling_blink_2.png");
    private static final ResourceLocation TEXTURE_HATCHLING_LIGHTNING = new ResourceLocation("thebetweenlands", "textures/entity/chiromaw_hatchling_lightning.png");
    private static final ResourceLocation TEXTURE_HATCHLING_LIGHTNING_BLINK_1 = new ResourceLocation("thebetweenlands", "textures/entity/chiromaw_hatchling_lightning_blink_1.png");
    private static final ResourceLocation TEXTURE_HATCHLING_LIGHTNING_BLINK_2 = new ResourceLocation("thebetweenlands", "textures/entity/chiromaw_hatchling_lightning_blink_2.png");
    private static final ResourceLocation TEXTURE_EGG = new ResourceLocation("thebetweenlands", "textures/entity/chiromaw_egg.png");
    private static final ModelChiromawHatchling MODEL_HATCHLING = new ModelChiromawHatchling();
    private static final ModelChiromawEgg MODEL_EGG = new ModelChiromawEgg();

    public RenderChiromawHatchling(RenderManager renderManager) {
        super(renderManager, (ModelBase)MODEL_HATCHLING, 0.2f);
    }

    public void doRender(EntityChiromawHatchling entity, double x, double y, double z, float entityYaw, float partialTicks) {
        super.func_76986_a((EntityLiving)entity, x, y, z, entityYaw, partialTicks);
        if (entity.getIsHungry() && entity.getRiseCount() > 0) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)x, (double)y, (double)z);
            float size = MathHelper.func_76126_a((float)(((float)entity.field_70173_aa + partialTicks) * 0.125f)) * 0.0625f;
            float smoothRise = (float)entity.prevRise + (float)(entity.getRiseCount() - entity.prevRise) * partialTicks;
            this.renderFoodCraved(entity.getFoodCraved(), 0.0, 0.5f + smoothRise * 0.025f, 0.0, (0.25f + size) * smoothRise / 40.0f);
            GlStateManager.func_179121_F();
        }
    }

    protected void applyRotations(EntityChiromawHatchling entity, float ageInTicks, float rotationYaw, float partialTicks) {
        super.func_77043_a((EntityLivingBase)entity, ageInTicks, entity.field_70177_z, partialTicks);
    }

    protected void renderModel(EntityChiromawHatchling entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor) {
        boolean isTransparent;
        boolean isVisible = this.func_193115_c((EntityLivingBase)entity);
        boolean bl = isTransparent = !isVisible && !entity.func_98034_c((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        if (isVisible || isTransparent) {
            if (!this.func_180548_c((Entity)entity)) {
                return;
            }
            if (isTransparent) {
                GlStateManager.func_187408_a((GlStateManager.Profile)GlStateManager.Profile.TRANSPARENT_MODEL);
            }
            float partialTicks = ageInTicks - (float)entity.field_70173_aa;
            if (entity.getHasHatched()) {
                float eggFade = (float)entity.getTransformCount() + (float)(entity.prevTransformTick - entity.getTransformCount()) * partialTicks;
                if (entity.getTransformCount() > 0) {
                    GlStateManager.func_179132_a((boolean)false);
                }
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)(1.0f - eggFade * 0.02f));
                MODEL_HATCHLING.renderEgg(entity, partialTicks, 0.0625f);
                GlStateManager.func_179132_a((boolean)true);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                MODEL_HATCHLING.renderBaby(entity, partialTicks, 0.0625f);
            } else {
                MODEL_EGG.renderEgg(entity, partialTicks, 0.0625f);
            }
            if (isTransparent) {
                GlStateManager.func_187440_b((GlStateManager.Profile)GlStateManager.Profile.TRANSPARENT_MODEL);
            }
        }
    }

    private void renderFoodCraved(ItemStack foodCraved, double x, double y, double z, float scale) {
        if (!foodCraved.func_190926_b()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)x, (double)y, (double)z);
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
            GlStateManager.func_179114_b((float)(-Minecraft.func_71410_x().func_175598_ae().field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
            Minecraft.func_71410_x().func_175599_af().func_181564_a(foodCraved, ItemCameraTransforms.TransformType.FIXED);
            GlStateManager.func_179121_F();
        }
    }

    protected ResourceLocation getEntityTexture(EntityChiromawHatchling entity) {
        if (entity.getHasHatched()) {
            if (entity.getElectricBoogaloo()) {
                if (entity.blinkCount <= 10 && entity.blinkCount > 8 || entity.blinkCount <= 4 && entity.blinkCount > 2) {
                    return TEXTURE_HATCHLING_LIGHTNING_BLINK_1;
                }
                if (entity.blinkCount <= 8 && entity.blinkCount > 6 || entity.blinkCount <= 2 && entity.blinkCount > 0) {
                    return TEXTURE_HATCHLING_LIGHTNING_BLINK_2;
                }
                return TEXTURE_HATCHLING_LIGHTNING;
            }
            if (entity.blinkCount <= 10 && entity.blinkCount > 8 || entity.blinkCount <= 4 && entity.blinkCount > 2) {
                return TEXTURE_HATCHLING_BLINK_1;
            }
            if (entity.blinkCount <= 8 && entity.blinkCount > 6 || entity.blinkCount <= 2 && entity.blinkCount > 0) {
                return TEXTURE_HATCHLING_BLINK_2;
            }
            return TEXTURE_HATCHLING;
        }
        return TEXTURE_EGG;
    }
}

