/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.entity;

import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderArrow;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.render.model.entity.ModelWormArrow;
import thebetweenlands.client.render.shader.LightSource;
import thebetweenlands.client.render.shader.ShaderHelper;
import thebetweenlands.common.entity.projectiles.EntityBLArrow;
import thebetweenlands.common.item.tools.bow.EnumArrowType;

@SideOnly(value=Side.CLIENT)
public class RenderBLArrow
extends RenderArrow<EntityBLArrow> {
    private static final ResourceLocation TEXTURE_ANGLER_TOOTH = new ResourceLocation("thebetweenlands:textures/entity/angler_tooth_arrow.png");
    private static final ResourceLocation TEXTURE_POISONED_ANGLER_TOOTH = new ResourceLocation("thebetweenlands:textures/entity/poisoned_angler_tooth_arrow.png");
    private static final ResourceLocation TEXTURE_OCTINE = new ResourceLocation("thebetweenlands:textures/entity/octine_arrow.png");
    private static final ResourceLocation TEXTURE_BASILISK = new ResourceLocation("thebetweenlands:textures/entity/basilisk_arrow.png");
    public static final ResourceLocation TEXTURE_WORM = new ResourceLocation("thebetweenlands:textures/entity/tiny_sludge_worm.png");
    private static final ResourceLocation TEXTURE_CHIROMAW_BARB = new ResourceLocation("thebetweenlands:textures/entity/chiromaw_barb.png");
    private static final ResourceLocation TEXTURE_SHOCK = new ResourceLocation("thebetweenlands:textures/entity/shock_arrow.png");
    public static final ModelWormArrow WORM_MODEL = new ModelWormArrow();

    public RenderBLArrow(RenderManager renderManager) {
        super(renderManager);
    }

    public void doRender(EntityBLArrow entity, double x, double y, double z, float entityYaw, float partialTicks) {
        if (entity.getArrowType() == EnumArrowType.WORM) {
            this.renderWormArrow(entity, x, y, z, entityYaw, partialTicks);
        } else {
            if (entity.getArrowType() == EnumArrowType.OCTINE && ShaderHelper.INSTANCE.isWorldShaderActive()) {
                ShaderHelper.INSTANCE.require();
                double rx = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)partialTicks;
                double ry = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)partialTicks;
                double rz = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)partialTicks;
                ShaderHelper.INSTANCE.getWorldShader().addLight(new LightSource(rx, ry, rz, 3.0f, 2.3f, 0.5f, 0.0f));
            }
            super.func_76986_a((EntityArrow)entity, x, y, z, entityYaw, partialTicks);
        }
    }

    private void renderWormArrow(EntityBLArrow entity, double x, double y, double z, float entityYaw, float partialTicks) {
        this.func_180548_c((Entity)entity);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179094_E();
        GlStateManager.func_179140_f();
        GlStateManager.func_179109_b((float)((float)x), (float)((float)y), (float)((float)z));
        GlStateManager.func_179114_b((float)(entity.field_70126_B + (entity.field_70177_z - entity.field_70126_B) * partialTicks - 90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(entity.field_70127_C + (entity.field_70125_A - entity.field_70127_C) * partialTicks), (float)0.0f, (float)0.0f, (float)1.0f);
        float shake = (float)entity.field_70249_b - partialTicks;
        if (shake > 0.0f) {
            float f10 = -MathHelper.func_76126_a((float)(shake * 3.0f)) * shake;
            GlStateManager.func_179114_b((float)f10, (float)0.0f, (float)0.0f, (float)1.0f);
        }
        GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)1.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)-1.5f, (float)0.0f);
        if (this.field_188301_f) {
            GlStateManager.func_179142_g();
            GlStateManager.func_187431_e((int)this.func_188298_c((Entity)entity));
        }
        WORM_MODEL.render();
        if (this.field_188301_f) {
            GlStateManager.func_187417_n();
            GlStateManager.func_179119_h();
        }
        GlStateManager.func_179145_e();
        GlStateManager.func_179121_F();
    }

    protected ResourceLocation getEntityTexture(EntityBLArrow entity) {
        switch (entity.getArrowType()) {
            case ANGLER_POISON: {
                return TEXTURE_POISONED_ANGLER_TOOTH;
            }
            case OCTINE: {
                return TEXTURE_OCTINE;
            }
            case BASILISK: {
                return TEXTURE_BASILISK;
            }
            case WORM: {
                return TEXTURE_WORM;
            }
            case SHOCK: {
                return TEXTURE_SHOCK;
            }
            case CHIROMAW_SHOCK_BARB: 
            case CHIROMAW_BARB: {
                return TEXTURE_CHIROMAW_BARB;
            }
        }
        return TEXTURE_ANGLER_TOOTH;
    }
}

