/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.handler;

import gnu.trove.iterator.TObjectIntIterator;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import thebetweenlands.api.aspect.Aspect;
import thebetweenlands.api.aspect.ItemAspectContainer;
import thebetweenlands.api.capability.IDecayCapability;
import thebetweenlands.api.capability.IEntityCustomCollisionsCapability;
import thebetweenlands.api.capability.IEquipmentCapability;
import thebetweenlands.api.capability.IPortalCapability;
import thebetweenlands.client.gui.SwarmOverlayRenderer;
import thebetweenlands.client.render.block.RingOfDispersionWorldRenderer;
import thebetweenlands.client.render.shader.ResizableFramebuffer;
import thebetweenlands.common.TheBetweenlands;
import thebetweenlands.common.capability.collision.RingOfDispersionEntityCapability;
import thebetweenlands.common.capability.equipment.EnumEquipmentInventory;
import thebetweenlands.common.config.BetweenlandsConfig;
import thebetweenlands.common.entity.EntityRopeNode;
import thebetweenlands.common.herblore.aspect.AspectManager;
import thebetweenlands.common.herblore.book.widgets.text.FormatTags;
import thebetweenlands.common.herblore.book.widgets.text.TextContainer;
import thebetweenlands.common.item.equipment.ItemRingOfDispersion;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.registries.CapabilityRegistry;
import thebetweenlands.common.registries.ItemRegistry;
import thebetweenlands.common.world.storage.BetweenlandsWorldStorage;
import thebetweenlands.common.world.storage.location.LocationStorage;
import thebetweenlands.util.AspectIconRenderer;
import thebetweenlands.util.ColorUtils;

public class ScreenRenderHandler
extends Gui {
    public static ScreenRenderHandler INSTANCE = new ScreenRenderHandler();
    private static final ResourceLocation DECAY_BAR_TEXTURE = new ResourceLocation("thebetweenlands:textures/gui/decay_bar.png");
    private static final ResourceLocation RING_OF_DISPERSION_OVERLAY_TEXTURE = new ResourceLocation("thebetweenlands:textures/gui/overlay/ring_of_dispersion_overlay.png");
    private static final ResourceLocation RING_OF_DISPERSION_OVERLAY_TOP_TEXTURE = new ResourceLocation("thebetweenlands:textures/gui/overlay/ring_of_dispersion_overlay_top.png");
    private static final ResourceLocation RING_OF_DISPERSION_OVERLAY_SIDE_TOP_TEXTURE = new ResourceLocation("thebetweenlands:textures/gui/overlay/ring_of_dispersion_overlay_side_top.png");
    private static final ResourceLocation RING_OF_DISPERSION_OVERLAY_BOTTOM_TEXTURE = new ResourceLocation("thebetweenlands:textures/gui/overlay/ring_of_dispersion_overlay_bottom.png");
    private static final ResourceLocation RING_OF_DISPERSION_OVERLAY_SIDE_BOTTOM_TEXTURE = new ResourceLocation("thebetweenlands:textures/gui/overlay/ring_of_dispersion_overlay_side_bottom.png");
    private static final ResourceLocation RING_OF_DISPERSION_INDICATOR_OVERLAY_TEXTURE = new ResourceLocation("thebetweenlands:textures/gui/overlay/ring_of_dispersion_indicator_overlay.png");
    private static final ResourceLocation VIGNETTE_TEXTURE = new ResourceLocation("textures/misc/vignette.png");
    private Random random = new Random();
    private int updateCounter;
    private double obstructionPercentage = 0.0;
    private double prevObstructionPercentage = 0.0;
    private double dispersionIndicatorPercentage = 0.0;
    private double prevDispersionIndicatorPercentage = 0.0;
    private final ResizableFramebuffer ringOfDispersionWorldFramebuffer = new ResizableFramebuffer(true);
    private final RingOfDispersionWorldRenderer ringOfDispersionWorldRenderer = new RingOfDispersionWorldRenderer(6, 6);
    private TextContainer titleContainer = null;
    private String currentLocation = "";
    private int titleTicks = 0;
    private int maxTitleTicks = 120;
    private int cavingRopeConnectTicks = 0;
    private int cavingRopeCount = 0;
    private final TObjectIntMap<LocationStorage> titleDisplayCooldowns = new TObjectIntHashMap();
    public static final ResourceLocation TITLE_TEXTURE = new ResourceLocation("thebetweenlands:textures/gui/location_title.png");
    public static final ResourceLocation CAVING_ROPE_CONNECTED = new ResourceLocation("thebetweenlands:textures/gui/caving_rope_connected.png");
    public static final ResourceLocation CAVING_ROPE_DISCONNECTED = new ResourceLocation("thebetweenlands:textures/gui/caving_rope_disconnected.png");
    private final SwarmOverlayRenderer crawlerOverlayRenderer = new SwarmOverlayRenderer();

    private ScreenRenderHandler() {
    }

    public static List<LocationStorage> getVisibleLocations(Entity entity) {
        BetweenlandsWorldStorage worldStorage = BetweenlandsWorldStorage.forWorld(entity.field_70170_p);
        return worldStorage.getLocalStorageHandler().getLocalStorages(LocationStorage.class, entity.field_70165_t, entity.field_70161_v, location -> location.isInside(entity.func_174824_e(1.0f)) && location.isVisible(entity));
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START && !Minecraft.func_71410_x().func_147113_T()) {
            EntityPlayerSP player;
            this.crawlerOverlayRenderer.update();
            ++this.updateCounter;
            if (this.titleTicks > 0) {
                --this.titleTicks;
            }
            this.cavingRopeCount = 0;
            if (this.cavingRopeConnectTicks > 0) {
                --this.cavingRopeConnectTicks;
            }
            if ((player = Minecraft.func_71410_x().field_71439_g) != null) {
                IEntityCustomCollisionsCapability cap = (IEntityCustomCollisionsCapability)player.getCapability(CapabilityRegistry.CAPABILITY_ENTITY_CUSTOM_BLOCK_COLLISIONS, null);
                if (cap != null) {
                    this.prevObstructionPercentage = this.obstructionPercentage;
                    double fadeStartDistance = Math.min(cap.getViewObstructionCheckDistance(), 0.25);
                    double obstructionDistance = cap.getViewObstructionDistance();
                    this.obstructionPercentage = obstructionDistance < fadeStartDistance ? 1.0 - obstructionDistance / fadeStartDistance : 0.0;
                } else {
                    this.prevObstructionPercentage = 0.0;
                    this.obstructionPercentage = 0.0;
                }
                this.prevDispersionIndicatorPercentage = this.dispersionIndicatorPercentage;
                float targetDispersionPercentage = 0.0f;
                ItemStack ring = RingOfDispersionEntityCapability.getRing((EntityPlayer)player);
                if (!ring.func_190926_b()) {
                    ItemRingOfDispersion item = (ItemRingOfDispersion)ring.func_77973_b();
                    targetDispersionPercentage = (float)item.getTimer(ring) / (float)item.getMaxPhasingDuration(ring);
                }
                if (this.dispersionIndicatorPercentage < (double)targetDispersionPercentage) {
                    this.dispersionIndicatorPercentage += 0.005;
                    if (this.dispersionIndicatorPercentage > (double)targetDispersionPercentage) {
                        this.dispersionIndicatorPercentage = targetDispersionPercentage;
                    }
                } else if (this.dispersionIndicatorPercentage > (double)targetDispersionPercentage) {
                    this.dispersionIndicatorPercentage -= 0.025;
                    if (this.dispersionIndicatorPercentage < (double)targetDispersionPercentage) {
                        this.dispersionIndicatorPercentage = targetDispersionPercentage;
                    }
                }
                if (BetweenlandsConfig.GENERAL.cavingRopeIndicator) {
                    for (ItemStack stack : player.field_71071_by.field_70462_a) {
                        if (stack.func_190926_b() || stack.func_77973_b() != ItemRegistry.CAVING_ROPE) continue;
                        this.cavingRopeCount += stack.func_190916_E();
                    }
                }
                TObjectIntIterator titleDisplayCooldownsIT = this.titleDisplayCooldowns.iterator();
                while (titleDisplayCooldownsIT.hasNext()) {
                    titleDisplayCooldownsIT.advance();
                    int cooldown = titleDisplayCooldownsIT.value();
                    if (cooldown > 1) {
                        this.titleDisplayCooldowns.put(titleDisplayCooldownsIT.key(), cooldown - 1);
                        continue;
                    }
                    titleDisplayCooldownsIT.remove();
                }
                if (player.field_71093_bK == BetweenlandsConfig.WORLD_AND_DIMENSION.dimensionId) {
                    String prevLocation = this.currentLocation;
                    List<LocationStorage> locations = ScreenRenderHandler.getVisibleLocations((Entity)player);
                    if (locations.isEmpty()) {
                        String location;
                        if (player.field_70163_u < 100.0) {
                            String wildernessName = I18n.func_135052_a((String)"location.wilderness.name", (Object[])new Object[0]);
                            if (this.currentLocation.equals(wildernessName)) {
                                prevLocation = "";
                            }
                            location = I18n.func_135052_a((String)"location.caverns.name", (Object[])new Object[0]);
                        } else {
                            String cavernsName = I18n.func_135052_a((String)"location.caverns.name", (Object[])new Object[0]);
                            if (this.currentLocation.equals(cavernsName)) {
                                prevLocation = "";
                            }
                            location = I18n.func_135052_a((String)"location.wilderness.name", (Object[])new Object[0]);
                        }
                        this.currentLocation = location;
                    } else {
                        LocationStorage highestLocation = null;
                        for (LocationStorage storage : locations) {
                            if (highestLocation != null && storage.getLayer() <= highestLocation.getLayer()) continue;
                            highestLocation = storage;
                        }
                        int displayCooldown = 1200;
                        int currentCooldown = this.titleDisplayCooldowns.get(highestLocation);
                        if (currentCooldown == 0) {
                            this.titleDisplayCooldowns.put((Object)highestLocation, displayCooldown);
                            this.currentLocation = highestLocation.hasLocalizedName() ? highestLocation.getLocalizedName() : highestLocation.getName();
                        } else if (currentCooldown > 0) {
                            this.titleDisplayCooldowns.put((Object)highestLocation, displayCooldown);
                        }
                    }
                    if (this.currentLocation.length() > 0) {
                        if (this.currentLocation.contains(":")) {
                            int startIndex = this.currentLocation.indexOf(":");
                            try {
                                String ticks = this.currentLocation.substring(0, startIndex);
                                this.maxTitleTicks = Integer.parseInt(ticks);
                                this.currentLocation = this.currentLocation.substring(startIndex + 1, this.currentLocation.length());
                            }
                            catch (Exception ex) {
                                this.maxTitleTicks = 80;
                            }
                        }
                        if (prevLocation != null && !prevLocation.equals(this.currentLocation)) {
                            this.titleTicks = this.maxTitleTicks;
                            this.titleContainer = new TextContainer(2048.0, 2048.0, this.currentLocation, TheBetweenlands.proxy.getCustomFontRenderer());
                            this.titleContainer.setCurrentScale(2.0f).setCurrentColor(-1);
                            this.titleContainer.registerTag(new FormatTags.TagNewLine());
                            this.titleContainer.registerTag(new FormatTags.TagScale(2.0f));
                            this.titleContainer.registerTag(new FormatTags.TagSimple("bold", TextFormatting.BOLD));
                            this.titleContainer.registerTag(new FormatTags.TagSimple("obfuscated", TextFormatting.OBFUSCATED));
                            this.titleContainer.registerTag(new FormatTags.TagSimple("italic", TextFormatting.ITALIC));
                            this.titleContainer.registerTag(new FormatTags.TagSimple("strikethrough", TextFormatting.STRIKETHROUGH));
                            this.titleContainer.registerTag(new FormatTags.TagSimple("underline", TextFormatting.UNDERLINE));
                            try {
                                this.titleContainer.parse();
                            }
                            catch (Exception e) {
                                this.titleContainer = null;
                                e.printStackTrace();
                            }
                        }
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onRenderGameOverlay(RenderGameOverlayEvent.Post event) {
        IPortalCapability cap;
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        int width = event.getResolution().func_78326_a();
        int height = event.getResolution().func_78328_b();
        if (event.getType() == RenderGameOverlayEvent.ElementType.CROSSHAIRS) {
            this.crawlerOverlayRenderer.render(event.getPartialTicks());
            if (BetweenlandsConfig.GENERAL.cavingRopeIndicator && player != null) {
                BufferBuilder buffer;
                Tessellator tessellator;
                boolean connected = false;
                List ropeNodes = player.field_70170_p.func_72872_a(EntityRopeNode.class, player.func_174813_aQ().func_72314_b(32.0, 32.0, 32.0));
                for (EntityRopeNode rope : ropeNodes) {
                    if (rope.getNextNode() != player) continue;
                    connected = true;
                    break;
                }
                if (connected) {
                    this.cavingRopeConnectTicks = 80;
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179109_b((float)(width / 2), (float)(height / 2), (float)0.0f);
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    GlStateManager.func_179084_k();
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179109_b((float)14.0f, (float)14.0f, (float)0.0f);
                    GlStateManager.func_179139_a((double)0.5, (double)0.5, (double)1.0);
                    mc.field_71466_p.func_78276_b(String.valueOf(this.cavingRopeCount), 0, 0, -1);
                    GlStateManager.func_179121_F();
                    Minecraft.func_71410_x().field_71446_o.func_110577_a(CAVING_ROPE_CONNECTED);
                    tessellator = Tessellator.func_178181_a();
                    buffer = tessellator.func_178180_c();
                    buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                    this.renderTexturedRect(buffer, 2.0, 2.0, 18.0, 18.0, 0.0, 1.0, 0.0, 1.0);
                    tessellator.func_78381_a();
                    GlStateManager.func_179147_l();
                    GlStateManager.func_179121_F();
                } else if (!connected && this.cavingRopeConnectTicks > 0) {
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179109_b((float)(width / 2), (float)(height / 2), (float)0.0f);
                    GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                    GlStateManager.func_179092_a((int)516, (float)0.0f);
                    GlStateManager.func_179147_l();
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)MathHelper.func_76131_a((float)((float)this.cavingRopeConnectTicks / 80.0f * (0.8f + 0.2f * (float)Math.sin(((float)(this.cavingRopeConnectTicks + 1) - event.getPartialTicks()) / 2.0f))), (float)0.0f, (float)1.0f));
                    Minecraft.func_71410_x().field_71446_o.func_110577_a(CAVING_ROPE_DISCONNECTED);
                    tessellator = Tessellator.func_178181_a();
                    buffer = tessellator.func_178180_c();
                    buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                    this.renderTexturedRect(buffer, 2.0, 2.0, 18.0, 18.0, 0.0, 1.0, 0.0, 1.0);
                    tessellator.func_78381_a();
                    GlStateManager.func_179092_a((int)516, (float)0.1f);
                    GlStateManager.func_179121_F();
                }
            }
        } else if (event.getType() == RenderGameOverlayEvent.ElementType.HOTBAR) {
            if (player != null && !player.func_175149_v()) {
                Object capability;
                if (BetweenlandsConfig.GENERAL.equipmentVisible && (capability = (IEquipmentCapability)player.getCapability(CapabilityRegistry.CAPABILITY_EQUIPMENT, null)) != null) {
                    EnumHandSide offhand = player.func_184591_cq().func_188468_a();
                    int posX = 0;
                    int posY = 0;
                    boolean isOnOppositeSide = BetweenlandsConfig.GENERAL.equipmentHotbarSide == 1;
                    boolean showOnRightSide = offhand == EnumHandSide.LEFT != isOnOppositeSide;
                    switch (BetweenlandsConfig.GENERAL.equipmentZone) {
                        default: {
                            if (showOnRightSide) {
                                posX = width / 2 + 93;
                                if (isOnOppositeSide && !player.func_184586_b(EnumHand.OFF_HAND).func_190926_b()) {
                                    posX += 30;
                                }
                            } else {
                                posX = width / 2 - 93 - 16;
                                if (isOnOppositeSide && !player.func_184586_b(EnumHand.OFF_HAND).func_190926_b()) {
                                    posX -= 30;
                                }
                            }
                            posY = height - 19;
                            break;
                        }
                        case 1: {
                            posX = 0;
                            posY = 0;
                            break;
                        }
                        case 2: {
                            posX = width - 18;
                            posY = 0;
                            break;
                        }
                        case 3: {
                            posX = width - 18;
                            posY = height - 18;
                            break;
                        }
                        case 4: {
                            posX = 0;
                            posY = height - 18;
                            break;
                        }
                        case 5: {
                            posX = 0;
                            posY = height / 2;
                            break;
                        }
                        case 6: {
                            posX = width / 2;
                            posY = 0;
                            break;
                        }
                        case 7: {
                            posX = width - 18;
                            posY = height / 2;
                            break;
                        }
                        case 8: {
                            posX = width / 2;
                            posY = height - 18;
                        }
                    }
                    posX += BetweenlandsConfig.GENERAL.equipmentOffsetX;
                    posY += BetweenlandsConfig.GENERAL.equipmentOffsetY;
                    int yOffset = 0;
                    for (EnumEquipmentInventory type : EnumEquipmentInventory.VALUES) {
                        IInventory inv = capability.getInventory(type);
                        int xOffset = 0;
                        boolean hadItem = false;
                        for (int i = 0; i < inv.func_70302_i_(); ++i) {
                            ItemStack stack = inv.func_70301_a(i);
                            if (stack.func_190926_b()) continue;
                            float scale = 1.0f;
                            GlStateManager.func_179094_E();
                            GlStateManager.func_179109_b((float)(posX + xOffset), (float)(posY + yOffset), (float)0.0f);
                            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                            GlStateManager.func_179147_l();
                            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                            GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
                            mc.func_175599_af().func_180450_b(stack, 0, 0);
                            mc.func_175599_af().func_180453_a(mc.field_71466_p, stack, 0, 0, null);
                            GlStateManager.func_179118_c();
                            GlStateManager.func_179101_C();
                            GlStateManager.func_179140_f();
                            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                            GlStateManager.func_179147_l();
                            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                            GlStateManager.func_179098_w();
                            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                            GlStateManager.func_179121_F();
                            xOffset = showOnRightSide ? (xOffset += BetweenlandsConfig.GENERAL.equipmentHorizontalSpacing) : (xOffset -= BetweenlandsConfig.GENERAL.equipmentHorizontalSpacing);
                            hadItem = true;
                        }
                        if (!hadItem) continue;
                        yOffset += BetweenlandsConfig.GENERAL.equipmentVerticalSpacing;
                    }
                }
                if ((capability = (IDecayCapability)player.getCapability(CapabilityRegistry.CAPABILITY_DECAY, null)) != null && capability.isDecayEnabled()) {
                    int startX = 0;
                    int startY = 0;
                    switch (BetweenlandsConfig.GENERAL.decayBarZone) {
                        default: {
                            Entity ridingEntity;
                            int duration;
                            startX = width / 2 - 13 + 23;
                            startY = height - 49;
                            if (player.getEntityData().func_74764_b("antivenomDuration") && (duration = player.getEntityData().func_74762_e("antivenomDuration")) > 0) {
                                startY -= 12;
                            }
                            if (TheBetweenlands.isToughAsNailsModInstalled) {
                                startY -= 10;
                            }
                            if ((ridingEntity = player.func_184187_bx()) != null && ridingEntity instanceof EntityLivingBase) {
                                EntityLivingBase riddenEntity = (EntityLivingBase)ridingEntity;
                                float maxEntityHealth = riddenEntity.func_110138_aP();
                                int maxHealthHearts = (int)(maxEntityHealth + 0.5f) / 2;
                                if (maxHealthHearts > 30) {
                                    maxHealthHearts = 30;
                                }
                                int guiOffsetY = 0;
                                while (maxHealthHearts > 0) {
                                    int renderedHearts = Math.min(maxHealthHearts, 10);
                                    maxHealthHearts -= renderedHearts;
                                    guiOffsetY -= 10;
                                }
                                startY += guiOffsetY;
                            }
                            if (!player.func_70055_a(Material.field_151586_h)) break;
                            startY -= 10;
                            break;
                        }
                        case 1: {
                            startX = 0;
                            startY = 0;
                            break;
                        }
                        case 2: {
                            startX = width;
                            startY = 0;
                            break;
                        }
                        case 3: {
                            startX = width;
                            startY = height;
                            break;
                        }
                        case 4: {
                            startX = 0;
                            startY = height;
                            break;
                        }
                        case 5: {
                            startX = 0;
                            startY = height / 2;
                            break;
                        }
                        case 6: {
                            startX = width / 2;
                            startY = 0;
                            break;
                        }
                        case 7: {
                            startX = width;
                            startY = height / 2;
                            break;
                        }
                        case 8: {
                            startX = width / 2;
                            startY = height;
                        }
                    }
                    startX += BetweenlandsConfig.GENERAL.decayBarOffsetX;
                    startY += BetweenlandsConfig.GENERAL.decayBarOffsetY;
                    int decay = 20 - capability.getDecayStats().getDecayLevel();
                    Minecraft.func_71410_x().func_110434_K().func_110577_a(DECAY_BAR_TEXTURE);
                    for (int i = 0; i < 10; ++i) {
                        int offsetY = 0;
                        if (this.updateCounter % (decay * 3 + 1) == 0) {
                            offsetY += this.random.nextInt(3) - 1;
                        }
                        GlStateManager.func_179147_l();
                        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        this.func_73729_b(startX + 71 - i * 8, startY + offsetY, 18, 0, 9, 9);
                        if (i * 2 + 1 < decay) {
                            this.func_73729_b(startX + 71 - i * 8, startY + offsetY, 0, 0, 9, 9);
                        }
                        if (i * 2 + 1 != decay) continue;
                        this.func_73729_b(startX + 72 - i * 8, startY + offsetY, 9, 0, 9, 9);
                    }
                }
            }
        } else if (event.getType() == RenderGameOverlayEvent.ElementType.TEXT) {
            if (this.titleTicks > 0 && this.titleContainer != null && !this.titleContainer.getPages().isEmpty()) {
                TextContainer.TextPage page = this.titleContainer.getPages().get(0);
                double strWidth = page.getTextWidth();
                double strHeight = page.getTextHeight();
                double strX = (double)width / 2.0 - strWidth / 2.0;
                double strY = (double)height / 5.0;
                GlStateManager.func_179094_E();
                GlStateManager.func_179137_b((double)strX, (double)strY, (double)0.0);
                float fade = Math.min(1.0f, ((float)this.maxTitleTicks - (float)this.titleTicks) / Math.min(40.0f, (float)this.maxTitleTicks - 5.0f) + 0.02f) - Math.max(0.0f, (float)(-this.titleTicks + 5) / 5.0f);
                GlStateManager.func_179092_a((int)516, (float)0.0f);
                GlStateManager.func_179147_l();
                float averageScale = 0.0f;
                for (TextContainer.TextSegment segment : page.getSegments()) {
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179137_b((double)segment.x, (double)segment.y, (double)0.0);
                    GlStateManager.func_179152_a((float)segment.scale, (float)segment.scale, (float)1.0f);
                    float[] rgba = ColorUtils.getRGBA(segment.color);
                    segment.font.func_78276_b(segment.text, 0, 0, ColorUtils.toHex(rgba[0], rgba[1], rgba[2], rgba[3] * fade));
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    GlStateManager.func_179121_F();
                    averageScale += segment.scale;
                }
                averageScale /= (float)page.getSegments().size();
                GlStateManager.func_179121_F();
                Minecraft.func_71410_x().field_71446_o.func_110577_a(TITLE_TEXTURE);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)fade);
                double sidePadding = 6.0;
                double yOffset = 5.0;
                double sy = Math.ceil(strY + strHeight - yOffset * (double)averageScale);
                double ey = Math.ceil(strY + strHeight + (-yOffset + 16.0) * (double)averageScale);
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder buffer = tessellator.func_178180_c();
                buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                this.renderTexturedRect(buffer, strX - sidePadding * (double)averageScale, sy, strX - sidePadding * (double)averageScale + (double)(9.0f * averageScale), ey, 0.0, 0.0703125, 0.0, 1.0);
                this.renderTexturedRect(buffer, strX - sidePadding * (double)averageScale + (double)(9.0f * averageScale), sy, strX + strWidth / 2.0 - (double)(6.0f * averageScale), ey, 0.0703125, 0.453125, 0.0, 1.0);
                this.renderTexturedRect(buffer, strX + strWidth / 2.0 - (double)(6.0f * averageScale), sy, strX + strWidth / 2.0 + (double)(6.0f * averageScale), ey, 0.453125, 0.546875, 0.0, 1.0);
                this.renderTexturedRect(buffer, strX + strWidth / 2.0 + (double)(6.0f * averageScale), sy, strX + strWidth + sidePadding * (double)averageScale - (double)(9.0f * averageScale), ey, 0.546875, 0.9296875, 0.0, 1.0);
                this.renderTexturedRect(buffer, strX + strWidth + sidePadding * (double)averageScale - (double)(9.0f * averageScale), sy, strX + strWidth + sidePadding * (double)averageScale, ey, 0.9296875, 1.0, 0.0, 1.0);
                tessellator.func_78381_a();
                GlStateManager.func_179092_a((int)516, (float)0.1f);
            }
        } else if (event.getType() == RenderGameOverlayEvent.ElementType.PORTAL && player != null && (cap = (IPortalCapability)player.getCapability(CapabilityRegistry.CAPABILITY_PORTAL, null)) != null && cap.isInPortal()) {
            this.renderPortal(mc, MathHelper.func_76131_a((float)(1.0f - (float)cap.getTicksUntilTeleport() / 120.0f), (float)0.0f, (float)1.0f), event.getResolution());
        }
    }

    @SubscribeEvent
    public void onRenderGameOverlay(RenderGameOverlayEvent.Pre event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.ALL) {
            Minecraft mc = Minecraft.func_71410_x();
            EntityPlayerSP player = mc.field_71439_g;
            if (player != null) {
                this.renderDispersionRingOverlay(mc, (EntityPlayer)player, true, event.getPartialTicks());
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public void onRenderWorldLast(RenderWorldLastEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        if (player != null) {
            GlStateManager.func_179128_n((int)5889);
            GlStateManager.func_179094_E();
            GlStateManager.func_179128_n((int)5888);
            GlStateManager.func_179094_E();
            ScaledResolution scaledresolution = new ScaledResolution(mc);
            GlStateManager.func_179128_n((int)5889);
            GlStateManager.func_179096_D();
            GlStateManager.func_179130_a((double)0.0, (double)scaledresolution.func_78327_c(), (double)scaledresolution.func_78324_d(), (double)0.0, (double)1000.0, (double)3000.0);
            GlStateManager.func_179128_n((int)5888);
            GlStateManager.func_179096_D();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-2000.0f);
            this.renderDispersionRingOverlay(mc, (EntityPlayer)player, false, event.getPartialTicks());
            GlStateManager.func_179084_k();
            GlStateManager.func_179128_n((int)5889);
            GlStateManager.func_179121_F();
            GlStateManager.func_179128_n((int)5888);
            GlStateManager.func_179121_F();
        }
    }

    private void renderDispersionRingOverlay(Minecraft mc, EntityPlayer player, boolean guiOverlay, float partialTicks) {
        float indicatorAlpha;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        ScaledResolution res = new ScaledResolution(mc);
        GlStateManager.func_179118_c();
        GlStateManager.func_179090_x();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179097_i();
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        IEntityCustomCollisionsCapability cap = (IEntityCustomCollisionsCapability)player.getCapability(CapabilityRegistry.CAPABILITY_ENTITY_CUSTOM_BLOCK_COLLISIONS, null);
        if (cap != null) {
            double viewFadeStartDistance = Math.min(cap.getViewObstructionCheckDistance(), 0.25);
            double viewObstructionDistance = cap.getViewObstructionDistance();
            if (viewObstructionDistance < viewFadeStartDistance) {
                float alpha = (float)Math.min(1.0, Math.max(0.0, this.prevObstructionPercentage + (this.obstructionPercentage - this.prevObstructionPercentage) * (double)partialTicks));
                GlStateManager.func_179131_c((float)0.0f, (float)0.0f, (float)0.0f, (float)alpha);
                if (!guiOverlay) {
                    bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181705_e);
                    bufferbuilder.func_181662_b(0.0, res.func_78324_d(), 0.0).func_181675_d();
                    bufferbuilder.func_181662_b(res.func_78327_c(), res.func_78324_d(), 0.0).func_181675_d();
                    bufferbuilder.func_181662_b(res.func_78327_c(), 0.0, 0.0).func_181675_d();
                    bufferbuilder.func_181662_b(0.0, 0.0, 0.0).func_181675_d();
                    tessellator.func_78381_a();
                } else {
                    bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181705_e);
                    bufferbuilder.func_181662_b(0.0, res.func_78324_d(), 0.0).func_181675_d();
                    bufferbuilder.func_181662_b(res.func_78327_c(), res.func_78324_d(), 0.0).func_181675_d();
                    bufferbuilder.func_181662_b(res.func_78327_c(), 0.0, 0.0).func_181675_d();
                    bufferbuilder.func_181662_b(0.0, 0.0, 0.0).func_181675_d();
                    tessellator.func_78381_a();
                    float brightness = 0.5f + (1.0f - alpha) * 0.5f;
                    Framebuffer dispersionWorldFbo = null;
                    GlStateManager.func_179128_n((int)5889);
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179128_n((int)5888);
                    GlStateManager.func_179094_E();
                    mc.field_71460_t.func_78479_a(partialTicks, 0);
                    this.ringOfDispersionWorldRenderer.setPos(new BlockPos(player.func_174791_d()));
                    this.ringOfDispersionWorldRenderer.setWorld(player.field_70170_p);
                    GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                    GlStateManager.func_179126_j();
                    GlStateManager.func_179132_a((boolean)true);
                    Framebuffer mainFbo = mc.func_147110_a();
                    dispersionWorldFbo = this.ringOfDispersionWorldFramebuffer.getFramebuffer(mainFbo.field_147621_c, mainFbo.field_147618_d);
                    dispersionWorldFbo.func_147614_f();
                    dispersionWorldFbo.func_147610_a(true);
                    this.ringOfDispersionWorldRenderer.render();
                    mainFbo.func_147610_a(true);
                    GlStateManager.func_179097_i();
                    GlStateManager.func_179132_a((boolean)false);
                    GlStateManager.func_179128_n((int)5889);
                    GlStateManager.func_179121_F();
                    GlStateManager.func_179128_n((int)5888);
                    GlStateManager.func_179121_F();
                    GlStateManager.func_179147_l();
                    GlStateManager.func_179140_f();
                    GlStateManager.func_179131_c((float)brightness, (float)brightness, (float)brightness, (float)(alpha * alpha * alpha * 0.75f));
                    GlStateManager.func_179098_w();
                    GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                    GlStateManager.func_179144_i((int)dispersionWorldFbo.field_147617_g);
                    bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                    bufferbuilder.func_181662_b(0.0, res.func_78324_d(), -90.0).func_187315_a(0.0, 0.0).func_181675_d();
                    bufferbuilder.func_181662_b(res.func_78327_c(), res.func_78324_d(), -90.0).func_187315_a(1.0, 0.0).func_181675_d();
                    bufferbuilder.func_181662_b(res.func_78327_c(), 0.0, -90.0).func_187315_a(1.0, 1.0).func_181675_d();
                    bufferbuilder.func_181662_b(0.0, 0.0, -90.0).func_187315_a(0.0, 1.0).func_181675_d();
                    tessellator.func_78381_a();
                    GlStateManager.func_179131_c((float)brightness, (float)brightness, (float)brightness, (float)alpha);
                    GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                    float centerPieceWidth = (float)(res.func_78324_d() / 2.0);
                    float centerStart = (float)(res.func_78327_c() / 2.0 - (double)centerPieceWidth / 2.0);
                    float centerEnd = (float)(res.func_78327_c() / 2.0 + (double)centerPieceWidth / 2.0);
                    mc.func_110434_K().func_110577_a(RING_OF_DISPERSION_OVERLAY_TEXTURE);
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179137_b((double)0.0, (double)(-res.func_78324_d() / 2.0 + res.func_78324_d() / 2.0 * (double)alpha), (double)0.0);
                    bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                    bufferbuilder.func_181662_b(0.0, res.func_78324_d() / 2.0, -90.0).func_187315_a(0.0, 0.5).func_181675_d();
                    bufferbuilder.func_181662_b((double)centerStart, res.func_78324_d() / 2.0, -90.0).func_187315_a(0.333, 0.5).func_181675_d();
                    bufferbuilder.func_181662_b((double)centerStart, 0.0, -90.0).func_187315_a(0.333, 0.0).func_181675_d();
                    bufferbuilder.func_181662_b(0.0, 0.0, -90.0).func_187315_a(0.0, 0.0).func_181675_d();
                    bufferbuilder.func_181662_b((double)centerStart, res.func_78324_d() / 2.0, -90.0).func_187315_a(0.333, 0.5).func_181675_d();
                    bufferbuilder.func_181662_b((double)centerEnd, res.func_78324_d() / 2.0, -90.0).func_187315_a(0.666, 0.5).func_181675_d();
                    bufferbuilder.func_181662_b((double)centerEnd, 0.0, -90.0).func_187315_a(0.666, 0.0).func_181675_d();
                    bufferbuilder.func_181662_b((double)centerStart, 0.0, -90.0).func_187315_a(0.333, 0.0).func_181675_d();
                    bufferbuilder.func_181662_b((double)centerEnd, res.func_78324_d() / 2.0, -90.0).func_187315_a(0.666, 0.5).func_181675_d();
                    bufferbuilder.func_181662_b(res.func_78327_c(), res.func_78324_d() / 2.0, -90.0).func_187315_a(1.0, 0.5).func_181675_d();
                    bufferbuilder.func_181662_b(res.func_78327_c(), 0.0, -90.0).func_187315_a(1.0, 0.0).func_181675_d();
                    bufferbuilder.func_181662_b((double)centerEnd, 0.0, -90.0).func_187315_a(0.666, 0.0).func_181675_d();
                    tessellator.func_78381_a();
                    GlStateManager.func_179121_F();
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179137_b((double)0.0, (double)(res.func_78324_d() / 2.0 - res.func_78324_d() / 2.0 * (double)alpha), (double)0.0);
                    bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                    bufferbuilder.func_181662_b(0.0, res.func_78324_d(), -90.0).func_187315_a(0.0, 1.0).func_181675_d();
                    bufferbuilder.func_181662_b((double)centerStart, res.func_78324_d(), -90.0).func_187315_a(0.333, 1.0).func_181675_d();
                    bufferbuilder.func_181662_b((double)centerStart, res.func_78324_d() / 2.0, -90.0).func_187315_a(0.333, 0.5).func_181675_d();
                    bufferbuilder.func_181662_b(0.0, res.func_78324_d() / 2.0, -90.0).func_187315_a(0.0, 0.5).func_181675_d();
                    bufferbuilder.func_181662_b((double)centerStart, res.func_78324_d(), -90.0).func_187315_a(0.333, 1.0).func_181675_d();
                    bufferbuilder.func_181662_b((double)centerEnd, res.func_78324_d(), -90.0).func_187315_a(0.666, 1.0).func_181675_d();
                    bufferbuilder.func_181662_b((double)centerEnd, res.func_78324_d() / 2.0, -90.0).func_187315_a(0.666, 0.5).func_181675_d();
                    bufferbuilder.func_181662_b((double)centerStart, res.func_78324_d() / 2.0, -90.0).func_187315_a(0.333, 0.5).func_181675_d();
                    bufferbuilder.func_181662_b((double)centerEnd, res.func_78324_d(), -90.0).func_187315_a(0.666, 1.0).func_181675_d();
                    bufferbuilder.func_181662_b(res.func_78327_c(), res.func_78324_d(), -90.0).func_187315_a(1.0, 1.0).func_181675_d();
                    bufferbuilder.func_181662_b(res.func_78327_c(), res.func_78324_d() / 2.0, -90.0).func_187315_a(1.0, 0.5).func_181675_d();
                    bufferbuilder.func_181662_b((double)centerEnd, res.func_78324_d() / 2.0, -90.0).func_187315_a(0.666, 0.5).func_181675_d();
                    tessellator.func_78381_a();
                    GlStateManager.func_179121_F();
                    GlStateManager.func_179131_c((float)((1.0f - brightness) * 2.0f), (float)((1.0f - brightness) * 2.0f), (float)((1.0f - brightness) * 2.0f), (float)1.0f);
                    mc.func_110434_K().func_110577_a(VIGNETTE_TEXTURE);
                    GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                    bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                    bufferbuilder.func_181662_b(0.0, res.func_78324_d(), -90.0).func_187315_a(0.0, 1.0).func_181675_d();
                    bufferbuilder.func_181662_b(res.func_78327_c(), res.func_78324_d(), -90.0).func_187315_a(1.0, 1.0).func_181675_d();
                    bufferbuilder.func_181662_b(res.func_78327_c(), 0.0, -90.0).func_187315_a(1.0, 0.0).func_181675_d();
                    bufferbuilder.func_181662_b(0.0, 0.0, -90.0).func_187315_a(0.0, 0.0).func_181675_d();
                    tessellator.func_78381_a();
                    GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                }
            }
        }
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179098_w();
        GlStateManager.func_179141_d();
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        if (guiOverlay && (indicatorAlpha = (float)(this.prevDispersionIndicatorPercentage + (this.dispersionIndicatorPercentage - this.prevDispersionIndicatorPercentage) * (double)partialTicks)) > 0.01f) {
            GlStateManager.func_179092_a((int)516, (float)0.01f);
            GlStateManager.func_179131_c((float)indicatorAlpha, (float)indicatorAlpha, (float)indicatorAlpha, (float)indicatorAlpha);
            mc.func_110434_K().func_110577_a(RING_OF_DISPERSION_INDICATOR_OVERLAY_TEXTURE);
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            bufferbuilder.func_181662_b(0.0, res.func_78324_d(), -90.0).func_187315_a(0.0, 1.0).func_181675_d();
            bufferbuilder.func_181662_b(res.func_78327_c(), res.func_78324_d(), -90.0).func_187315_a(1.0, 1.0).func_181675_d();
            bufferbuilder.func_181662_b(res.func_78327_c(), 0.0, -90.0).func_187315_a(1.0, 0.0).func_181675_d();
            bufferbuilder.func_181662_b(0.0, 0.0, -90.0).func_187315_a(0.0, 0.0).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.func_179092_a((int)516, (float)0.1f);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179098_w();
        GlStateManager.func_179141_d();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179126_j();
    }

    protected void renderPortal(Minecraft mc, float timeInPortal, ScaledResolution scaledRes) {
        if (timeInPortal < 1.0f) {
            timeInPortal *= timeInPortal;
            timeInPortal = timeInPortal * 0.8f + 0.2f;
        }
        GlStateManager.func_179118_c();
        GlStateManager.func_179097_i();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)timeInPortal);
        mc.func_110434_K().func_110577_a(TextureMap.field_110575_b);
        TextureAtlasSprite textureatlassprite = mc.func_175602_ab().func_175023_a().func_178122_a(BlockRegistry.TREE_PORTAL.func_176223_P());
        float f = textureatlassprite.func_94209_e();
        float f1 = textureatlassprite.func_94206_g();
        float f2 = textureatlassprite.func_94212_f();
        float f3 = textureatlassprite.func_94210_h();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b(0.0, (double)scaledRes.func_78328_b(), -90.0).func_187315_a((double)f, (double)f3).func_181675_d();
        bufferbuilder.func_181662_b((double)scaledRes.func_78326_a(), (double)scaledRes.func_78328_b(), -90.0).func_187315_a((double)f2, (double)f3).func_181675_d();
        bufferbuilder.func_181662_b((double)scaledRes.func_78326_a(), 0.0, -90.0).func_187315_a((double)f2, (double)f1).func_181675_d();
        bufferbuilder.func_181662_b(0.0, 0.0, -90.0).func_187315_a((double)f, (double)f1).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179126_j();
        GlStateManager.func_179141_d();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void renderTexturedRect(BufferBuilder buffer, double x, double y, double x2, double y2, double umin, double umax, double vmin, double vmax) {
        buffer.func_181662_b(x, y2, 0.0).func_187315_a(umin, vmax).func_181675_d();
        buffer.func_181662_b(x2, y2, 0.0).func_187315_a(umax, vmax).func_181675_d();
        buffer.func_181662_b(x2, y, 0.0).func_187315_a(umax, vmin).func_181675_d();
        buffer.func_181662_b(x, y, 0.0).func_187315_a(umin, vmin).func_181675_d();
    }

    @SubscribeEvent
    public void onRenderScreen(RenderTooltipEvent.PostText event) {
        if (GuiScreen.func_146272_n()) {
            Minecraft mc = Minecraft.func_71410_x();
            FontRenderer fontRenderer = mc.field_71466_p;
            int yOffset = 0;
            int width = 0;
            List<Aspect> aspects = ItemAspectContainer.fromItem(event.getStack(), AspectManager.get((World)mc.field_71441_e)).getAspects((EntityPlayer)mc.field_71439_g);
            if (aspects != null && aspects.size() > 0) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179126_j();
                GlStateManager.func_179109_b((float)event.getX(), (float)(event.getY() - 29), (float)300.0f);
                for (Aspect aspect : aspects) {
                    String aspectText = aspect.type.getName() + " (" + aspect.getRoundedDisplayAmount() + ")";
                    String aspectTypeText = aspect.type.getType();
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    fontRenderer.func_78276_b(aspectText, 23, 2 + yOffset, -1);
                    fontRenderer.func_78276_b(aspectTypeText, 23, 11 + yOffset, -1);
                    AspectIconRenderer.renderIcon(2, 2 + yOffset, 16, 16, aspect.type.getIcon());
                    int entryWidth = Math.max(fontRenderer.func_78256_a(aspectText), fontRenderer.func_78256_a(aspectTypeText)) + 26;
                    if (entryWidth > width) {
                        width = entryWidth;
                    }
                    yOffset -= 21;
                }
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-1.0f);
                int height = -yOffset;
                int rectX = 0;
                int rectY = yOffset + 20;
                int backgroundColor = -267386864;
                int borderColorStart = 0x505000FF;
                int borderColorEnd = (borderColorStart & 0xFEFEFE) >> 1 | borderColorStart & 0xFF000000;
                GuiUtils.drawGradientRect((int)0, (int)(rectX - 3), (int)(rectY - 4), (int)(rectX + width + 3), (int)(rectY - 3), (int)backgroundColor, (int)backgroundColor);
                GuiUtils.drawGradientRect((int)0, (int)(rectX - 3), (int)(rectY + height + 3), (int)(rectX + width + 3), (int)(rectY + height + 4), (int)backgroundColor, (int)backgroundColor);
                GuiUtils.drawGradientRect((int)0, (int)(rectX - 3), (int)(rectY - 3), (int)(rectX + width + 3), (int)(rectY + height + 3), (int)backgroundColor, (int)backgroundColor);
                GuiUtils.drawGradientRect((int)0, (int)(rectX - 4), (int)(rectY - 3), (int)(rectX - 3), (int)(rectY + height + 3), (int)backgroundColor, (int)backgroundColor);
                GuiUtils.drawGradientRect((int)0, (int)(rectX + width + 3), (int)(rectY - 3), (int)(rectX + width + 4), (int)(rectY + height + 3), (int)backgroundColor, (int)backgroundColor);
                GuiUtils.drawGradientRect((int)0, (int)(rectX - 3), (int)(rectY - 3 + 1), (int)(rectX - 3 + 1), (int)(rectY + height + 3 - 1), (int)borderColorStart, (int)borderColorEnd);
                GuiUtils.drawGradientRect((int)0, (int)(rectX + width + 2), (int)(rectY - 3 + 1), (int)(rectX + width + 3), (int)(rectY + height + 3 - 1), (int)borderColorStart, (int)borderColorEnd);
                GuiUtils.drawGradientRect((int)0, (int)(rectX - 3), (int)(rectY - 3), (int)(rectX + width + 3), (int)(rectY - 3 + 1), (int)borderColorStart, (int)borderColorStart);
                GuiUtils.drawGradientRect((int)0, (int)(rectX - 3), (int)(rectY + height + 2), (int)(rectX + width + 3), (int)(rectY + height + 3), (int)borderColorEnd, (int)borderColorEnd);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179121_F();
            }
        }
    }
}

