/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.handler;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.capability.ISummoningCapability;
import thebetweenlands.api.entity.IEntityCameraOffset;
import thebetweenlands.api.entity.IEntityScreenShake;
import thebetweenlands.common.herblore.elixir.ElixirEffectRegistry;
import thebetweenlands.common.registries.CapabilityRegistry;
import thebetweenlands.common.world.storage.BetweenlandsWorldStorage;
import thebetweenlands.common.world.storage.location.LocationCragrockTower;

public class CameraPositionHandler {
    public static CameraPositionHandler INSTANCE = new CameraPositionHandler();
    private double prevPosX;
    private double prevPosY;
    private double prevPosZ;
    private boolean didChange = false;
    private List<IEntityCameraOffset> offsetEntities = new ArrayList<IEntityCameraOffset>();
    private float shakeStrength = 0.0f;

    private float getShakeStrength(Entity renderViewEntity) {
        float screenShake = 0.0f;
        World world = renderViewEntity.field_70170_p;
        if (renderViewEntity != null) {
            PotionEffect potionEffect;
            Object shake;
            for (Entity entity2 : world.field_72996_f) {
                if (!(entity2 instanceof IEntityScreenShake)) continue;
                shake = (IEntityScreenShake)entity2;
                screenShake += shake.getShakeIntensity(renderViewEntity);
            }
            for (TileEntity tile : world.field_147482_g) {
                if (!(tile instanceof IEntityScreenShake)) continue;
                shake = (IEntityScreenShake)tile;
                screenShake += shake.getShakeIntensity(renderViewEntity);
            }
            BetweenlandsWorldStorage worldData = BetweenlandsWorldStorage.forWorld(world);
            List<LocationCragrockTower> towers = worldData.getLocalStorageHandler().getLocalStorages(LocationCragrockTower.class, renderViewEntity.field_70165_t, renderViewEntity.field_70161_v, location -> location.getInnerBoundingBox().func_72314_b(4.0, 4.0, 4.0).func_72318_a(renderViewEntity.func_174791_d()));
            for (LocationCragrockTower locationCragrockTower : towers) {
                if (!locationCragrockTower.isCrumbling()) continue;
                screenShake = (float)((double)screenShake + Math.min(Math.pow((float)locationCragrockTower.getCrumblingTicks() / 400.0f, 4.0) * (double)0.08f, (double)0.08f));
            }
            List nearbyPlayers = renderViewEntity.field_70170_p.func_175647_a(EntityPlayer.class, renderViewEntity.func_174813_aQ().func_72314_b(32.0, 32.0, 32.0), entity -> (double)entity.func_70032_d(renderViewEntity) <= 32.0);
            for (EntityPlayer player : nearbyPlayers) {
                ISummoningCapability cap = (ISummoningCapability)player.getCapability(CapabilityRegistry.CAPABILITY_SUMMON, null);
                if (cap == null || !cap.isActive()) continue;
                screenShake += (float)(100 - cap.getActiveTicks()) / 100.0f * 0.1f + 0.01f;
            }
            if (renderViewEntity instanceof EntityLivingBase && (potionEffect = ((EntityLivingBase)renderViewEntity).func_70660_b((Potion)ElixirEffectRegistry.EFFECT_SHOCKED.getPotionEffect())) != null) {
                screenShake += Math.min(0.1f, (float)potionEffect.func_76459_b() / 30.0f * 0.1f);
            }
        }
        return MathHelper.func_76131_a((float)screenShake, (float)0.0f, (float)0.15f);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        Entity renderViewEntity = Minecraft.func_71410_x().func_175606_aa();
        if (renderViewEntity != null) {
            this.shakeStrength = this.getShakeStrength(renderViewEntity);
            this.offsetEntities.clear();
            ArrayList<IEntityCameraOffset> offsetEntities = new ArrayList<IEntityCameraOffset>();
            for (Entity entity : renderViewEntity.field_70170_p.field_72996_f) {
                if (!(entity instanceof IEntityCameraOffset)) continue;
                offsetEntities.add((IEntityCameraOffset)entity);
            }
        } else {
            this.shakeStrength = 0.0f;
            this.offsetEntities.clear();
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onRenderTickStart(TickEvent.RenderTickEvent event) {
        Entity renderViewEntity = Minecraft.func_71410_x().func_175606_aa();
        if (renderViewEntity != null) {
            boolean shouldChange;
            boolean bl = shouldChange = this.shakeStrength > 0.0f || !this.offsetEntities.isEmpty();
            if (shouldChange && !Minecraft.func_71410_x().func_147113_T() || this.didChange) {
                if (event.phase == TickEvent.Phase.START) {
                    this.prevPosX = renderViewEntity.field_70165_t;
                    this.prevPosY = renderViewEntity.field_70163_u;
                    this.prevPosZ = renderViewEntity.field_70161_v;
                    Random rnd = renderViewEntity.field_70170_p.field_73012_v;
                    renderViewEntity.field_70165_t += (double)(rnd.nextFloat() * this.shakeStrength);
                    renderViewEntity.field_70163_u += (double)(rnd.nextFloat() * this.shakeStrength);
                    renderViewEntity.field_70161_v += (double)(rnd.nextFloat() * this.shakeStrength);
                    if (!this.offsetEntities.isEmpty()) {
                        IEntityCameraOffset offset;
                        Iterator<IEntityCameraOffset> iterator = this.offsetEntities.iterator();
                        while (!(!iterator.hasNext() || ((Entity)(offset = iterator.next())).func_70089_S() && offset.applyOffset(renderViewEntity, event.renderTickTime))) {
                        }
                    }
                    this.didChange = true;
                } else {
                    renderViewEntity.field_70165_t = this.prevPosX;
                    renderViewEntity.field_70163_u = this.prevPosY;
                    renderViewEntity.field_70161_v = this.prevPosZ;
                    this.didChange = false;
                }
            }
        }
    }
}

