/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.handler;

import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class ArrowPredictionRenderer {
    private static float randYaw = 0.0f;
    private static float randPitch = 0.0f;
    private static boolean randomYawPitchSet = false;
    private static float lastQuality = 0.0f;

    public static void setRandomYawPitch() {
        randomYawPitchSet = false;
    }

    public static void render(float quality) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player.func_184600_cs() == null) {
            return;
        }
        ItemStack stack = player.func_184586_b(player.func_184600_cs());
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemBow)) {
            randomYawPitchSet = false;
            return;
        }
        if (lastQuality != quality || !randomYawPitchSet) {
            randomYawPitchSet = true;
            lastQuality = quality;
            float maxOffset = 3.0f;
            randYaw = (maxOffset / 2.0f - Minecraft.func_71410_x().field_71441_e.field_73012_v.nextFloat() * maxOffset * 2.0f) * (1.0f - quality);
            randPitch = (maxOffset / 2.0f - Minecraft.func_71410_x().field_71441_e.field_73012_v.nextFloat() * maxOffset * 2.0f) * (1.0f - quality);
        }
        int maxDur = stack.func_77988_m() - player.func_184605_cv();
        float strength = (float)maxDur / 20.0f;
        if ((strength = (strength * strength + strength * 2.0f) / 3.0f) < 0.1f || strength > 1.0f) {
            strength = 1.0f;
        }
        double px = player.field_70165_t;
        double py = player.field_70163_u;
        double pz = player.field_70161_v;
        float pYaw = player.field_70177_z;
        float pPitch = player.field_70125_A;
        player.field_70165_t = Minecraft.func_71410_x().func_175598_ae().field_78725_b;
        player.field_70163_u = Minecraft.func_71410_x().func_175598_ae().field_78726_c;
        player.field_70161_v = Minecraft.func_71410_x().func_175598_ae().field_78723_d;
        player.field_70177_z += randYaw;
        player.field_70125_A += randPitch;
        EntityArrowSilent ea = new EntityArrowSilent((World)Minecraft.func_71410_x().field_71441_e, (EntityLivingBase)player);
        ea.func_184547_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, strength * 3.0f, 1.0f);
        player.field_70165_t = px;
        player.field_70163_u = py;
        player.field_70161_v = pz;
        player.field_70177_z = pYaw;
        player.field_70125_A = pPitch;
        double rx = Minecraft.func_71410_x().func_175598_ae().field_78725_b;
        double ry = Minecraft.func_71410_x().func_175598_ae().field_78726_c;
        double rz = Minecraft.func_71410_x().func_175598_ae().field_78723_d;
        double startX = rx - (double)(MathHelper.func_76134_b((float)(player.field_70177_z / 180.0f * (float)Math.PI)) * 0.46f);
        double startY = ry - (double)0.1f + 1.5;
        double startZ = rz - (double)(MathHelper.func_76126_a((float)(player.field_70177_z / 180.0f * (float)Math.PI)) * 0.46f);
        double lastX = startX;
        double lastY = startY;
        double lastZ = startZ;
        float alpha = quality / 1.3f;
        GlStateManager.func_179094_E();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GL11.glEnable((int)2848);
        GlStateManager.func_187441_d((float)(alpha * 3.5f));
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        boolean drawing = true;
        GlStateManager.func_187447_r((int)1);
        for (int i = 0; i < 1000; ++i) {
            Entity hitEntity;
            ea.func_70071_h_();
            GL11.glVertex3d((double)(lastX - rx), (double)(lastY - ry), (double)(lastZ - rz));
            GL11.glVertex3d((double)(ea.field_70165_t - rx), (double)(ea.field_70163_u - ry), (double)(ea.field_70161_v - rz));
            lastX = ea.field_70165_t;
            lastY = ea.field_70163_u;
            lastZ = ea.field_70161_v;
            RayTraceResult collisionPoint = ArrowPredictionRenderer.getCollision(ea);
            if (collisionPoint == null) continue;
            if (collisionPoint.field_72313_a == RayTraceResult.Type.BLOCK) {
                drawing = false;
                GL11.glVertex3d((double)(ea.field_70165_t - rx), (double)(ea.field_70163_u - ry), (double)(ea.field_70161_v - rz));
                GL11.glVertex3d((double)(collisionPoint.field_72307_f.field_72450_a - rx), (double)(collisionPoint.field_72307_f.field_72448_b - ry), (double)(collisionPoint.field_72307_f.field_72449_c - rz));
                GL11.glEnd();
                GL11.glLineWidth((float)2.0f);
                GlStateManager.func_179131_c((float)1.0f, (float)0.0f, (float)0.0f, (float)quality);
                GL11.glEnable((int)2848);
                GL11.glBegin((int)1);
                if (collisionPoint.field_178784_b == EnumFacing.DOWN) {
                    GL11.glVertex3d((double)(collisionPoint.field_72307_f.field_72450_a - 0.1 - rx), (double)(collisionPoint.field_72307_f.field_72448_b - 0.001 - ry), (double)(collisionPoint.field_72307_f.field_72449_c - 0.1 - rz));
                    GL11.glVertex3d((double)(collisionPoint.field_72307_f.field_72450_a + 0.1 - rx), (double)(collisionPoint.field_72307_f.field_72448_b - 0.001 - ry), (double)(collisionPoint.field_72307_f.field_72449_c + 0.1 - rz));
                    GL11.glVertex3d((double)(collisionPoint.field_72307_f.field_72450_a + 0.1 - rx), (double)(collisionPoint.field_72307_f.field_72448_b - 0.001 - ry), (double)(collisionPoint.field_72307_f.field_72449_c - 0.1 - rz));
                    GL11.glVertex3d((double)(collisionPoint.field_72307_f.field_72450_a - 0.1 - rx), (double)(collisionPoint.field_72307_f.field_72448_b - 0.001 - ry), (double)(collisionPoint.field_72307_f.field_72449_c + 0.1 - rz));
                } else if (collisionPoint.field_178784_b == EnumFacing.UP) {
                    GL11.glVertex3d((double)(collisionPoint.field_72307_f.field_72450_a - 0.1 - rx), (double)(collisionPoint.field_72307_f.field_72448_b + 0.001 - ry), (double)(collisionPoint.field_72307_f.field_72449_c - 0.1 - rz));
                    GL11.glVertex3d((double)(collisionPoint.field_72307_f.field_72450_a + 0.1 - rx), (double)(collisionPoint.field_72307_f.field_72448_b + 0.001 - ry), (double)(collisionPoint.field_72307_f.field_72449_c + 0.1 - rz));
                    GL11.glVertex3d((double)(collisionPoint.field_72307_f.field_72450_a + 0.1 - rx), (double)(collisionPoint.field_72307_f.field_72448_b + 0.001 - ry), (double)(collisionPoint.field_72307_f.field_72449_c - 0.1 - rz));
                    GL11.glVertex3d((double)(collisionPoint.field_72307_f.field_72450_a - 0.1 - rx), (double)(collisionPoint.field_72307_f.field_72448_b + 0.001 - ry), (double)(collisionPoint.field_72307_f.field_72449_c + 0.1 - rz));
                } else if (collisionPoint.field_178784_b == EnumFacing.NORTH) {
                    GL11.glVertex3d((double)(collisionPoint.field_72307_f.field_72450_a - 0.1 - rx), (double)(collisionPoint.field_72307_f.field_72448_b - 0.1 - ry), (double)(collisionPoint.field_72307_f.field_72449_c - 0.001 - rz));
                    GL11.glVertex3d((double)(collisionPoint.field_72307_f.field_72450_a + 0.1 - rx), (double)(collisionPoint.field_72307_f.field_72448_b + 0.1 - ry), (double)(collisionPoint.field_72307_f.field_72449_c - 0.001 - rz));
                    GL11.glVertex3d((double)(collisionPoint.field_72307_f.field_72450_a + 0.1 - rx), (double)(collisionPoint.field_72307_f.field_72448_b - 0.1 - ry), (double)(collisionPoint.field_72307_f.field_72449_c - 0.001 - rz));
                    GL11.glVertex3d((double)(collisionPoint.field_72307_f.field_72450_a - 0.1 - rx), (double)(collisionPoint.field_72307_f.field_72448_b + 0.1 - ry), (double)(collisionPoint.field_72307_f.field_72449_c - 0.001 - rz));
                } else if (collisionPoint.field_178784_b == EnumFacing.SOUTH) {
                    GL11.glVertex3d((double)(collisionPoint.field_72307_f.field_72450_a - 0.1 - rx), (double)(collisionPoint.field_72307_f.field_72448_b - 0.1 - ry), (double)(collisionPoint.field_72307_f.field_72449_c + 0.001 - rz));
                    GL11.glVertex3d((double)(collisionPoint.field_72307_f.field_72450_a + 0.1 - rx), (double)(collisionPoint.field_72307_f.field_72448_b + 0.1 - ry), (double)(collisionPoint.field_72307_f.field_72449_c + 0.001 - rz));
                    GL11.glVertex3d((double)(collisionPoint.field_72307_f.field_72450_a + 0.1 - rx), (double)(collisionPoint.field_72307_f.field_72448_b - 0.1 - ry), (double)(collisionPoint.field_72307_f.field_72449_c + 0.001 - rz));
                    GL11.glVertex3d((double)(collisionPoint.field_72307_f.field_72450_a - 0.1 - rx), (double)(collisionPoint.field_72307_f.field_72448_b + 0.1 - ry), (double)(collisionPoint.field_72307_f.field_72449_c + 0.001 - rz));
                } else if (collisionPoint.field_178784_b == EnumFacing.WEST) {
                    GL11.glVertex3d((double)(collisionPoint.field_72307_f.field_72450_a - 0.001 - rx), (double)(collisionPoint.field_72307_f.field_72448_b - 0.1 - ry), (double)(collisionPoint.field_72307_f.field_72449_c - 0.1 - rz));
                    GL11.glVertex3d((double)(collisionPoint.field_72307_f.field_72450_a - 0.001 - rx), (double)(collisionPoint.field_72307_f.field_72448_b + 0.1 - ry), (double)(collisionPoint.field_72307_f.field_72449_c + 0.1 - rz));
                    GL11.glVertex3d((double)(collisionPoint.field_72307_f.field_72450_a - 0.001 - rx), (double)(collisionPoint.field_72307_f.field_72448_b - 0.1 - ry), (double)(collisionPoint.field_72307_f.field_72449_c + 0.1 - rz));
                    GL11.glVertex3d((double)(collisionPoint.field_72307_f.field_72450_a - 0.001 - rx), (double)(collisionPoint.field_72307_f.field_72448_b + 0.1 - ry), (double)(collisionPoint.field_72307_f.field_72449_c - 0.1 - rz));
                } else if (collisionPoint.field_178784_b == EnumFacing.EAST) {
                    GL11.glVertex3d((double)(collisionPoint.field_72307_f.field_72450_a + 0.001 - rx), (double)(collisionPoint.field_72307_f.field_72448_b - 0.1 - ry), (double)(collisionPoint.field_72307_f.field_72449_c - 0.1 - rz));
                    GL11.glVertex3d((double)(collisionPoint.field_72307_f.field_72450_a + 0.001 - rx), (double)(collisionPoint.field_72307_f.field_72448_b + 0.1 - ry), (double)(collisionPoint.field_72307_f.field_72449_c + 0.1 - rz));
                    GL11.glVertex3d((double)(collisionPoint.field_72307_f.field_72450_a + 0.001 - rx), (double)(collisionPoint.field_72307_f.field_72448_b - 0.1 - ry), (double)(collisionPoint.field_72307_f.field_72449_c + 0.1 - rz));
                    GL11.glVertex3d((double)(collisionPoint.field_72307_f.field_72450_a + 0.001 - rx), (double)(collisionPoint.field_72307_f.field_72448_b + 0.1 - ry), (double)(collisionPoint.field_72307_f.field_72449_c - 0.1 - rz));
                }
                GlStateManager.func_187437_J();
                break;
            }
            if (collisionPoint.field_72313_a != RayTraceResult.Type.ENTITY || (hitEntity = collisionPoint.field_72308_g) != null) {
                // empty if block
            } else {
                break;
            }
        }
        if (drawing) {
            GL11.glEnd();
        }
        GL11.glEnable((int)3553);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
    }

    private static RayTraceResult getCollision(EntityArrowSilent ea) {
        Vec3d start = new Vec3d(ea.field_70165_t, ea.field_70163_u, ea.field_70161_v);
        Vec3d dest = new Vec3d(ea.field_70165_t + ea.field_70159_w, ea.field_70163_u + ea.field_70181_x, ea.field_70161_v + ea.field_70179_y);
        RayTraceResult hit = Minecraft.func_71410_x().field_71441_e.func_147447_a(start, dest, false, true, false);
        start = new Vec3d(ea.field_70165_t, ea.field_70163_u, ea.field_70161_v);
        dest = new Vec3d(ea.field_70165_t + ea.field_70159_w, ea.field_70163_u + ea.field_70181_x, ea.field_70161_v + ea.field_70179_y);
        if (hit != null) {
            dest = new Vec3d(hit.field_72307_f.field_72450_a, hit.field_72307_f.field_72448_b, hit.field_72307_f.field_72449_c);
        }
        Entity collidedEntity = null;
        List entityList = Minecraft.func_71410_x().field_71441_e.func_72839_b((Entity)ea, ea.func_174813_aQ().func_72321_a(ea.field_70159_w, ea.field_70181_x, ea.field_70179_y).func_72314_b(1.0, 1.0, 1.0));
        double lastDistance = 0.0;
        for (int c = 0; c < entityList.size(); ++c) {
            double currentDistance;
            AxisAlignedBB entityBoundingBox;
            RayTraceResult collision;
            Entity currentEntity = (Entity)entityList.get(c);
            if (!currentEntity.func_70067_L() || currentEntity == Minecraft.func_71410_x().field_71439_g || (collision = (entityBoundingBox = currentEntity.func_174813_aQ().func_72314_b((double)0.3f, (double)0.3f, (double)0.3f)).func_72327_a(start, dest)) == null || !((currentDistance = start.func_72438_d(collision.field_72307_f)) < lastDistance) && lastDistance != 0.0) continue;
            collidedEntity = currentEntity;
            lastDistance = currentDistance;
        }
        if (collidedEntity != null) {
            hit = new RayTraceResult(collidedEntity);
        }
        return hit;
    }

    private static class EntityArrowSilent
    extends EntityArrow {
        public EntityArrowSilent(World world, EntityLivingBase entity) {
            super(world, entity);
        }

        public void func_70186_c(double x, double y, double z, float velocity, float inaccuracy) {
            float f = MathHelper.func_76133_a((double)(x * x + y * y + z * z));
            x /= (double)f;
            y /= (double)f;
            z /= (double)f;
            this.field_70159_w = x *= (double)velocity;
            this.field_70181_x = y *= (double)velocity;
            this.field_70179_y = z *= (double)velocity;
            float f1 = MathHelper.func_76133_a((double)(x * x + z * z));
            this.field_70177_z = (float)(MathHelper.func_181159_b((double)x, (double)z) * 180.0 / Math.PI);
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)y, (double)f1) * 180.0 / Math.PI);
            this.field_70126_B = this.field_70177_z;
            this.field_70127_C = this.field_70125_A;
        }

        protected ItemStack func_184550_j() {
            return ItemStack.field_190927_a;
        }

        public boolean func_70090_H() {
            return false;
        }

        public boolean func_70072_I() {
            if (this.field_70170_p.func_72918_a(this.func_174813_aQ().func_72321_a(0.0, (double)-0.4f, 0.0).func_191195_a(0.001, 0.001, 0.001), Material.field_151586_h, (Entity)this)) {
                this.field_70143_R = 0.0f;
                this.field_70171_ac = true;
            } else {
                this.field_70171_ac = false;
            }
            return this.field_70171_ac;
        }
    }
}

