/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.gui.inventory;

import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;
import thebetweenlands.common.inventory.InventoryItem;
import thebetweenlands.common.inventory.container.ContainerAmphibiousArmor;
import thebetweenlands.common.item.armor.amphibious.ItemAmphibiousArmor;

@SideOnly(value=Side.CLIENT)
public class GuiAmphibiousArmor
extends GuiContainer {
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation("thebetweenlands:textures/gui/amphibious_armor.png");
    private final InventoryItem inventory;
    private static final int ANIMATION_FRAMES_X = 39;
    private static final int ANIMATION_FRAMES_Y = 55;
    private static final int[][] ANIMATION_FRAMES = new int[][]{{1, 222}, {1, 281}, {1, 340}, {1, 399}, {127, 222}, {127, 281}, {127, 340}, {127, 399}};
    private static final int[][] SLOT_FRAMES = new int[][]{{253, 163}, {253, 222}, {253, 281}, {253, 340}, {253, 399}};
    private int pulseTimer = 0;
    private int pulseAnimationTicks = 0;

    public GuiAmphibiousArmor(ContainerAmphibiousArmor armour) {
        super((Container)armour);
        this.inventory = armour.getItemInventory();
        this.field_147000_g = 221;
        this.field_146999_f = 202;
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (this.pulseAnimationTicks >= 0) {
            ++this.pulseAnimationTicks;
            if (this.pulseAnimationTicks >= (ANIMATION_FRAMES.length + 1) * 5) {
                this.pulseAnimationTicks = -1;
            }
        } else {
            ++this.pulseTimer;
            if (this.pulseTimer > 5) {
                this.pulseAnimationTicks = 0;
                this.pulseTimer = 0;
            }
        }
    }

    protected void func_146979_b(int x, int y) {
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"container.inventory", (Object[])new Object[0]), 20, this.field_147000_g - 96 + 2, 0x404040);
    }

    protected void func_146976_a(float partialTickTime, int x, int y) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(GUI_TEXTURE);
        this.drawTexturedModalRect512(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179118_c();
        if (this.pulseAnimationTicks >= 0) {
            float frame2alpha;
            float frame1alpha;
            int frame1;
            int frame2;
            float animationCounter = ((float)this.pulseAnimationTicks + partialTickTime) / 5.0f;
            int currentFrame = MathHelper.func_76141_d((float)animationCounter);
            if (currentFrame == 0) {
                frame2 = 0;
                frame1 = 0;
                frame1alpha = animationCounter;
                frame2alpha = 0.0f;
            } else if (currentFrame >= ANIMATION_FRAMES.length - 1) {
                frame1 = frame2 = ANIMATION_FRAMES.length - 1;
                frame1alpha = 0.0f;
                frame2alpha = Math.max(0.0f, 1.0f - (animationCounter - (float)ANIMATION_FRAMES.length + 1.0f));
            } else {
                frame1 = currentFrame;
                frame1alpha = 1.0f - (animationCounter - (float)currentFrame);
                frame2 = currentFrame + 1;
                frame2alpha = 1.0f - frame1alpha;
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)frame1alpha);
            this.drawTexturedModalRect512(this.field_147003_i + 39, this.field_147009_r + 55, ANIMATION_FRAMES[frame1][0], ANIMATION_FRAMES[frame1][1], 124, 57);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)frame2alpha);
            this.drawTexturedModalRect512(this.field_147003_i + 39, this.field_147009_r + 55, ANIMATION_FRAMES[frame2][0], ANIMATION_FRAMES[frame2][1], 124, 57);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (int i = 0; i < 5; ++i) {
            if (this.inventory.func_70302_i_() <= i || !this.field_147002_h.func_75139_a(i).func_75216_d()) continue;
            this.drawTexturedModalRect512(this.field_147003_i + 39, this.field_147009_r + 55, SLOT_FRAMES[i][0], SLOT_FRAMES[i][1], 124, 57);
        }
        if (this.inventory.func_70302_i_() < 4) {
            this.drawTexturedModalRect512(this.field_147003_i + 67, this.field_147009_r + 81, 222, 0, 34, 35);
        }
        if (this.inventory.func_70302_i_() < 5) {
            this.drawTexturedModalRect512(this.field_147003_i + 101, this.field_147009_r + 81, 256, 0, 34, 35);
        }
        GlStateManager.func_179141_d();
        ItemStack invItem = this.inventory.getInventoryItemStack();
        if (invItem.func_77973_b() instanceof ItemAmphibiousArmor) {
            for (Slot slot : this.field_147002_h.field_75151_b) {
                ItemStack filter;
                if (!(slot instanceof ContainerAmphibiousArmor.SlotUpgrade)) continue;
                if (slot.func_75216_d()) {
                    int damage = ((ItemAmphibiousArmor)invItem.func_77973_b()).getUpgradeDamage(invItem, slot.getSlotIndex());
                    if (damage <= 0) continue;
                    int maxDamage = ((ItemAmphibiousArmor)invItem.func_77973_b()).getUpgradeMaxDamage(invItem, slot.getSlotIndex());
                    GlStateManager.func_179090_x();
                    Tessellator tessellator = Tessellator.func_178181_a();
                    BufferBuilder buffer = tessellator.func_178180_c();
                    double durability = (double)damage / (double)maxDamage;
                    int bar = Math.round(16.0f - (float)durability * 16.0f);
                    int color = MathHelper.func_181758_c((float)(Math.max(0.0f, (float)(1.0 - durability)) / 3.0f), (float)1.0f, (float)1.0f);
                    this.draw(buffer, this.field_147003_i + slot.field_75223_e, this.field_147009_r + slot.field_75221_f - 4, 16, 2, 0, 0, 0, 255);
                    this.draw(buffer, this.field_147003_i + slot.field_75223_e, this.field_147009_r + slot.field_75221_f - 4, bar, 1, color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, 255);
                    GlStateManager.func_179098_w();
                    continue;
                }
                if (!GuiAmphibiousArmor.func_146272_n() || (filter = ((ItemAmphibiousArmor)invItem.func_77973_b()).getUpgradeFilter(invItem, slot.getSlotIndex())).func_190926_b()) continue;
                this.renderSlot(filter, this.field_147003_i + slot.field_75223_e, this.field_147009_r + slot.field_75221_f);
            }
        }
    }

    private void renderSlot(ItemStack stack, int x, int y) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GL14.glBlendColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.35f);
        GL11.glBlendFunc((int)32771, (int)32772);
        GlStateManager.func_179094_E();
        this.field_146296_j.func_180450_b(stack, x, y);
        GlStateManager.func_179121_F();
        GL14.glBlendColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.CONSTANT_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_CONSTANT_ALPHA);
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
    }

    private void draw(BufferBuilder renderer, int x, int y, int width, int height, int red, int green, int blue, int alpha) {
        renderer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        renderer.func_181662_b((double)(x + 0), (double)(y + 0), 0.0).func_181669_b(red, green, blue, alpha).func_181675_d();
        renderer.func_181662_b((double)(x + 0), (double)(y + height), 0.0).func_181669_b(red, green, blue, alpha).func_181675_d();
        renderer.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_181669_b(red, green, blue, alpha).func_181675_d();
        renderer.func_181662_b((double)(x + width), (double)(y + 0), 0.0).func_181669_b(red, green, blue, alpha).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    protected void drawTexturedModalRect512(float x, float y, int minU, int minV, int width, int height) {
        float scale = 0.001953125f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b((double)(x + 0.0f), (double)(y + (float)height), (double)this.field_73735_i).func_187315_a((double)((float)(minU + 0) * scale), (double)((float)(minV + height) * scale)).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + (float)width), (double)(y + (float)height), (double)this.field_73735_i).func_187315_a((double)((float)(minU + width) * scale), (double)((float)(minV + height) * scale)).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + (float)width), (double)(y + 0.0f), (double)this.field_73735_i).func_187315_a((double)((float)(minU + width) * scale), (double)((float)(minV + 0) * scale)).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + 0.0f), (double)(y + 0.0f), (double)this.field_73735_i).func_187315_a((double)((float)(minU + 0) * scale), (double)((float)(minV + 0) * scale)).func_181675_d();
        tessellator.func_78381_a();
    }
}

