/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.audio;

import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.entity.Entity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.capability.ISwarmedCapability;
import thebetweenlands.client.audio.SafeStreamSound;
import thebetweenlands.common.registries.CapabilityRegistry;
import thebetweenlands.common.registries.SoundRegistry;

@SideOnly(value=Side.CLIENT)
public class SwarmAttackSound
extends SafeStreamSound {
    private boolean fadeOut = false;

    public SwarmAttackSound(SoundEvent sound, SoundCategory category) {
        super(sound, category);
        this.field_147662_b = 0.001f;
        this.field_147659_g = true;
        this.field_147666_i = ISound.AttenuationType.LINEAR;
    }

    public SwarmAttackSound() {
        this(SoundRegistry.SWARM_ATTACK, SoundCategory.HOSTILE);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        boolean shouldFadeOut = false;
        if (!this.fadeOut) {
            Entity view = Minecraft.func_71410_x().func_175606_aa();
            if (view != null) {
                this.field_147660_d = (float)view.field_70165_t;
                this.field_147661_e = (float)view.field_70163_u;
                this.field_147658_f = (float)view.field_70161_v;
                float targetVolume = 0.0f;
                ISwarmedCapability cap = (ISwarmedCapability)view.getCapability(CapabilityRegistry.CAPABILITY_SWARMED, null);
                if (cap != null) {
                    targetVolume = cap.getSwarmedStrength() * 0.5f;
                }
                if (this.field_147662_b > targetVolume) {
                    this.field_147662_b -= 0.05f;
                    if (this.field_147662_b < targetVolume) {
                        this.field_147662_b = targetVolume;
                        if (targetVolume <= 0.0f) {
                            this.field_147659_g = false;
                            this.field_147668_j = true;
                        }
                    }
                } else if (this.field_147662_b < targetVolume) {
                    this.field_147662_b += 0.05f;
                    if (this.field_147662_b > targetVolume) {
                        this.field_147662_b = targetVolume;
                    }
                }
            } else {
                this.stopImmediately();
            }
        }
        if (this.fadeOut || shouldFadeOut) {
            this.field_147662_b -= 0.05f;
            if (this.field_147662_b <= 0.0f) {
                this.field_147659_g = false;
                this.field_147668_j = true;
                this.field_147662_b = 0.0f;
            }
        }
    }

    public void stopImmediately() {
        this.field_147668_j = true;
        this.field_147659_g = false;
    }

    public void stop() {
        this.fadeOut = true;
    }

    public void cancelFade() {
        this.fadeOut = false;
    }

    public boolean isStopping() {
        return this.field_147668_j || this.fadeOut;
    }
}

