/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.audio;

import net.minecraft.client.audio.ISound;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;
import org.lwjgl.openal.AL10;
import paulscode.sound.libraries.ChannelLWJGLOpenAL;
import thebetweenlands.api.audio.IEntitySound;
import thebetweenlands.client.audio.EntityMusicSound;
import thebetweenlands.client.audio.SoundSystemOpenALAccess;
import thebetweenlands.client.handler.MusicHandler;
import thebetweenlands.common.entity.mobs.EntityGreebling;
import thebetweenlands.common.registries.SoundRegistry;

public class GreeblingMusicSound
extends EntityMusicSound<EntityGreebling> {
    public final int type;
    private int ticksPlayed = 0;
    private boolean synced = false;
    private int syncTimer = 0;
    private volatile boolean isSoundReady = false;

    public GreeblingMusicSound(int type, EntityGreebling entity, float volume) {
        super(type == 0 ? SoundRegistry.GREEBLING_MUSIC_1 : SoundRegistry.GREEBLING_MUSIC_2, SoundCategory.NEUTRAL, entity, entity, volume, ISound.AttenuationType.NONE);
        this.type = type;
    }

    @Override
    public void func_73660_a() {
        EntityPlayer player;
        if (!this.synced) {
            SoundSystemOpenALAccess openALAccess = MusicHandler.INSTANCE.getOpenALAccess();
            if (this.isSoundReady) {
                IEntitySound otherSound = MusicHandler.INSTANCE.getEntityMusic(this.type == 0 ? 3 : 2);
                if (otherSound instanceof GreeblingMusicSound) {
                    openALAccess.submitToSoundSystem(() -> {
                        float otherSeconds = openALAccess.getOffsetSecondsAsync(otherSound);
                        if (otherSeconds >= 0.0f) {
                            openALAccess.setOffsetSecondsAsync(this, otherSeconds);
                        }
                        return null;
                    });
                }
                this.synced = true;
            } else {
                if (this.syncTimer % 10 == 0) {
                    openALAccess.submitToSoundSystem(() -> {
                        int state;
                        int sourceId;
                        ChannelLWJGLOpenAL channel = openALAccess.getChannelAsync(this);
                        if (channel != null && channel.ALSource != null && (sourceId = channel.ALSource.get(0)) >= 0 && ((state = AL10.alGetSourcei((int)sourceId, (int)4112)) == 4114 || state == 4115)) {
                            this.isSoundReady = true;
                        }
                        return null;
                    });
                }
                ++this.syncTimer;
            }
        }
        ++this.ticksPlayed;
        super.func_73660_a();
        if (!this.mustFadeOut && !this.fadeOut && (player = MusicHandler.INSTANCE.getPlayer()) != null) {
            this.field_147662_b = (float)MathHelper.func_151237_a((double)((double)this.originalVolume * (1.0 - player.func_70011_f((double)this.field_147660_d, (double)this.field_147661_e, (double)this.field_147658_f) / ((EntityGreebling)this.getMusicEntity()).getMusicRange(player))), (double)0.0, (double)1.0);
        }
    }
}

