/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.audio;

import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.entity.Entity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.audio.IEntitySound;
import thebetweenlands.client.audio.SafeStreamSound;

@SideOnly(value=Side.CLIENT)
public class EntitySound<T extends Entity>
extends SafeStreamSound
implements IEntitySound {
    public final T entity;
    public final Predicate<T> isPlaying;
    protected boolean fadeOut = false;

    public EntitySound(SoundEvent sound, SoundCategory category, T entity, Predicate<T> isPlaying) {
        this(sound, category, entity, isPlaying, 0.4f);
    }

    public EntitySound(SoundEvent sound, SoundCategory category, T entity, Predicate<T> isPlaying, float volume) {
        super(sound, category);
        this.field_147659_g = true;
        this.field_147666_i = ISound.AttenuationType.LINEAR;
        this.entity = entity;
        this.isPlaying = isPlaying;
        this.field_147660_d = (float)((Entity)this.entity).field_70165_t;
        this.field_147661_e = (float)((Entity)this.entity).field_70163_u;
        this.field_147658_f = (float)((Entity)this.entity).field_70161_v;
        this.field_147662_b = volume;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        this.field_147660_d = (float)((Entity)this.entity).field_70165_t;
        this.field_147661_e = (float)((Entity)this.entity).field_70163_u;
        this.field_147658_f = (float)((Entity)this.entity).field_70161_v;
        Entity view = Minecraft.func_71410_x().func_175606_aa();
        if (this.fadeOut || this.entity == null || !this.entity.func_70089_S() || ((Entity)this.entity).field_70128_L || !((Entity)this.entity).field_70170_p.func_175667_e(this.entity.func_180425_c()) || !this.isPlaying.test(this.entity) || view == null || this.entity.func_70032_d(view) > Math.max(16.0f, this.field_147662_b * 16.0f)) {
            this.fadeOut = true;
            this.field_147662_b -= 0.05f;
            if (this.field_147662_b <= 0.0f) {
                this.field_147659_g = false;
                this.field_147668_j = true;
                this.field_147662_b = 0.0f;
            }
        }
    }

    public void stopImmediately() {
        this.field_147668_j = true;
        this.field_147659_g = false;
    }

    public void stop() {
        this.fadeOut = true;
    }

    public void cancelFade() {
        this.fadeOut = false;
    }

    public boolean isStopping() {
        return this.field_147668_j || this.fadeOut;
    }

    @Override
    public Entity getMusicEntity() {
        return this.entity;
    }

    @Override
    public void stopEntityMusic() {
        this.stop();
    }
}

