/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.api.environment;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import thebetweenlands.api.environment.IEnvironmentEvent;

public interface IPredictableEnvironmentEvent
extends IEnvironmentEvent {
    default public Collection<State> getStates() {
        return State.DEFAULT_STATES;
    }

    public int estimateTimeUntil(State var1);

    default public int estimateTimeRemaining(State state) {
        int remaining = -1;
        if (this.estimateTimeUntil(state) == 0) {
            for (State other : this.getStates()) {
                int estimation;
                if (Objects.equals(state, other) || (estimation = this.estimateTimeUntil(other)) <= 0) continue;
                if (remaining < 0) {
                    remaining = estimation;
                    continue;
                }
                remaining = Math.min(remaining, estimation);
            }
        }
        return remaining;
    }

    @Nullable
    public ResourceLocation[] getVisionTextures();

    @Nullable
    public SoundEvent getChimesSound();

    public static class State {
        public static final State ACTIVE = new State();
        public static final State INACTIVE = new State();
        private static final Collection<State> DEFAULT_STATES = ImmutableList.of((Object)ACTIVE, (Object)INACTIVE);
    }
}

