/*
 * Decompiled with CFR 0.152.
 */
package tschipp.callablehorses.common;

import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.passive.AbstractChestHorse;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import tschipp.callablehorses.CallableHorses;
import tschipp.callablehorses.common.WhistleSounds;
import tschipp.callablehorses.common.capabilities.horseowner.IHorseOwner;
import tschipp.callablehorses.common.capabilities.storedhorse.IStoredHorse;
import tschipp.callablehorses.common.config.CallableHorsesConfig;
import tschipp.callablehorses.common.helper.HorseHelper;
import tschipp.callablehorses.common.worlddata.StoredHorsesWorldData;
import tschipp.callablehorses.network.OwnerSyncShowStatsPacket;

public class HorseManager {
    public static boolean callHorse(EntityPlayer player) {
        IHorseOwner horseOwner;
        if (player != null && (horseOwner = HorseHelper.getOwnerCap(player)) != null) {
            IStoredHorse horse;
            if (horseOwner.getHorseNBT().func_82582_d()) {
                player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.RED + I18n.func_74838_a((String)"callablehorses.error.nohorse")), true);
                return false;
            }
            if (!HorseManager.canCallHorse(player)) {
                return false;
            }
            Random rand = new Random();
            player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, WhistleSounds.getRandomWhistle(), SoundCategory.PLAYERS, 1.0f, (float)(1.4 + rand.nextGaussian() / 3.0));
            AbstractHorse e = HorseManager.findHorseWithStorageID(horseOwner.getStorageUUID(), player.field_70170_p);
            if (e != null && (horse = HorseHelper.getHorseCap((Entity)e)).getStorageUUID().equals(horseOwner.getStorageUUID())) {
                if (e.field_70170_p.field_73011_w.getDimension() == player.field_70170_p.field_73011_w.getDimension()) {
                    e.func_184226_ay();
                    if (e.func_180425_c().func_177951_i((Vec3i)player.func_180425_c()) <= CallableHorsesConfig.settings.horseWalkRange * CallableHorsesConfig.settings.horseWalkRange) {
                        e.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(CallableHorsesConfig.settings.horseWalkRange);
                        e.func_70661_as().func_75497_a((Entity)player, CallableHorsesConfig.settings.horseSpeed);
                    } else {
                        e.func_70107_b(player.field_70165_t, player.field_70163_u, player.field_70161_v);
                    }
                    HorseHelper.sendHorseUpdateInRange((Entity)e);
                    HorseHelper.setHorseLastSeen(player);
                    return true;
                }
                HorseManager.saveHorse((Entity)e);
                e.func_70107_b(e.field_70165_t, -200.0, e.field_70161_v);
                e.func_70106_y();
            }
            AbstractHorse newHorse = horseOwner.getHorseEntity(player.field_70170_p);
            newHorse.func_70107_b(player.field_70165_t, player.field_70163_u, player.field_70161_v);
            player.field_70170_p.func_72838_d((Entity)newHorse);
            IStoredHorse h = HorseHelper.getHorseCap((Entity)newHorse);
            HorseHelper.setHorseNum(newHorse.field_70170_p, h.getStorageUUID(), h.getHorseNum());
            HorseHelper.sendHorseUpdateInRange((Entity)newHorse);
            HorseHelper.setHorseLastSeen(player);
            return true;
        }
        return false;
    }

    public static void setHorse(EntityPlayer player) {
        if (player != null) {
            if (!player.func_184218_aH()) {
                player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.RED + I18n.func_74838_a((String)"callablehorses.error.notriding")), true);
                return;
            }
            Entity e = player.func_184187_bx();
            if (e instanceof AbstractHorse) {
                if (!HorseManager.canSetHorse(player, e)) {
                    return;
                }
                IStoredHorse storedHorse = HorseHelper.getHorseCap(e);
                String owner = storedHorse.getOwnerUUID();
                String playerID = player.func_146103_bH().getId().toString();
                boolean owned = storedHorse.isOwned();
                if (owned && !owner.equals(playerID)) {
                    player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.RED + I18n.func_74838_a((String)"callablehorses.error.alreadyowned")), true);
                    return;
                }
                if (owned && owner.equals(playerID)) {
                    player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.RED + I18n.func_74838_a((String)"callablehorses.error.alreadypersonal")), true);
                    return;
                }
                IHorseOwner horseOwner = HorseHelper.getOwnerCap(player);
                String ownedID = horseOwner.getStorageUUID();
                if (!ownedID.isEmpty()) {
                    AbstractHorse ent = HorseManager.findHorseWithStorageID(horseOwner.getStorageUUID(), player.field_70170_p);
                    if (ent != null) {
                        HorseManager.clearHorse(HorseHelper.getHorseCap((Entity)ent));
                    } else {
                        StoredHorsesWorldData data = HorseHelper.getWorldData(player.field_70170_p);
                        data.disbandHorse(ownedID);
                    }
                }
                horseOwner.clearHorse();
                horseOwner.setHorse((AbstractHorse)e, player);
                HorseHelper.sendHorseUpdateInRange(e);
                HorseHelper.setHorseLastSeen(player);
                HorseHelper.setHorseNum(e.field_70170_p, storedHorse.getStorageUUID(), storedHorse.getHorseNum());
                player.func_146105_b((ITextComponent)new TextComponentString(I18n.func_74838_a((String)"callablehorses.success")), true);
            }
        }
    }

    public static void showHorseStats(EntityPlayerMP player) {
        IHorseOwner owner = HorseHelper.getOwnerCap((EntityPlayer)player);
        if (owner.getHorseNBT().func_82582_d()) {
            player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.RED + I18n.func_74838_a((String)"callablehorses.error.nohorse")), true);
            return;
        }
        AbstractHorse e = HorseManager.findHorseWithStorageID(owner.getStorageUUID(), player.field_70170_p);
        if (e != null) {
            HorseManager.saveHorse((Entity)e);
        }
        CallableHorses.network.sendTo((IMessage)new OwnerSyncShowStatsPacket(owner), player);
    }

    public static void clearHorse(IStoredHorse horse) {
        horse.setOwned(false);
        horse.setHorseNum(0);
        horse.setOwnerUUID("");
        horse.setStorageUUID("");
    }

    @Nullable
    public static AbstractHorse findHorseWithStorageID(String id, World world) {
        MinecraftServer server = ((WorldServer)world).func_73046_m();
        ArrayList entities = new ArrayList();
        for (WorldServer w : server.field_71305_c) {
            entities.addAll(w.field_72996_f);
        }
        for (Entity e : entities) {
            IStoredHorse horse;
            if (!(e instanceof AbstractHorse) || !(horse = HorseHelper.getHorseCap(e)).getStorageUUID().equals(id)) continue;
            return (AbstractHorse)e;
        }
        return null;
    }

    public static void prepDeadHorseForRespawning(Entity e) {
        IItemHandler itemHandler = (IItemHandler)e.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        if (itemHandler != null) {
            for (int i = 0; i < itemHandler.getSlots(); ++i) {
                itemHandler.extractItem(i, 64, false);
            }
        }
        if (e instanceof AbstractChestHorse) {
            ((AbstractChestHorse)e).func_110207_m(false);
        }
        e.func_70066_B();
        ((EntityLivingBase)e).func_70606_j(((EntityLivingBase)e).func_110138_aP());
    }

    public static boolean canCallHorse(EntityPlayer player) {
        if (HorseManager.isAreaProtected(player, null)) {
            player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.RED + I18n.func_74838_a((String)"callablehorses.error.area")), true);
            return false;
        }
        if (player.func_184218_aH()) {
            player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.RED + I18n.func_74838_a((String)"callablehorses.error.riding")), true);
            return false;
        }
        if (CallableHorsesConfig.settings.checkForSpace) {
            double startX = player.field_70165_t - 1.0;
            double startY = player.field_70163_u;
            double startZ = player.field_70161_v - 1.0;
            double endX = player.field_70165_t + 1.0;
            double endY = player.field_70163_u + 2.0;
            double endZ = player.field_70161_v + 1.0;
            World world = player.field_70170_p;
            for (double x = startX; x <= endX; x += 1.0) {
                for (double y = startY; y <= endY; y += 1.0) {
                    for (double z = startZ; z <= endZ; z += 1.0) {
                        BlockPos pos = new BlockPos(x, y, z);
                        IBlockState state = world.func_180495_p(pos);
                        if (state.func_177230_c().func_180646_a(state, (IBlockAccess)world, pos) == null) continue;
                        player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.RED + I18n.func_74838_a((String)"callablehorses.error.nospace")), true);
                        return false;
                    }
                }
            }
        }
        if (!CallableHorsesConfig.settings.callableInEveryDimension) {
            int[] allowedDims = CallableHorsesConfig.settings.callableDimsWhitelist;
            int playerDim = player.field_70170_p.field_73011_w.getDimension();
            for (int i = 0; i < allowedDims.length; ++i) {
                if (i != playerDim) continue;
                return true;
            }
            player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.RED + I18n.func_74838_a((String)"callablehorses.error.dim")), true);
            return false;
        }
        int maxDistance = CallableHorsesConfig.settings.maxCallingDistance;
        if (maxDistance != -1) {
            double movementFactorOwner;
            double movementFactorHorse;
            IHorseOwner owner = HorseHelper.getOwnerCap(player);
            BlockPos lastSeenPos = owner.getLastSeenPosition();
            int lastSeenDim = owner.getLastSeenDim();
            if (lastSeenPos.equals((Object)BlockPos.field_177992_a)) {
                return true;
            }
            MinecraftServer server = player.field_70170_p.func_73046_m();
            AbstractHorse livingHorse = HorseManager.findHorseWithStorageID(owner.getStorageUUID(), player.field_70170_p);
            if (livingHorse != null) {
                lastSeenPos = livingHorse.func_180425_c();
                lastSeenDim = livingHorse.field_70170_p.field_73011_w.getDimension();
            }
            double movementFactorTotal = (movementFactorHorse = server.func_71218_a((int)lastSeenDim).field_73011_w.getMovementFactor()) > (movementFactorOwner = player.field_70170_p.field_73011_w.getMovementFactor()) ? movementFactorHorse / movementFactorOwner : movementFactorOwner / movementFactorHorse;
            double distance = Math.sqrt(lastSeenPos.func_177951_i((Vec3i)player.func_180425_c())) / movementFactorTotal;
            if (distance <= (double)maxDistance) {
                return true;
            }
            player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.RED + I18n.func_74838_a((String)"callablehorses.error.range")), true);
            return false;
        }
        return true;
    }

    public static boolean canSetHorse(EntityPlayer player, Entity entity) {
        if (HorseManager.isAreaProtected(player, entity)) {
            player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.RED + I18n.func_74838_a((String)"callablehorses.error.setarea")), true);
            return false;
        }
        return true;
    }

    public static void saveHorse(Entity e) {
        if (e instanceof AbstractHorse) {
            if (((AbstractHorse)e).field_70737_aN != 0) {
                return;
            }
            World world = e.field_70170_p;
            IStoredHorse horse = HorseHelper.getHorseCap(e);
            if (horse.isOwned()) {
                String ownerid = horse.getOwnerUUID();
                EntityPlayer owner = HorseHelper.getPlayerFromUUID(ownerid, world);
                if (owner != null) {
                    IHorseOwner horseOwner = HorseHelper.getOwnerCap(owner);
                    NBTTagCompound nbt = e.serializeNBT();
                    horseOwner.setHorseNBT(nbt);
                    horseOwner.setLastSeenDim(e.field_71093_bK);
                    horseOwner.setLastSeenPosition(e.func_180425_c());
                } else {
                    StoredHorsesWorldData data = HorseHelper.getWorldData(world);
                    data.addOfflineSavedHorse(horse.getStorageUUID(), e.serializeNBT());
                }
            }
        }
    }

    private static boolean isAreaProtected(EntityPlayer player, @Nullable Entity fakeHorse) {
        IHorseOwner owner = HorseHelper.getOwnerCap(player);
        if (fakeHorse == null) {
            fakeHorse = owner.getHorseEntity(player.field_70170_p);
        }
        fakeHorse.func_70107_b(player.field_70165_t, player.field_70163_u, player.field_70161_v);
        PlayerInteractEvent.EntityInteract interactEvent = new PlayerInteractEvent.EntityInteract(player, EnumHand.MAIN_HAND, fakeHorse);
        AttackEntityEvent attackEvent = new AttackEntityEvent(player, fakeHorse);
        MinecraftForge.EVENT_BUS.post((Event)interactEvent);
        MinecraftForge.EVENT_BUS.post((Event)attackEvent);
        return interactEvent.isCanceled() || attackEvent.isCanceled();
    }
}

