/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.grue.client.handlers;

import com.shinoow.darknesslib.api.DarknessLibAPI;
import com.shinoow.grue.Grue;
import com.shinoow.grue.common.entity.cap.GrueCapabilityProvider;
import com.shinoow.grue.common.entity.cap.IGrueTimerCapability;
import com.shinoow.grue.common.util.DimensionData;
import java.util.Arrays;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class GrueClientEventHandler {
    @SubscribeEvent
    public void warning(LivingEvent.LivingUpdateEvent event) {
        if (!Grue.displayWarningText) {
            return;
        }
        if (event.getEntityLiving() instanceof EntityPlayer) {
            int light;
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            if (!this.isWhitelisted(player.field_71093_bK) && !Grue.whitelist_override.contains(player.field_71093_bK)) {
                return;
            }
            if (!this.isWhitelisted(player.field_70170_p.func_180494_b(player.func_180425_c())) && !Grue.biome_whitelist_override.contains(player.field_70170_p.func_180494_b(player.func_180425_c()))) {
                return;
            }
            if (player.field_71075_bZ.field_75098_d) {
                return;
            }
            if (player.func_175149_v()) {
                return;
            }
            if (player.field_70128_L) {
                return;
            }
            IGrueTimerCapability cap = (IGrueTimerCapability)player.getCapability(GrueCapabilityProvider.GRUE_TIMER, null);
            if (cap == null) {
                return;
            }
            if (cap.getGracePeriodTimer() > 0) {
                return;
            }
            if (cap.getTimer() == 0) {
                return;
            }
            DimensionData data = Grue.getDimensionConfig(player.field_71093_bK);
            int n = light = Grue.dynLightPausesTimer ? DarknessLibAPI.getInstance().getLight((Entity)player, true) : DarknessLibAPI.getInstance().getLight((Entity)player, true);
            if (light > data.getMaxLight() || light < data.getMinLight()) {
                return;
            }
            if (cap.getTimer() % 80 == 0) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("text.warning.grue", new Object[0]), !Grue.warningChat);
            }
        }
    }

    private boolean isWhitelisted(int dim) {
        if (!Grue.useWhitelist) {
            return true;
        }
        if (!Grue.useBlacklist) {
            return Arrays.stream(Grue.dimWhitelist).anyMatch(id -> id == dim);
        }
        return Arrays.stream(Grue.dimWhitelist).noneMatch(id -> id == dim);
    }

    private boolean isWhitelisted(Biome biome) {
        return Grue.biome_whitelist.isEmpty() || Grue.useBiomeBlacklist ? !Grue.biome_whitelist.contains(biome) : Grue.biome_whitelist.contains(biome);
    }
}

