/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.scalinghealth.event;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.silentchaos512.lib.util.ChatHelper;
import net.silentchaos512.scalinghealth.ScalingHealth;
import net.silentchaos512.scalinghealth.config.Config;
import net.silentchaos512.scalinghealth.entity.EntityBlightFire;
import net.silentchaos512.scalinghealth.init.ModItems;
import net.silentchaos512.scalinghealth.network.NetworkHandler;
import net.silentchaos512.scalinghealth.network.message.MessageMarkBlight;

public final class BlightHandler {
    public static final BlightHandler INSTANCE = new BlightHandler();
    private static final String NBT_BLIGHT = "ScalingHealth.IsBlight";
    private static final int UPDATE_DELAY = 200;

    private BlightHandler() {
    }

    public static boolean isBlight(EntityLivingBase entityLiving) {
        return entityLiving != null && entityLiving.getEntityData().func_74767_n(NBT_BLIGHT);
    }

    @Deprecated
    public static void markBlight(EntityLivingBase entityLiving) {
        BlightHandler.markBlight(entityLiving, true);
    }

    public static void markBlight(EntityLivingBase entityLiving, boolean isBlight) {
        if (entityLiving != null) {
            EntityBlightFire blightFire;
            entityLiving.getEntityData().func_74757_a(NBT_BLIGHT, isBlight);
            if (!isBlight && (blightFire = BlightHandler.getBlightFire(entityLiving)) != null) {
                blightFire.func_70106_y();
            }
        }
    }

    static void spawnBlightFire(EntityLivingBase blight) {
        if (blight.field_70170_p.field_72995_K || BlightHandler.getBlightFire(blight) != null) {
            return;
        }
        EntityBlightFire fire = new EntityBlightFire(blight);
        fire.func_70107_b(blight.field_70165_t, blight.field_70163_u, blight.field_70161_v);
        blight.field_70170_p.func_72838_d((Entity)fire);
        if (Config.Mob.Blight.fireRidesBlight) {
            fire.func_184220_m((Entity)blight);
        }
    }

    @Nullable
    private static EntityBlightFire getBlightFire(EntityLivingBase blight) {
        for (EntityBlightFire fire : blight.field_70170_p.func_175644_a(EntityBlightFire.class, e -> true)) {
            if (!blight.equals((Object)fire.getParent())) continue;
            return fire;
        }
        return null;
    }

    static void applyBlightPotionEffects(EntityLivingBase entityLiving) {
        int duration = Config.Mob.Blight.potionDuration;
        if (duration < 0) {
            duration = Integer.MAX_VALUE;
        } else if (duration == 0) {
            return;
        }
        if (Config.Mob.Blight.invisibility) {
            entityLiving.func_70690_d(new PotionEffect(MobEffects.field_76441_p, duration, 0, true, false));
        }
        if (Config.Mob.Blight.fireResist) {
            entityLiving.func_70690_d(new PotionEffect(MobEffects.field_76426_n, duration, 0, true, false));
        }
        if (Config.Mob.Blight.speedAmp > -1) {
            entityLiving.func_70690_d(new PotionEffect(MobEffects.field_76424_c, duration, Config.Mob.Blight.speedAmp, true, false));
        }
        if (Config.Mob.Blight.strengthAmp > -1) {
            entityLiving.func_70690_d(new PotionEffect(MobEffects.field_76420_g, duration, Config.Mob.Blight.strengthAmp, true, false));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onBlightKilled(LivingDeathEvent event) {
        boolean isTamedAnimal;
        if (event.getSource() == null || !BlightHandler.isBlight(event.getEntityLiving()) || event.getEntity().field_70170_p.field_72995_K) {
            return;
        }
        Entity entitySource = event.getSource().func_76346_g();
        boolean bl = isTamedAnimal = entitySource instanceof EntityTameable && ((EntityTameable)entitySource).func_70909_n();
        if (entitySource instanceof EntityPlayer || isTamedAnimal) {
            EntityPlayer actualKiller;
            EntityPlayer player;
            EntityLivingBase blight = event.getEntityLiving();
            if (isTamedAnimal) {
                player = (EntityPlayer)((EntityTameable)entitySource).func_70902_q();
                actualKiller = (EntityLivingBase)entitySource;
            } else {
                actualKiller = player = (EntityPlayer)entitySource;
            }
            if (Config.Mob.Blight.notifyOnDeath && player != null) {
                ScalingHealth.logHelper.info("Blight {} was killed by {}", new Object[]{blight.func_70005_c_(), actualKiller.func_70005_c_()});
                for (EntityPlayer p : player.field_70170_p.func_175661_b(EntityPlayer.class, e -> true)) {
                    ChatHelper.translate((EntityPlayer)p, (String)ScalingHealth.i18n.getKey("blight", "killedByPlayer"), (Object[])new Object[]{blight.func_70005_c_(), actualKiller.func_70005_c_()});
                }
            }
            boolean canGetHearts = !(player instanceof FakePlayer) || Config.FakePlayer.generateHearts;
            int min = Config.Items.Heart.blightMin;
            int max = Config.Items.Heart.blightMax;
            int heartCount = ScalingHealth.random.nextInt(max - min + 1) + min;
            if (canGetHearts && heartCount > 0) {
                Item itemToDrop = Config.Items.Heart.dropShardsInstead ? ModItems.crystalShard : ModItems.heart;
                blight.func_145779_a(itemToDrop, heartCount);
            }
        } else {
            ITextComponent deathMessage;
            EntityLivingBase blight = event.getEntityLiving();
            if (Config.Mob.Blight.notifyOnDeath && (deathMessage = event.getSource().func_151519_b(blight)) instanceof TextComponentTranslation) {
                TextComponentTranslation original = (TextComponentTranslation)deathMessage;
                TextComponentTranslation newMessage = new TextComponentTranslation(original.func_150268_i(), new Object[]{"Blight " + blight.func_70005_c_()});
                ScalingHealth.logHelper.info("Blight {} has died", new Object[]{blight.func_70005_c_()});
                for (EntityPlayer p : blight.field_70170_p.func_175661_b(EntityPlayer.class, e -> true)) {
                    ChatHelper.sendMessage((EntityPlayer)p, (ITextComponent)newMessage);
                }
            }
        }
    }

    @SubscribeEvent
    public void onBlightUpdate(LivingEvent.LivingUpdateEvent event) {
        World world;
        EntityLivingBase entityLiving = event.getEntityLiving();
        if (entityLiving != null && !entityLiving.field_70170_p.field_72995_K && BlightHandler.isBlight(entityLiving) && ((world = entityLiving.field_70170_p).func_82737_E() + (long)entityLiving.func_145782_y()) % 200L == 0L) {
            MessageMarkBlight message = new MessageMarkBlight(entityLiving, true);
            NetworkHandler.INSTANCE.sendToAllAround((IMessage)message, new NetworkRegistry.TargetPoint(entityLiving.field_71093_bK, entityLiving.field_70165_t, entityLiving.field_70163_u, entityLiving.field_70161_v, 128.0));
            if (BlightHandler.getBlightFire(entityLiving) == null) {
                BlightHandler.spawnBlightFire(entityLiving);
            }
            BlightHandler.applyBlightPotionEffects(entityLiving);
        }
    }

    @SubscribeEvent
    public void onBlightAttack(LivingAttackEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (entity != null && !entity.field_70170_p.field_72995_K && BlightHandler.isBlight(entity) && Config.Mob.Blight.immuneToSuffocation && event.getSource() == DamageSource.field_76368_d) {
            event.setCanceled(true);
        }
    }
}

