/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlandsmusic;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import thebetweenlands.api.entity.IEntityMusicProvider;
import thebetweenlands.client.audio.ambience.AmbienceManager;
import thebetweenlands.client.audio.ambience.AmbienceType;
import thebetweenlands.client.audio.ambience.list.LocationAmbienceType;
import thebetweenlands.common.BetweenlandsAPI;
import thebetweenlands.common.entity.mobs.EntityChiromawMatriarch;
import thebetweenlands.common.entity.mobs.EntityEmberlingShaman;
import thebetweenlands.common.entity.mobs.EntitySpiritTreeFaceLarge;
import thebetweenlands.common.world.storage.location.LocationAmbience;
import thebetweenlands.common.world.storage.location.LocationSludgeWormDungeon;
import thebetweenlands.common.world.storage.location.LocationStorage;
import thebetweenlandsmusic.ChiromawMatriarchEntityMusicProvider;
import thebetweenlandsmusic.EmberlingShamanMusicProvider;
import thebetweenlandsmusic.SpiritTreeEntityMusicProvider;

@Mod(modid="thebetweenlandsmusic", name="The Betweenlands Music Addon", version="1.0.0", acceptedMinecraftVersions="[1.12.2]", dependencies="required-after:forge@[14.23.5.2773,);required-after:thebetweenlands@[3.9.5,)", clientSideOnly=true)
public class TheBetweenlandsMusic {
    @Mod.Instance(value="thebetweenlandsmusic")
    public static TheBetweenlandsMusic instance;
    public static final SoundEvent WIGHT_FORTRESS;
    public static final SoundEvent LABYRINTHINE_VAULTS;
    public static final SoundEvent CHIROMAW_MATRIARCH_LOOP;
    public static final SoundEvent SPIRIT_TREE_LOOP;
    public static final SoundEvent EMBERLING_SHAMAN_LOOP;
    private static final List<SoundEvent> SOUNDS;

    @Mod.InstanceFactory
    public static TheBetweenlandsMusic createInstance() {
        return new TheBetweenlandsMusic();
    }

    @Mod.EventHandler
    public static void postInit(FMLPostInitializationEvent event) {
        BetweenlandsAPI.getInstance().registerEntityMusicProvider(EntityChiromawMatriarch.class, (IEntityMusicProvider)new ChiromawMatriarchEntityMusicProvider());
        BetweenlandsAPI.getInstance().registerEntityMusicProvider(EntitySpiritTreeFaceLarge.class, (IEntityMusicProvider)new SpiritTreeEntityMusicProvider());
        BetweenlandsAPI.getInstance().registerEntityMusicProvider(EntityEmberlingShaman.class, (IEntityMusicProvider)new EmberlingShamanMusicProvider());
        AmbienceManager.INSTANCE.registerAmbience((AmbienceType)new LocationAmbienceType(LocationAmbience.EnumLocationAmbience.WIGHT_TOWER, WIGHT_FORTRESS){

            public int getPriority() {
                return 6;
            }

            public boolean isActive() {
                return super.isActive() && !this.getAmbience().getLocation().getName().equals("wight_tower_boss");
            }

            public SoundCategory getCategory() {
                return SoundCategory.MUSIC;
            }
        });
        AmbienceManager.INSTANCE.registerAmbience((AmbienceType)new LocationAmbienceType(LocationAmbience.EnumLocationAmbience.SLUDGE_WORM_DUNGEON, LABYRINTHINE_VAULTS){

            public int getPriority() {
                return 6;
            }

            public boolean isActive() {
                LocationStorage location;
                LocationAmbience ambience;
                if (super.isActive() && (ambience = this.getAmbience()) != null && (location = ambience.getLocation()) instanceof LocationSludgeWormDungeon) {
                    return this.getPlayer().func_174824_e((float)1.0f).field_72448_b < (double)((LocationSludgeWormDungeon)location).getStructurePos().func_177956_o();
                }
                return false;
            }

            public SoundCategory getCategory() {
                return SoundCategory.MUSIC;
            }
        });
    }

    @SubscribeEvent
    public static void registerSounds(RegistryEvent.Register<SoundEvent> event) {
        IForgeRegistry registry = event.getRegistry();
        for (SoundEvent sound : SOUNDS) {
            sound.setRegistryName(sound.func_187503_a());
            registry.register((IForgeRegistryEntry)sound);
        }
    }

    static {
        WIGHT_FORTRESS = new SoundEvent(new ResourceLocation("thebetweenlandsmusic", "wight_fortress"));
        LABYRINTHINE_VAULTS = new SoundEvent(new ResourceLocation("thebetweenlandsmusic", "labyrinthine_vaults"));
        CHIROMAW_MATRIARCH_LOOP = new SoundEvent(new ResourceLocation("thebetweenlandsmusic", "chiromaw_matriarch_loop"));
        SPIRIT_TREE_LOOP = new SoundEvent(new ResourceLocation("thebetweenlandsmusic", "spirit_tree_loop"));
        EMBERLING_SHAMAN_LOOP = new SoundEvent(new ResourceLocation("thebetweenlandsmusic", "emberling_shaman_loop"));
        SOUNDS = new ArrayList<SoundEvent>();
        SOUNDS.add(CHIROMAW_MATRIARCH_LOOP);
        SOUNDS.add(SPIRIT_TREE_LOOP);
        SOUNDS.add(EMBERLING_SHAMAN_LOOP);
    }
}

