/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.library;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import knightminer.inspirations.common.Config;
import knightminer.inspirations.library.ItemMetaKey;
import knightminer.inspirations.library.Util;
import knightminer.inspirations.library.event.RegisterEvent;
import knightminer.inspirations.library.recipe.cauldron.CauldronFluidRecipe;
import knightminer.inspirations.library.recipe.cauldron.CauldronFluidTransformRecipe;
import knightminer.inspirations.library.recipe.cauldron.FillCauldronRecipe;
import knightminer.inspirations.library.recipe.cauldron.ICauldronRecipe;
import knightminer.inspirations.library.util.RecipeMatchOredictStack;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockDeadBush;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockLilyPad;
import net.minecraft.block.BlockMushroom;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.util.RecipeMatch;

public class InspirationsRegistry {
    public static final Logger log = Util.getLogger("api");
    private static Map<ItemMetaKey, Float> books = new HashMap<ItemMetaKey, Float>();
    private static String[] bookKeywords = new String[0];
    private static Map<ItemMetaKey, Integer> flowers = new HashMap<ItemMetaKey, Integer>();
    private static Map<IBlockState, IBlockState> anvilSmashing = new HashMap<IBlockState, IBlockState>();
    private static Map<Block, IBlockState> anvilSmashingBlocks = new HashMap<Block, IBlockState>();
    private static Set<Material> anvilBreaking = new HashSet<Material>();
    private static List<ICauldronRecipe> cauldronRecipes = new ArrayList<ICauldronRecipe>();
    private static Set<ItemMetaKey> cauldronBlacklist = new HashSet<ItemMetaKey>();
    private static boolean cauldronBigger = false;
    private static boolean expensiveCauldronBrewing = false;
    private static Set<Fluid> cauldronWater = new HashSet<Fluid>();
    private static Set<Block> cauldronFireBlocks = new HashSet<Block>();
    private static Set<IBlockState> cauldronFireStates = new HashSet<IBlockState>();
    private static Map<Block, ICauldronRecipe.CauldronState> cauldronBlockStates = new HashMap<Block, ICauldronRecipe.CauldronState>();
    private static Map<ICauldronRecipe.CauldronState, IBlockState> cauldronFullStates = new HashMap<ICauldronRecipe.CauldronState, IBlockState>();

    @Deprecated
    public static void setConfig(String key, boolean value) {
        switch (key) {
            case "biggerCauldron": {
                cauldronBigger = value;
                break;
            }
            case "expensiveCauldronBrewing": {
                expensiveCauldronBrewing = value;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected config key " + key);
            }
        }
    }

    public static boolean isBook(ItemStack stack) {
        return !stack.func_190926_b() && InspirationsRegistry.getBookEnchantingPower(stack) >= 0.0f;
    }

    public static float getBookEnchantingPower(ItemStack book) {
        if (book.func_190926_b()) {
            return 0.0f;
        }
        return books.computeIfAbsent(new ItemMetaKey(book), InspirationsRegistry::isBook).floatValue();
    }

    @Nonnull
    private static Float isBook(ItemMetaKey key) {
        Item item = key.getItem();
        if (Block.func_149634_a((Item)item) != Blocks.field_150350_a) {
            return Float.valueOf(-1.0f);
        }
        ItemStack stack = key.makeItemStack();
        for (String keyword : bookKeywords) {
            if (!item.getRegistryName().func_110623_a().contains(keyword) && !stack.func_77977_a().contains(keyword)) continue;
            return Float.valueOf(Config.defaultEnchantingPower);
        }
        return Float.valueOf(-1.0f);
    }

    @Deprecated
    public static void registerBook(ItemStack stack, boolean isBook) {
        InspirationsRegistry.registerBook(stack, isBook ? 1.5f : -1.0f);
    }

    @Deprecated
    public static void registerBook(Item item, int meta, boolean isBook) {
        books.put(new ItemMetaKey(item, meta), Float.valueOf(isBook ? 1.5f : -1.0f));
    }

    public static void registerBook(ItemStack stack, float power) {
        books.put(new ItemMetaKey(stack), Float.valueOf(power));
    }

    public static void setBookKeywords(String[] keywords) {
        bookKeywords = keywords;
    }

    public static boolean isFlower(ItemStack stack) {
        return InspirationsRegistry.getFlowerComparatorPower(stack) > 0;
    }

    public static int getFlowerComparatorPower(ItemStack stack) {
        return flowers.computeIfAbsent(new ItemMetaKey(stack), key -> {
            Block block = Block.func_149634_a((Item)key.getItem());
            if (!(block instanceof BlockBush) || block instanceof BlockDoublePlant || block instanceof BlockTallGrass || block instanceof BlockCrops || block instanceof BlockLilyPad) {
                return 0;
            }
            if (block instanceof BlockSapling) {
                return 12;
            }
            if (block instanceof BlockDeadBush) {
                return 10;
            }
            if (block instanceof BlockMushroom) {
                return 1;
            }
            return 7;
        });
    }

    @Deprecated
    public static void registerFlower(ItemStack stack, boolean isFlower) {
        InspirationsRegistry.registerFlower(stack, isFlower ? 7 : 0);
    }

    public static void registerFlower(ItemStack stack, int power) {
        flowers.put(new ItemMetaKey(stack), power);
    }

    @Deprecated
    public static void registerFlower(Block block, int meta, boolean isFlower) {
        InspirationsRegistry.registerFlower(block, meta, isFlower ? 7 : 0);
    }

    public static void registerFlower(Block block, int meta, int power) {
        Item item = Item.func_150898_a((Block)block);
        if (item != Items.field_190931_a) {
            flowers.put(new ItemMetaKey(item, meta), power);
        }
    }

    public static void registerAnvilSmashing(IBlockState input, IBlockState result) {
        anvilSmashing.put(input, result);
    }

    public static void registerAnvilSmashing(IBlockState input, Block result) {
        InspirationsRegistry.registerAnvilSmashing(input, result.func_176223_P());
    }

    public static void registerAnvilBreaking(IBlockState input) {
        InspirationsRegistry.registerAnvilSmashing(input, Blocks.field_150350_a);
    }

    public static void registerAnvilSmashing(Block input, IBlockState result) {
        anvilSmashingBlocks.put(input, result);
    }

    public static void registerAnvilSmashing(Block input, Block result) {
        InspirationsRegistry.registerAnvilSmashing(input, result.func_176223_P());
    }

    public static void registerAnvilBreaking(Block input) {
        InspirationsRegistry.registerAnvilSmashing(input, Blocks.field_150350_a);
    }

    public static void registerAnvilBreaking(Material material) {
        anvilBreaking.add(material);
    }

    public static IBlockState getAnvilSmashResult(IBlockState state) {
        if (anvilSmashing.containsKey(state)) {
            return anvilSmashing.get(state);
        }
        Block block = state.func_177230_c();
        if (anvilSmashingBlocks.containsKey(block)) {
            return anvilSmashingBlocks.get(block);
        }
        if (anvilBreaking.contains(state.func_185904_a())) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return null;
    }

    public static boolean hasAnvilSmashStateResult(IBlockState state) {
        return anvilSmashing.containsKey(state);
    }

    public static List<Map.Entry<IBlockState, IBlockState>> getAllAnvilStateSmashing() {
        return ImmutableList.copyOf(anvilSmashing.entrySet());
    }

    public static List<Map.Entry<Block, IBlockState>> getAllAnvilBlockSmashing() {
        return ImmutableList.copyOf(anvilSmashingBlocks.entrySet());
    }

    public static ICauldronRecipe getCauldronResult(ItemStack input, boolean boiling, int level, ICauldronRecipe.CauldronState state) {
        for (ICauldronRecipe recipe : cauldronRecipes) {
            if (!recipe.matches(input, boiling, level, state)) continue;
            return recipe;
        }
        return null;
    }

    public static void addCauldronRecipe(ICauldronRecipe recipe) {
        if (new RegisterEvent.RegisterCauldronRecipe(recipe).fire()) {
            cauldronRecipes.add(recipe);
        } else {
            log.debug("Cauldron recipe '{}' canceled by event", (Object)recipe);
        }
    }

    public static void addCauldronRecipe(ItemStack input, ItemStack output, Boolean boiling) {
        InspirationsRegistry.addCauldronRecipe(new CauldronFluidRecipe(RecipeMatch.of((ItemStack)input), output, boiling));
    }

    public static void addCauldronRecipe(String input, ItemStack output, Boolean boiling) {
        InspirationsRegistry.addCauldronRecipe(new CauldronFluidRecipe(RecipeMatch.of((String)input), output, boiling));
    }

    public static void addCauldronScaledTransformRecipe(ItemStack stack, Fluid input, Fluid output, Boolean boiling) {
        InspirationsRegistry.addCauldronRecipe(new CauldronFluidTransformRecipe(RecipeMatch.of((ItemStack)stack, (int)stack.func_190916_E(), (int)1), input, output, boiling, 1));
        stack = stack.func_77946_l();
        int count = stack.func_190916_E();
        stack.func_190920_e(count * 2);
        if (Config.enableBiggerCauldron) {
            InspirationsRegistry.addCauldronRecipe(new CauldronFluidTransformRecipe(RecipeMatch.of((ItemStack)stack, (int)stack.func_190916_E(), (int)1), input, output, boiling, 2));
            stack = stack.func_77946_l();
            stack.func_190920_e(count * 3);
        }
        InspirationsRegistry.addCauldronRecipe(new CauldronFluidTransformRecipe(RecipeMatch.of((ItemStack)stack, (int)stack.func_190916_E(), (int)1), input, output, boiling, Config.enableBiggerCauldron ? 4 : 3));
    }

    public static void addCauldronScaledTransformRecipe(String name, int count, Fluid input, Fluid output, Boolean boiling) {
        InspirationsRegistry.addCauldronRecipe(new CauldronFluidTransformRecipe((RecipeMatch)new RecipeMatchOredictStack(name, count, 1), input, output, boiling, 1));
        int fullCount = count * 2;
        if (Config.enableBiggerCauldron) {
            InspirationsRegistry.addCauldronRecipe(new CauldronFluidTransformRecipe((RecipeMatch)new RecipeMatchOredictStack(name, count * 2, 1), input, output, boiling, 2));
            fullCount = count * 3;
        }
        InspirationsRegistry.addCauldronRecipe(new CauldronFluidTransformRecipe((RecipeMatch)new RecipeMatchOredictStack(name, fullCount, 1), input, output, boiling, Config.enableBiggerCauldron ? 4 : 3));
    }

    public static void addCauldronFluidItem(ItemStack filled, ItemStack container, Fluid fluid, int amount) {
        InspirationsRegistry.addCauldronRecipe(new FillCauldronRecipe(RecipeMatch.of((ItemStack)filled), fluid, amount, container.func_77946_l()));
        InspirationsRegistry.addCauldronRecipe(new CauldronFluidRecipe(RecipeMatch.of((ItemStack)container), fluid, filled.func_77946_l(), null, amount, SoundEvents.field_187615_H));
    }

    public static void addCauldronFluidItem(ItemStack filled, ItemStack container, Fluid fluid) {
        InspirationsRegistry.addCauldronFluidItem(filled, container, fluid, 1);
    }

    public static List<ICauldronRecipe> getAllCauldronRecipes() {
        return ImmutableList.copyOf(cauldronRecipes);
    }

    public static void addCauldronBlacklist(Item item, int meta) {
        cauldronBlacklist.add(new ItemMetaKey(item, meta));
    }

    public static boolean isCauldronBlacklist(ItemStack stack) {
        return cauldronBlacklist.contains(new ItemMetaKey(stack)) || cauldronBlacklist.contains(new ItemMetaKey(stack.func_77973_b(), Short.MAX_VALUE));
    }

    public static int getCauldronMax() {
        return cauldronBigger ? 4 : 3;
    }

    public static boolean expensiveCauldronBrewing() {
        return expensiveCauldronBrewing;
    }

    public static void addCauldronWater(Fluid fluid) {
        cauldronWater.add(fluid);
    }

    public static boolean isCauldronWater(Fluid fluid) {
        return fluid != null && cauldronWater.contains(fluid);
    }

    public static void registerCauldronFire(Block block) {
        cauldronFireBlocks.add(block);
    }

    public static void registerCauldronFire(IBlockState block) {
        cauldronFireStates.add(block);
    }

    public static boolean isCauldronFire(IBlockState state) {
        return cauldronFireBlocks.contains(state.func_177230_c()) || cauldronFireStates.contains(state);
    }

    public static void registerDefaultCauldron() {
        cauldronBlockStates.put((Block)Blocks.field_150383_bp, ICauldronRecipe.CauldronState.WATER);
    }

    public static void registerFullCauldron(IBlockState state, ICauldronRecipe.CauldronState cauldronState) {
        cauldronBlockStates.put(state.func_177230_c(), cauldronState);
        cauldronFullStates.put(cauldronState, state);
    }

    public static boolean isNormalCauldron(IBlockState state) {
        return cauldronBlockStates.containsKey(state.func_177230_c());
    }

    public static ICauldronRecipe.CauldronState getCauldronState(IBlockState state) {
        Block block = state.func_177230_c();
        if (cauldronBlockStates.containsKey(block)) {
            return cauldronBlockStates.get(block);
        }
        throw new IllegalArgumentException("Attempted to get state of a cauldron that is not registered");
    }

    public static boolean hasFullCauldron(ICauldronRecipe.CauldronState state) {
        return cauldronFullStates.containsKey(state);
    }

    @Nullable
    public static IBlockState getFullCauldron(ICauldronRecipe.CauldronState state) {
        return cauldronFullStates.get(state);
    }
}

