/*
 * Decompiled with CFR 0.152.
 */
package rustic.common.crafting;

import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistryEntry;
import rustic.common.blocks.ModBlocks;

public class RecipeCabinet
extends IForgeRegistryEntry.Impl<IRecipe>
implements IRecipe {
    protected boolean hasOre(ItemStack stack, int ore) {
        int[] oreIds;
        if (stack.func_190926_b()) {
            return false;
        }
        for (int oreId : oreIds = OreDictionary.getOreIDs((ItemStack)stack)) {
            if (oreId != ore) continue;
            return true;
        }
        return false;
    }

    private boolean isTrapdoor(ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item == Item.func_150898_a((Block)Blocks.field_150415_aT)) {
            return true;
        }
        int trapdoorWood = OreDictionary.getOreID((String)"trapdoorWood");
        return this.hasOre(stack, trapdoorWood);
    }

    protected boolean isWood(ItemStack stack) {
        if (this.hasOre(stack, OreDictionary.getOreID((String)"plankWood"))) {
            return true;
        }
        if (stack.func_77973_b().getRegistryName().toString().equals("embers:sealed_planks")) {
            return true;
        }
        if (stack.func_77973_b().getRegistryName().toString().equals("botania:livingwood") && stack.func_77960_j() == 1) {
            return true;
        }
        if (stack.func_77973_b().getRegistryName().toString().equals("botania:dreamwood") && stack.func_77960_j() == 1) {
            return true;
        }
        if (stack.func_77973_b().getRegistryName().toString().equals("astralsorcery:blockinfusedwood") && stack.func_77960_j() == 1) {
            return true;
        }
        return this.hasOre(stack, OreDictionary.getOreID((String)"plankTreatedWood"));
    }

    public boolean func_77569_a(InventoryCrafting inv, World worldIn) {
        ItemStack stack = ItemStack.field_190927_a;
        for (int y = 0; y < 3; y += 2) {
            for (int x = 0; x < 3; ++x) {
                stack = inv.func_70463_b(x, y);
                if (this.isWood(stack)) continue;
                return false;
            }
        }
        stack = inv.func_70463_b(1, 1);
        if (!stack.func_190926_b()) {
            return false;
        }
        ItemStack stack2 = inv.func_70463_b(2, 1);
        stack = inv.func_70463_b(0, 1);
        return this.isWood(stack) && this.isTrapdoor(stack2) || this.isWood(stack2) && this.isTrapdoor(stack);
    }

    public ItemStack func_77572_b(InventoryCrafting inv) {
        ItemStack result = this.func_77571_b();
        ItemStack material = ItemStack.field_190927_a;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i).func_77946_l();
            stack.func_190920_e(1);
            if (!this.isWood(stack)) continue;
            if (!material.func_190926_b() && !ItemStack.func_77989_b((ItemStack)material, (ItemStack)stack)) {
                material = ItemStack.field_190927_a;
                break;
            }
            material = stack;
        }
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74782_a("material", (NBTBase)material.serializeNBT());
        result.func_77982_d(tag);
        return result;
    }

    public ItemStack func_77571_b() {
        return new ItemStack((Block)ModBlocks.CABINET);
    }

    public boolean func_194133_a(int width, int height) {
        return width >= 3 && height >= 3;
    }

    public boolean func_192399_d() {
        return true;
    }
}

