/*
 * Decompiled with CFR 0.152.
 */
package artifacts.common.entity;

import artifacts.common.ModConfig;
import artifacts.common.init.ModLootTables;
import artifacts.common.init.ModSoundEvents;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAITarget;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.scoreboard.Team;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.ILootContainer;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class EntityMimic
extends EntityLiving
implements IMob {
    public int ticksInAir;
    public boolean isDormant;

    public EntityMimic(World world) {
        super(world);
        this.field_70765_h = new MimicMoveHelper(this);
        this.func_70105_a(0.875f, 0.875f);
        this.field_70728_aV = 20;
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        this.setRandomMoveRotation();
        return super.func_180482_a(difficulty, livingdata);
    }

    public void setMoveRotation(float rotation, boolean aggressive) {
        ((MimicMoveHelper)this.field_70765_h).setDirection(rotation, aggressive);
    }

    public void setRandomMoveRotation() {
        this.setMoveRotation(this.field_70146_Z.nextInt(4) * 90, false);
    }

    public SoundCategory func_184176_by() {
        return SoundCategory.HOSTILE;
    }

    public boolean func_70692_ba() {
        return false;
    }

    protected boolean func_184228_n(Entity entity) {
        return false;
    }

    protected boolean func_184219_q(Entity entity) {
        return false;
    }

    public boolean func_96092_aw() {
        return false;
    }

    public boolean func_70648_aU() {
        return true;
    }

    protected void func_82167_n(Entity entity) {
    }

    @Nullable
    public AxisAlignedBB func_70046_E() {
        return this.func_70089_S() ? this.func_174813_aQ() : null;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(100.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(24.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(4.0);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AIMimicFloat(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new AIMimicAttack(this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new AIMimicFaceRandom(this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new AIMimicHop(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new AIMimicFindNearestPlayer(this));
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("ticksInAir", this.ticksInAir);
        compound.func_74757_a("isDormant", this.isDormant);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.ticksInAir = compound.func_74762_e("ticksInAir");
        this.isDormant = compound.func_74767_n("isDormant");
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL) {
            this.field_70128_L = true;
        }
        super.func_70071_h_();
        if (this.func_70090_H() || this.func_180799_ab()) {
            this.ticksInAir = 0;
            if (this.isDormant) {
                this.setDormant(false);
            }
        } else if (!this.field_70122_E) {
            ++this.ticksInAir;
        } else {
            if (this.ticksInAir > 0) {
                this.func_184185_a(this.getLandingSound(), this.func_70599_aP(), this.func_70647_i());
                this.ticksInAir = 0;
            }
            if (this.func_70638_az() != null && this.field_70173_aa % 20 == 0) {
                double d0 = this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111126_e();
                if (this.func_70068_e((Entity)this.func_70638_az()) > d0 * d0) {
                    this.func_70624_b(null);
                }
            }
            if (this.func_70638_az() == null) {
                this.setDormant(true);
            }
        }
    }

    public void func_70108_f(Entity entityIn) {
        super.func_70108_f(entityIn);
        if (entityIn instanceof EntityLivingBase) {
            this.dealDamage((EntityLivingBase)entityIn);
        }
    }

    public void func_70100_b_(EntityPlayer player) {
        this.dealDamage((EntityLivingBase)player);
    }

    private void dealDamage(EntityLivingBase entity) {
        if (!this.isDormant && this.ticksInAir > 0 && this.func_70068_e((Entity)entity) < 1.5 && entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e())) {
            this.func_174815_a((EntityLivingBase)this, (Entity)entity);
        }
    }

    public boolean func_180431_b(DamageSource source) {
        return super.func_180431_b(source) || this.ticksInAir <= 0 && !source.func_180136_u() && !source.func_76347_k() && !source.func_76363_c();
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (super.func_70097_a(source, amount)) {
            if (!(!(source.func_76346_g() instanceof EntityLivingBase) || source.func_76346_g() instanceof EntityPlayer && ((EntityPlayer)source.func_76346_g()).field_71075_bZ.field_75102_a)) {
                this.func_70624_b((EntityLivingBase)source.func_76346_g());
            }
            this.setDormant(false);
            return true;
        }
        return false;
    }

    public void func_70110_aj() {
    }

    public float func_70047_e() {
        return 0.7f;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return ModSoundEvents.MIMIC_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return ModSoundEvents.MIMIC_DEATH;
    }

    protected SoundEvent getJumpingSound() {
        return ModSoundEvents.MIMIC_OPEN;
    }

    protected SoundEvent getLandingSound() {
        return ModSoundEvents.MIMIC_CLOSE;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return ModLootTables.MIMIC_UNDERGROUND;
    }

    protected void func_70664_aZ() {
        this.field_70181_x = 0.5;
        this.field_70160_al = true;
        ForgeHooks.onLivingJump((EntityLivingBase)this);
    }

    public void setDormant(boolean dormant) {
        this.isDormant = dormant;
    }

    public void setAwakeWithTarget(EntityPlayer player) {
        this.func_70624_b((EntityLivingBase)player);
        this.setDormant(false);
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (!player.func_184812_l_()) {
            this.setAwakeWithTarget(player);
            player.func_184609_a(EnumHand.MAIN_HAND);
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    static class MimicMoveHelper
    extends EntityMoveHelper {
        private float rotationDegrees;
        private int jumpDelay;
        private final EntityMimic mimic;
        private boolean isAggressive;

        public MimicMoveHelper(EntityMimic mimic) {
            super((EntityLiving)mimic);
            this.mimic = mimic;
            this.rotationDegrees = 180.0f * mimic.field_70177_z / (float)Math.PI;
            this.jumpDelay = mimic.field_70146_Z.nextInt(30) + 30;
        }

        public void setDirection(float rotation, boolean isAggressive) {
            this.rotationDegrees = rotation;
            this.isAggressive = isAggressive;
        }

        public void setSpeed(double speed) {
            this.field_75645_e = speed;
            this.field_188491_h = EntityMoveHelper.Action.MOVE_TO;
        }

        public void func_75641_c() {
            this.field_75648_a.field_70759_as = this.field_75648_a.field_70177_z = this.func_75639_a(this.field_75648_a.field_70177_z, this.rotationDegrees, 90.0f);
            this.field_75648_a.field_70761_aq = this.field_75648_a.field_70177_z;
            if (this.field_188491_h != EntityMoveHelper.Action.MOVE_TO) {
                this.field_75648_a.func_191989_p(0.0f);
            } else {
                this.field_188491_h = EntityMoveHelper.Action.WAIT;
                if (this.field_75648_a.field_70122_E) {
                    this.field_75648_a.func_70659_e((float)(this.field_75645_e * this.field_75648_a.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e()));
                    if (this.jumpDelay-- > 0) {
                        this.mimic.field_70702_br = 0.0f;
                        this.mimic.field_191988_bg = 0.0f;
                        this.field_75648_a.func_70659_e(0.0f);
                    } else {
                        this.jumpDelay = this.mimic.field_70146_Z.nextInt(30) + 30;
                        if (this.isAggressive) {
                            this.jumpDelay /= 3;
                        }
                        this.mimic.func_70683_ar().func_75660_a();
                        this.mimic.func_184185_a(this.mimic.getJumpingSound(), this.mimic.func_70599_aP(), this.mimic.func_70647_i());
                    }
                } else {
                    this.field_75648_a.func_70659_e((float)(this.field_75645_e * this.field_75648_a.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e()));
                }
            }
        }
    }

    static class AIMimicFindNearestPlayer
    extends EntityAIBase {
        private final EntityMimic mimic;
        private final Predicate<Entity> predicate;
        private final EntityAINearestAttackableTarget.Sorter sorter;
        private EntityLivingBase target;

        public AIMimicFindNearestPlayer(EntityMimic mimic) {
            this.mimic = mimic;
            this.predicate = target -> {
                if (!(target instanceof EntityPlayer)) {
                    return false;
                }
                if (((EntityPlayer)target).field_71075_bZ.field_75102_a) {
                    return false;
                }
                return !(target.func_70068_e((Entity)this.mimic) > this.startTargetRange() * this.startTargetRange()) && EntityAITarget.func_179445_a((EntityLiving)this.mimic, (EntityLivingBase)((EntityLivingBase)target), (boolean)false, (boolean)true);
            };
            this.sorter = new EntityAINearestAttackableTarget.Sorter((Entity)mimic);
        }

        public boolean func_75250_a() {
            List list = this.mimic.field_70170_p.func_175647_a(EntityPlayer.class, this.mimic.func_174813_aQ().func_72314_b(this.startTargetRange(), 4.0, this.startTargetRange()), this.predicate::test);
            list.sort(this.sorter);
            if (list.isEmpty()) {
                return false;
            }
            this.target = (EntityLivingBase)list.get(0);
            if (this.mimic.isDormant) {
                this.mimic.setDormant(false);
            }
            return true;
        }

        public boolean func_75253_b() {
            EntityLivingBase entitylivingbase = this.mimic.func_70638_az();
            if (entitylivingbase == null) {
                return false;
            }
            if (!entitylivingbase.func_70089_S()) {
                return false;
            }
            if (entitylivingbase instanceof EntityPlayer && ((EntityPlayer)entitylivingbase).field_71075_bZ.field_75102_a) {
                return false;
            }
            Team team = this.mimic.func_96124_cp();
            Team team1 = entitylivingbase.func_96124_cp();
            if (team != null && team1 == team) {
                return false;
            }
            double targetRange = this.maxTargetRange();
            if (this.mimic.func_70068_e((Entity)entitylivingbase) > targetRange * targetRange) {
                return false;
            }
            return !(entitylivingbase instanceof EntityPlayerMP) || !((EntityPlayerMP)entitylivingbase).field_71134_c.func_73083_d();
        }

        public void func_75249_e() {
            this.mimic.func_70624_b(this.target);
            super.func_75249_e();
        }

        public void func_75251_c() {
            this.mimic.func_70624_b(null);
            super.func_75249_e();
        }

        protected double maxTargetRange() {
            return this.mimic.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111126_e();
        }

        protected double startTargetRange() {
            return 4.0;
        }
    }

    static class AIMimicHop
    extends EntityAIBase {
        private final EntityMimic mimic;

        public AIMimicHop(EntityMimic mimic) {
            this.mimic = mimic;
            this.func_75248_a(5);
        }

        public boolean func_75250_a() {
            return !this.mimic.isDormant;
        }

        public void func_75246_d() {
            ((MimicMoveHelper)this.mimic.func_70605_aq()).setSpeed(1.15);
        }
    }

    static class AIMimicFloat
    extends EntityAIBase {
        private final EntityMimic mimic;

        public AIMimicFloat(EntityMimic mimic) {
            this.mimic = mimic;
            this.func_75248_a(5);
            ((PathNavigateGround)mimic.func_70661_as()).func_179693_d(true);
        }

        public boolean func_75250_a() {
            return this.mimic.func_70090_H() || this.mimic.func_180799_ab();
        }

        public void func_75246_d() {
            if (this.mimic.func_70681_au().nextFloat() < 0.8f) {
                this.mimic.func_70683_ar().func_75660_a();
            }
            ((MimicMoveHelper)this.mimic.func_70605_aq()).setSpeed(1.3);
        }
    }

    static class AIMimicFaceRandom
    extends EntityAIBase {
        private final EntityMimic mimic;
        private int chosenDegrees;
        private int timeUntilNextFaceRandom;

        public AIMimicFaceRandom(EntityMimic mimic) {
            this.mimic = mimic;
            this.func_75248_a(2);
        }

        public boolean func_75250_a() {
            return this.mimic.func_70638_az() == null && (this.mimic.field_70122_E || this.mimic.func_70090_H() || this.mimic.func_180799_ab() || this.mimic.func_70644_a(MobEffects.field_188424_y));
        }

        public void func_75246_d() {
            if (--this.timeUntilNextFaceRandom <= 0) {
                this.timeUntilNextFaceRandom = 40 + this.mimic.func_70681_au().nextInt(60);
                if (this.mimic.isDormant) {
                    this.chosenDegrees = Math.round(this.mimic.field_70177_z / 90.0f) * 90;
                    this.mimic.func_70107_b(Math.floor(this.mimic.field_70165_t) + 0.5, this.mimic.field_70163_u, Math.floor(this.mimic.field_70161_v) + 0.5);
                } else if (this.mimic.field_70122_E && !this.mimic.func_70090_H() && !this.mimic.func_180799_ab() && !this.mimic.func_70644_a(MobEffects.field_188424_y)) {
                    this.chosenDegrees = this.mimic.func_70681_au().nextInt(4) * 90;
                    if (this.mimic.field_70122_E) {
                        this.mimic.setDormant(true);
                    }
                } else {
                    this.chosenDegrees = this.mimic.func_70681_au().nextInt(4) * 90;
                }
            }
            ((MimicMoveHelper)this.mimic.func_70605_aq()).setDirection(this.chosenDegrees, false);
        }
    }

    static class AIMimicAttack
    extends EntityAIBase {
        private final EntityMimic mimic;
        private int executeTimeRemaining;

        public AIMimicAttack(EntityMimic mimic) {
            this.mimic = mimic;
            this.func_75248_a(2);
        }

        public boolean func_75250_a() {
            EntityLivingBase entitylivingbase = this.mimic.func_70638_az();
            if (entitylivingbase == null) {
                return false;
            }
            if (!entitylivingbase.func_70089_S()) {
                return false;
            }
            return !(entitylivingbase instanceof EntityPlayer) || !((EntityPlayer)entitylivingbase).field_71075_bZ.field_75102_a;
        }

        public void func_75249_e() {
            this.executeTimeRemaining = 300;
            super.func_75249_e();
        }

        public boolean func_75253_b() {
            EntityLivingBase entitylivingbase = this.mimic.func_70638_az();
            if (entitylivingbase == null) {
                return false;
            }
            if (!entitylivingbase.func_70089_S()) {
                return false;
            }
            if (entitylivingbase instanceof EntityPlayer && ((EntityPlayer)entitylivingbase).field_71075_bZ.field_75102_a) {
                return false;
            }
            return --this.executeTimeRemaining > 0;
        }

        public void func_75246_d() {
            if (this.mimic.func_70638_az() != null) {
                this.mimic.func_70625_a((Entity)this.mimic.func_70638_az(), 10.0f, 10.0f);
                ((MimicMoveHelper)this.mimic.func_70605_aq()).setDirection(this.mimic.field_70177_z, true);
            }
        }
    }

    @Mod.EventBusSubscriber(modid="artifacts")
    static class MimicEventHandler {
        MimicEventHandler() {
        }

        @SubscribeEvent(priority=EventPriority.LOW)
        public static void onRightClick(PlayerInteractEvent.RightClickBlock event) {
            if (event.getUseBlock() == Event.Result.DENY || event.getWorld().field_72995_K || event.getEntityPlayer() == null || ModConfig.general.unlootedChestMimicRatio <= 0.0) {
                return;
            }
            BlockPos pos = event.getPos();
            World world = event.getWorld();
            TileEntity tile = world.func_175625_s(pos);
            Block block = world.func_180495_p(pos).func_177230_c();
            EntityPlayer player = event.getEntityPlayer();
            if (tile instanceof TileEntityChest && block instanceof BlockChest && !player.func_175149_v()) {
                if (!Arrays.asList(ModConfig.general.unlootedChestDimensions).contains(event.getWorld().field_73011_w.getDimension())) {
                    return;
                }
                if (world.func_180495_p(pos.func_177984_a()).doesSideBlockChestOpening((IBlockAccess)world, pos.func_177984_a(), EnumFacing.DOWN)) {
                    return;
                }
                if (((ILootContainer)tile).func_184276_b() != null) {
                    ((TileEntityChest)tile).func_184281_d(player);
                    if ((double)world.field_73012_v.nextFloat() <= ModConfig.general.unlootedChestMimicRatio) {
                        event.setCanceled(true);
                        world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
                        EntityMimic mimic = new EntityMimic(world);
                        mimic.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
                        mimic.func_110163_bv();
                        mimic.setAwakeWithTarget(player);
                        world.func_72838_d((Entity)mimic);
                    }
                }
            }
        }

        @SubscribeEvent(priority=EventPriority.LOW)
        public static void onBlockBreak(BlockEvent.BreakEvent event) {
            if (event.getWorld().field_72995_K || event.getPlayer() == null || ModConfig.general.unlootedChestMimicRatio <= 0.0) {
                return;
            }
            BlockPos pos = event.getPos();
            World world = event.getWorld();
            TileEntity tile = world.func_175625_s(pos);
            Block block = world.func_180495_p(pos).func_177230_c();
            EntityPlayer player = event.getPlayer();
            if (tile instanceof TileEntityChest && block instanceof BlockChest && !player.func_175149_v()) {
                if (!Arrays.asList(ModConfig.general.unlootedChestDimensions).contains(event.getWorld().field_73011_w.getDimension())) {
                    return;
                }
                if (((ILootContainer)tile).func_184276_b() != null) {
                    ((TileEntityChest)tile).func_184281_d(player);
                    if ((double)world.field_73012_v.nextFloat() <= ModConfig.general.unlootedChestMimicRatio) {
                        event.setCanceled(true);
                        world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
                        EntityMimic mimic = new EntityMimic(world);
                        mimic.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
                        mimic.func_110163_bv();
                        mimic.setAwakeWithTarget(player);
                        world.func_72838_d((Entity)mimic);
                    }
                }
            }
        }
    }
}

