/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.notreepunching.util;

import com.alcatrazescapee.alcatrazcore.inventory.crafting.InventoryCraftingEmpty;
import com.alcatrazescapee.alcatrazcore.util.CoreHelpers;
import com.alcatrazescapee.notreepunching.ModConfig;
import com.alcatrazescapee.notreepunching.NoTreePunching;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.registries.IForgeRegistryModifiable;

@ParametersAreNonnullByDefault
public final class WoodRecipeHandler {
    private static final Map<ItemStack, ItemStack> WOOD_TYPES = new HashMap<ItemStack, ItemStack>();
    private static int LOGS_FOUND = 0;

    public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        IForgeRegistryModifiable registry = (IForgeRegistryModifiable)event.getRegistry();
        WoodRecipeHandler.findMatchingRecipes(registry.getValuesCollection(), (IForgeRegistryModifiable<IRecipe>)registry);
        if (ModConfig.GENERAL.replaceLogRecipes) {
            registry.remove(new ResourceLocation("minecraft:stick"));
        }
    }

    public static void postInit() {
        WoodRecipeHandler.findMatchingRecipes(ForgeRegistries.RECIPES.getValuesCollection(), (IForgeRegistryModifiable<IRecipe>)((IForgeRegistryModifiable)ForgeRegistries.RECIPES));
    }

    public static void registerWoodRecipe(ItemStack log, ItemStack plank) {
        WOOD_TYPES.put(log, plank);
    }

    static boolean isLog(World world, BlockPos pos, IBlockState state) {
        ItemStack stack = state.func_177230_c().getPickBlock(state, null, world, pos, null);
        return WOOD_TYPES.keySet().stream().anyMatch(x -> CoreHelpers.doStacksMatch((ItemStack)stack, (ItemStack)x));
    }

    static boolean isPlank(World world, BlockPos pos, IBlockState state) {
        ItemStack stack = state.func_177230_c().getPickBlock(state, null, world, pos, null);
        return WOOD_TYPES.values().stream().anyMatch(x -> CoreHelpers.doStacksMatch((ItemStack)stack, (ItemStack)x));
    }

    static boolean isAxe(ItemStack stack) {
        return CoreHelpers.doesStackMatchOre((ItemStack)stack, (String)"toolAxe") || CoreHelpers.doesStackMatchOre((ItemStack)stack, (String)"toolWeakAxe") || stack.func_77973_b() instanceof ItemAxe || stack.func_77973_b().getToolClasses(stack).contains("axe");
    }

    static boolean isWeakAxe(ItemStack stack) {
        return CoreHelpers.doesStackMatchOre((ItemStack)stack, (String)"toolWeakAxe");
    }

    @Nullable
    static ItemStack getPlankForLog(World world, BlockPos pos, IBlockState state) {
        ItemStack search = state.func_177230_c().getPickBlock(state, null, world, pos, null);
        return WOOD_TYPES.entrySet().stream().filter(x -> CoreHelpers.doStacksMatch((ItemStack)((ItemStack)x.getKey()), (ItemStack)search)).map(Map.Entry::getValue).findFirst().orElse(null);
    }

    private static void findMatchingRecipes(Collection<IRecipe> recipes, IForgeRegistryModifiable<IRecipe> registry) {
        InventoryCraftingEmpty tempCrafting = new InventoryCraftingEmpty(3, 3);
        NonNullList logs = OreDictionary.getOres((String)"logWood", (boolean)false);
        int previousLogsFound = LOGS_FOUND;
        for (ItemStack stack : logs) {
            ItemStack plank;
            Block block = Block.func_149634_a((Item)stack.func_77973_b());
            if (block == Blocks.field_150350_a) continue;
            if (stack.func_77960_j() == Short.MAX_VALUE) {
                NonNullList variants = NonNullList.func_191196_a();
                block.func_149666_a(block.func_149708_J(), variants);
                for (ItemStack log : variants) {
                    ItemStack plank2;
                    tempCrafting.func_70299_a(0, log);
                    IRecipe recipe = WoodRecipeHandler.tryFindRecipeSafely(recipes, (InventoryCrafting)tempCrafting);
                    if (recipe == null || (plank2 = recipe.func_77572_b((InventoryCrafting)tempCrafting)).func_190926_b()) continue;
                    WOOD_TYPES.put(log.func_77946_l(), plank2.func_77946_l());
                    if (ModConfig.GENERAL.replaceLogRecipes) {
                        registry.remove(recipe.getRegistryName());
                    }
                    ResourceLocation loc = new ResourceLocation("notreepunching", "saw_planks_" + ++LOGS_FOUND);
                    registry.register(new ShapedOreRecipe(loc, plank2, new Object[]{"S", "W", Character.valueOf('S'), "toolSaw", Character.valueOf('W'), log}).setRegistryName(loc));
                }
                continue;
            }
            ItemStack log = stack.func_77946_l();
            tempCrafting.func_70299_a(0, log);
            IRecipe recipe = WoodRecipeHandler.tryFindRecipeSafely(recipes, (InventoryCrafting)tempCrafting);
            if (recipe == null || (plank = recipe.func_77572_b((InventoryCrafting)tempCrafting)).func_190926_b()) continue;
            WOOD_TYPES.put(log.func_77946_l(), plank.func_77946_l());
            if (ModConfig.GENERAL.replaceLogRecipes) {
                registry.remove(recipe.getRegistryName());
            }
            ResourceLocation loc = new ResourceLocation("notreepunching", "saw_planks_" + ++LOGS_FOUND);
            registry.register(new ShapedOreRecipe(loc, plank, new Object[]{"S", "W", Character.valueOf('S'), "toolSaw", Character.valueOf('W'), log}).setRegistryName(loc));
        }
        if (previousLogsFound == 0) {
            NoTreePunching.getLog().info("Found and replaced {} Log -> Planks recipes with Saw + Log -> Plank recipes. (First Pass)", (Object)LOGS_FOUND);
        } else {
            NoTreePunching.getLog().info("Found and replaced additional {} Log -> Planks recipes with Saw + Log -> Plank recipes. (Second Pass)", (Object)(LOGS_FOUND - previousLogsFound));
        }
    }

    @Nullable
    private static IRecipe tryFindRecipeSafely(Collection<IRecipe> recipes, InventoryCrafting tempCrafting) {
        try {
            return recipes.stream().filter(x -> x.func_77569_a(tempCrafting, null)).findFirst().orElse(null);
        }
        catch (Exception e) {
            return null;
        }
    }
}

