/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.notreepunching.common.tile;

import com.alcatrazescapee.alcatrazcore.tile.ITileFields;
import com.alcatrazescapee.alcatrazcore.tile.TileInventory;
import com.alcatrazescapee.alcatrazcore.util.CoreHelpers;
import com.alcatrazescapee.notreepunching.ModConfig;
import com.alcatrazescapee.notreepunching.NoTreePunching;
import com.alcatrazescapee.notreepunching.common.blocks.BlockFirePit;
import com.alcatrazescapee.notreepunching.common.recipe.FirePitRecipe;
import com.alcatrazescapee.notreepunching.common.recipe.ModRecipes;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@ParametersAreNonnullByDefault
public class TileFirePit
extends TileInventory
implements ITickable,
ITileFields {
    private static final byte BURN_FIELD_ID = 0;
    private static final byte MAX_BURN_FIELD_ID = 1;
    private static final byte COOK_FIELD_ID = 2;
    public static final byte FUEL_SLOT_ID = 0;
    public static final byte INPUT_SLOT_ID = 1;
    public static final byte OUTPUT_SLOT_ID = 2;
    private static final byte NUM_FIELDS = 3;
    private int burnTicks;
    private int maxBurnTicks;
    private int cookTimer;
    private boolean hasCachedRecipe = false;
    private FirePitRecipe cachedRecipe = null;

    private static boolean isStackValidFuel(ItemStack stack) {
        return TileEntityFurnace.func_145952_a((ItemStack)stack) > 0 && TileEntityFurnace.func_145952_a((ItemStack)stack) <= ModConfig.BALANCE.firePitFuelMaxAmount;
    }

    public TileFirePit() {
        super(3);
    }

    public void light(boolean addStartingFuel) {
        this.field_145850_b.func_175656_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a((IProperty)BlockFirePit.LIT, (Comparable)Boolean.valueOf(true)));
        if (addStartingFuel) {
            this.burnTicks = (int)(0.5 * (double)TileEntityFurnace.func_145952_a((ItemStack)new ItemStack(Blocks.field_150364_r)) * (double)ModConfig.BALANCE.firePitFuelMultiplier);
            this.maxBurnTicks = this.burnTicks * 2;
        }
    }

    public void extinguish() {
        this.field_145850_b.func_175656_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a((IProperty)BlockFirePit.LIT, (Comparable)Boolean.valueOf(false)));
        this.burnTicks = 0;
        this.maxBurnTicks = 0;
        this.cookTimer = 0;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (((Boolean)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockFirePit.LIT)).booleanValue()) {
                if (!this.hasCachedRecipe) {
                    this.updateRecipe();
                }
                if (this.cachedRecipe != null) {
                    ++this.cookTimer;
                    if (this.cookTimer >= ModConfig.BALANCE.firePitCookTime) {
                        this.updateRecipe();
                        if (this.cachedRecipe != null) {
                            ItemStack cookStack = this.inventory.getStackInSlot(1);
                            ItemStack outStack = this.inventory.getStackInSlot(2);
                            this.inventory.setStackInSlot(1, this.cachedRecipe.consumeInput(cookStack));
                            this.inventory.setStackInSlot(2, CoreHelpers.mergeStacks((ItemStack)outStack, (ItemStack)this.cachedRecipe.getOutput()));
                            this.updateRecipe();
                        }
                        this.cookTimer = 0;
                    }
                } else if (this.cookTimer > 0) {
                    this.cookTimer -= 4;
                    if (this.cookTimer < 0) {
                        this.cookTimer = 0;
                    }
                }
                --this.burnTicks;
                if (this.burnTicks <= 0) {
                    ItemStack stack = this.inventory.getStackInSlot(0);
                    if (TileFirePit.isStackValidFuel(stack)) {
                        this.burnTicks += TileEntityFurnace.func_145952_a((ItemStack)stack) * ModConfig.BALANCE.firePitFuelMultiplier;
                        this.maxBurnTicks = this.burnTicks;
                        stack = CoreHelpers.consumeItem((ItemStack)stack);
                        this.inventory.setStackInSlot(0, stack);
                    } else {
                        this.burnTicks = 0;
                        this.field_145850_b.func_175656_a(this.field_174879_c, state.func_177226_a((IProperty)BlockFirePit.LIT, (Comparable)Boolean.valueOf(false)));
                    }
                }
            } else {
                this.burnTicks = 0;
                this.maxBurnTicks = 0;
            }
        }
    }

    public void setAndUpdateSlots(int slot) {
        if (!this.field_145850_b.field_72995_K) {
            this.updateRecipe();
        }
        super.setAndUpdateSlots(slot);
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        switch (slot) {
            case 0: {
                return TileFirePit.isStackValidFuel(stack);
            }
            case 2: {
                return false;
            }
            case 1: {
                return true;
            }
        }
        throw new IllegalArgumentException("Invalid slot id in isItemValid: " + slot);
    }

    @SideOnly(value=Side.CLIENT)
    public int getScaledCookTime() {
        if (ModConfig.BALANCE.firePitCookTime != 0 && this.cookTimer != 0) {
            float f1 = (float)this.cookTimer / (float)ModConfig.BALANCE.firePitCookTime;
            return Math.round(23.0f * f1);
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public int getScaledBurnTicks() {
        if (this.maxBurnTicks != 0 && this.burnTicks != 0) {
            float f1 = (float)this.burnTicks / (float)this.maxBurnTicks;
            return Math.round(13.0f * f1);
        }
        return 0;
    }

    public int getFieldCount() {
        return 3;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        this.burnTicks = nbt.func_74762_e("burn_ticks");
        this.maxBurnTicks = nbt.func_74762_e("max_burn_ticks");
        this.cookTimer = nbt.func_74762_e("cook_ticks");
        super.func_145839_a(nbt);
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74768_a("burn_ticks", this.burnTicks);
        nbt.func_74768_a("max_burn_ticks", this.maxBurnTicks);
        nbt.func_74768_a("cook_ticks", this.cookTimer);
        return super.func_189515_b(nbt);
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    private void updateRecipe() {
        ItemStack output;
        ItemStack outStack;
        this.hasCachedRecipe = true;
        ItemStack cookStack = this.inventory.getStackInSlot(1);
        FirePitRecipe recipe = (FirePitRecipe)ModRecipes.FIRE_PIT.get((Object)cookStack);
        if (recipe != null && CoreHelpers.canMergeStacks((ItemStack)(outStack = this.inventory.getStackInSlot(2)), (ItemStack)(output = recipe.getOutput()))) {
            this.cachedRecipe = recipe;
            return;
        }
        this.cachedRecipe = null;
    }

    public int getField(int id) {
        switch (id) {
            case 0: {
                return this.burnTicks;
            }
            case 1: {
                return this.maxBurnTicks;
            }
            case 2: {
                return this.cookTimer;
            }
        }
        NoTreePunching.getLog().warn("Invalid field ID: {}", (Object)id);
        return 0;
    }

    public void setField(int id, int value) {
        switch (id) {
            case 0: {
                this.burnTicks = value;
                break;
            }
            case 1: {
                this.maxBurnTicks = value;
                break;
            }
            case 2: {
                this.cookTimer = value;
                break;
            }
            default: {
                NoTreePunching.getLog().warn("Invalid Field ID {}", (Object)id);
            }
        }
    }
}

