/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.notreepunching.common.blocks;

import com.alcatrazescapee.alcatrazcore.block.BlockCore;
import com.alcatrazescapee.alcatrazcore.util.CoreHelpers;
import com.alcatrazescapee.notreepunching.ModConfig;
import com.alcatrazescapee.notreepunching.common.items.ItemRock;
import com.alcatrazescapee.notreepunching.util.types.Stone;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

@ParametersAreNonnullByDefault
public class BlockRock
extends BlockCore {
    private static final Map<Stone, BlockRock> MAP = new HashMap<Stone, BlockRock>();
    private final Stone type;

    public static BlockRock get(Stone type) {
        return MAP.get((Object)type);
    }

    public BlockRock(Stone type) {
        super(Material.field_151578_c);
        this.type = type;
        MAP.put(type, this);
        this.func_149711_c(0.15f);
        this.func_149672_a(SoundType.field_185851_d);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return new AxisAlignedBB(0.375, 0.0, 0.375, 0.615, 0.0625, 0.625);
    }

    @Nonnull
    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        IBlockState stateUnder;
        if (!worldIn.field_72995_K && !(stateUnder = worldIn.func_180495_p(pos.func_177977_b())).func_185915_l()) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (ModConfig.BALANCE.canPickUpRocks) {
            ItemStack stack = this.getPickBlock(state, null, worldIn, pos, playerIn);
            CoreHelpers.giveItemToPlayer((World)worldIn, (EntityPlayer)playerIn, (ItemStack)stack);
            worldIn.func_175698_g(pos);
            return true;
        }
        return false;
    }

    public boolean func_181623_g() {
        return true;
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        drops.clear();
        drops.add((Object)new ItemStack((Item)ItemRock.get(this.type)));
    }

    @Nonnull
    public ItemStack getPickBlock(IBlockState state, @Nullable RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack((Item)ItemRock.get(this.type));
    }

    @Nullable
    public String getHarvestTool(IBlockState state) {
        return null;
    }

    public int getHarvestLevel(IBlockState state) {
        return 0;
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return true;
    }
}

