/*
 * Decompiled with CFR 0.152.
 */
package goblinbob.mobends.core.client.gui.packswindow;

import goblinbob.mobends.core.client.gui.packswindow.GuiPacksWindow;
import goblinbob.mobends.core.util.Draw;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;

public class GuiPackTab {
    public static final int WIDTH = 18;
    public static final int HEIGHT = 15;
    public final String titleKey;
    private final int textureIndex;
    private int x;
    private int y;
    private boolean hovered;
    private boolean selected;
    private float selectedTransitionTween;

    public GuiPackTab(String titleKey, int textureIndex) {
        this.titleKey = titleKey;
        this.textureIndex = textureIndex;
        this.hovered = false;
        this.selected = false;
        this.selectedTransitionTween = 0.0f;
    }

    public void initGui(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void update(int mouseX, int mouseY) {
        this.hovered = mouseX >= this.x && mouseX <= this.x + 18 && mouseY >= this.y - 15 && mouseY <= this.y;
        this.selectedTransitionTween = this.selected ? Math.min(this.selectedTransitionTween + 0.2f, 1.0f) : Math.max(this.selectedTransitionTween - 0.2f, 0.0f);
    }

    public void draw(int mouseX, int mouseY) {
        this.update(mouseX, mouseY);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(GuiPacksWindow.BACKGROUND_TEXTURE);
        int yOffset = this.y - 15 + (this.selected ? -1 : 0);
        int SELECTED_TEXTURE_Y = 147;
        int HOVERED_TEXTURE_Y = 132;
        int NEUTRAL_TEXTURE_Y = 117;
        int textureY = this.hovered ? 132 : 117;
        Draw.texturedModalRect(this.x, yOffset, this.textureIndex * 18, textureY, 18, 15);
        if (this.selectedTransitionTween > 0.0f) {
            GlStateManager.func_179147_l();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)this.selectedTransitionTween);
            Draw.texturedModalRect(this.x, yOffset, this.textureIndex * 18, 147, 18, 15);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179084_k();
        }
    }

    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        this.update(mouseX, mouseY);
        return this.hovered;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }
}

