/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.tools.datastructures;

import com.fantasticsource.tools.Tools;

public class ShiftableGrid<T> {
    private Object[][] values;
    private int xOffset = 0;
    private int yOffset = 0;
    private int w;
    private int h;

    public ShiftableGrid(int width, int height) {
        if (width < 0 || height < 0) {
            throw new IllegalArgumentException("Width and height must both be >= 0. Given values: w = " + width + ", h = " + height);
        }
        this.w = width;
        this.h = height;
        this.values = new Object[this.w][this.h];
    }

    public void set(int x, int y, T value) {
        this.values[Tools.posMod((int)(x + this.xOffset), (int)this.w)][Tools.posMod((int)(y + this.yOffset), (int)this.h)] = value;
    }

    public T get(int x, int y) {
        return (T)this.values[Tools.posMod(x + this.xOffset, this.w)][Tools.posMod(y + this.yOffset, this.h)];
    }

    public void clear() {
        this.values = new Object[this.w][this.h];
    }

    public void shift(int x, int y) {
        int iy;
        int ix;
        if (x < 0) {
            for (ix = 0; ix > x && ix > -this.w; --ix) {
                this.clearColumn(this.xOffset);
                ++this.xOffset;
                if (this.xOffset != this.w) continue;
                this.xOffset = 0;
            }
        } else {
            for (ix = 0; ix < x && ix < this.w; ++ix) {
                if (this.xOffset == 0) {
                    this.xOffset = this.w;
                }
                --this.xOffset;
                this.clearColumn(this.xOffset);
            }
        }
        if (y < 0) {
            for (iy = 0; iy > y && iy > -this.h; --iy) {
                this.clearRow(this.yOffset);
                ++this.yOffset;
                if (this.yOffset != this.h) continue;
                this.yOffset = 0;
            }
        } else {
            for (iy = 0; iy < y && iy < this.h; ++iy) {
                if (this.yOffset == 0) {
                    this.yOffset = this.h;
                }
                --this.yOffset;
                this.clearRow(this.yOffset);
            }
        }
    }

    private void clearRow(int y) {
        for (int i = 0; i < this.h; ++i) {
            this.values[i][y] = null;
        }
    }

    private void clearColumn(int x) {
        for (int i = 0; i < this.h; ++i) {
            this.values[x][i] = null;
        }
    }

    public String toString(int x, int y) {
        T t = this.get(x, y);
        if (t == null) {
            return "";
        }
        return t.toString();
    }

    public String toString() {
        if (this.w == 0 || this.h == 0) {
            return "Grid can't hold anything (width = " + this.w + ", height = " + this.h + ")";
        }
        StringBuilder result = new StringBuilder();
        for (int iy = 0; iy < this.h; ++iy) {
            result.append(this.toString(0, iy));
            for (int ix = 1; ix < this.w; ++ix) {
                result.append(", ").append(this.toString(ix, iy));
            }
            result.append("\r\n");
        }
        return result.toString();
    }

    public void print() {
        System.out.println(this.toString());
    }
}

