/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;

public class StringList {
    private String filename;
    private ArrayList<String> strings = new ArrayList(10);

    public StringList(String filename) {
        this.filename = filename;
        this.load();
    }

    public void save() {
        new File("data/").mkdir();
        File f = new File("data/" + this.filename + ".txt");
        try {
            FileWriter fw = new FileWriter(f);
            for (String string : this.strings) {
                fw.write(string + "\r\n");
            }
            fw.flush();
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void load() {
        try {
            BufferedReader fileReader = new BufferedReader(new FileReader("data/" + this.filename + ".txt"));
            try {
                String line = fileReader.readLine();
                while (line != null) {
                    this.strings.add(line);
                    line = fileReader.readLine();
                }
                fileReader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        this.save();
    }

    public String get(int index) {
        return this.strings.get(index);
    }

    public int indexOf(String string) {
        for (int i = 0; i < this.size(); ++i) {
            if (!this.get(i).equals(string)) continue;
            return i;
        }
        return -1;
    }

    public boolean contains(String string) {
        return this.indexOf(string) > -1;
    }

    public int size() {
        return this.strings.size();
    }

    public void add(String string) {
        this.strings.add(string);
        this.save();
    }

    public boolean remove(String string) {
        int i = this.strings.indexOf(string);
        if (i > -1) {
            this.remove(i);
            return true;
        }
        return false;
    }

    public void remove(int index) {
        this.strings.remove(index);
        this.save();
    }
}

