/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.mctools.gui.element.textured;

import com.fantasticsource.mctools.gui.GUIScreen;
import com.fantasticsource.mctools.gui.element.GUIElement;
import com.fantasticsource.tools.datastructures.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;

public class GUIImage
extends GUIElement {
    protected ResourceLocation texture;
    protected double unscaledWidth;
    protected double unscaledHeight;
    protected double u;
    protected double v;
    protected double uw;
    protected double vh;
    protected Color color;
    protected boolean ignoreMCGUIScale = false;

    public GUIImage(GUIScreen screen, double unscaledWidth, double unscaledHeight, ResourceLocation texture) {
        this(screen, unscaledWidth, unscaledHeight, texture, Color.WHITE);
    }

    public GUIImage(GUIScreen screen, double unscaledWidth, double unscaledHeight, ResourceLocation texture, Color color) {
        this(screen, unscaledWidth, unscaledHeight, texture, color, 0.0, 0.0, 1.0, 1.0);
    }

    public GUIImage(GUIScreen screen, double unscaledWidth, double unscaledHeight, ResourceLocation texture, double u, double v, double uw, double vh) {
        this(screen, unscaledWidth, unscaledHeight, texture, Color.WHITE, u, v, uw, vh);
    }

    public GUIImage(GUIScreen screen, double unscaledWidth, double unscaledHeight, ResourceLocation texture, Color color, double u, double v, double uw, double vh) {
        super(screen, 1.0, 1.0);
        this.unscaledWidth = unscaledWidth;
        this.unscaledHeight = unscaledHeight;
        this.texture = texture;
        this.color = color;
        this.u = u;
        this.v = v;
        this.uw = uw;
        this.vh = vh;
    }

    public GUIImage(GUIScreen screen, double x, double y, double unscaledWidth, double unscaledHeight, ResourceLocation texture) {
        this(screen, x, y, unscaledWidth, unscaledHeight, texture, Color.WHITE);
    }

    public GUIImage(GUIScreen screen, double x, double y, double unscaledWidth, double unscaledHeight, ResourceLocation texture, Color color) {
        this(screen, x, y, unscaledWidth, unscaledHeight, texture, color, 0.0, 0.0, 1.0, 1.0);
    }

    public GUIImage(GUIScreen screen, double x, double y, double unscaledWidth, double unscaledHeight, ResourceLocation texture, double u, double v, double uw, double vh) {
        this(screen, x, y, unscaledWidth, unscaledHeight, texture, Color.WHITE, u, v, uw, vh);
    }

    public GUIImage(GUIScreen screen, double x, double y, double unscaledWidth, double unscaledHeight, ResourceLocation texture, Color color, double u, double v, double uw, double vh) {
        super(screen, x, y, 1.0, 1.0);
        this.unscaledWidth = unscaledWidth;
        this.unscaledHeight = unscaledHeight;
        this.texture = texture;
        this.color = color;
        this.u = u;
        this.v = v;
        this.uw = uw;
        this.vh = vh;
    }

    public GUIImage ignoreMCGUIScale(boolean ignoreMCGUIScale) {
        this.ignoreMCGUIScale = ignoreMCGUIScale;
        this.recalc(0);
        return this;
    }

    @Override
    public GUIImage recalc(int subIndexChanged) {
        this.width = this.unscaledWidth / (double)this.screen.field_146294_l;
        this.height = this.unscaledHeight / (double)this.screen.field_146295_m;
        if (this.ignoreMCGUIScale) {
            int mcScale = new ScaledResolution(Minecraft.func_71410_x()).func_78325_e();
            this.width /= (double)mcScale;
            this.height /= (double)mcScale;
        }
        if (this.parent != null) {
            this.width /= this.parent.absoluteWidth();
            this.height /= this.parent.absoluteHeight();
        }
        this.recalcAndRepositionSubElements(0);
        this.postRecalc();
        return this;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Color getColor() {
        return this.color.copy();
    }

    @Override
    public void draw() {
        GlStateManager.func_179098_w();
        GlStateManager.func_179131_c((float)this.color.rf(), (float)this.color.gf(), (float)this.color.bf(), (float)this.color.af());
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.texture);
        double u2 = this.u + this.uw;
        double v2 = this.v + this.vh;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder builder = tessellator.func_178180_c();
        builder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        builder.func_181662_b(1.0, 0.0, 0.0).func_187315_a(u2, this.v).func_181675_d();
        builder.func_181662_b(0.0, 0.0, 0.0).func_187315_a(this.u, this.v).func_181675_d();
        builder.func_181662_b(0.0, 1.0, 0.0).func_187315_a(this.u, v2).func_181675_d();
        builder.func_181662_b(1.0, 1.0, 0.0).func_187315_a(u2, v2).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.drawChildren();
    }
}

