/*
 * Decompiled with CFR 0.152.
 */
package primetoxinz.coralreef;

import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;
import org.apache.commons.lang3.ArrayUtils;
import primetoxinz.coralreef.BlockReef;
import primetoxinz.coralreef.CoralReef;
import primetoxinz.coralreef.WorldGenReef;
import primetoxinz.coralreef.WorldGenRock;

public class GeneratorReef
implements IWorldGenerator {
    protected static final int OCTAVES = 2;
    protected static final double NOISE_SCALE = 0.03125;
    protected static final NoiseGeneratorOctaves CORAL_REEF_NOISE = new NoiseGeneratorOctaves(new Random(3364L), 2);
    public static final int CHUNK_SIZE = 16;
    private WorldGenerator genReef;
    private WorldGenerator genReefRock;
    private double[] noise = new double[256];

    public GeneratorReef() {
        this.genReef = new WorldGenReef(CoralReef.REEF.func_176223_P().func_177226_a((IProperty)BlockReef.TYPES, (Comparable)Integer.valueOf(0)));
        this.genReefRock = new WorldGenRock(CoralReef.REEF.func_176223_P().func_177226_a((IProperty)BlockReef.TYPES, (Comparable)Integer.valueOf(1)));
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (ArrayUtils.isEmpty((int[])CoralReef.ConfigHandler.dimensions) || ArrayUtils.contains((int[])CoralReef.ConfigHandler.dimensions, (int)world.field_73011_w.getDimension())) {
            this.reef(world, random, chunkX, chunkZ);
            if (random.nextDouble() <= CoralReef.ConfigHandler.rock.chance) {
                this.rock(world, random, chunkX, chunkZ);
            }
        }
    }

    private void rock(World world, Random rand, int chunkX, int chunkZ) {
        int x = chunkX * 16 + 8 + rand.nextInt(16);
        int z = chunkZ * 16 + 8 + rand.nextInt(16);
        BlockPos pos = GeneratorReef.getTop(world, x, z);
        this.genReefRock.func_180709_b(world, rand, pos.func_177984_a());
    }

    private boolean reefFromNoise(int x, int y, int z, Random rand) {
        double d = this.noise[x * 16 + z] / 2.0;
        int seaLevel = 64;
        double ybelow = Math.max(0, seaLevel - y);
        d *= 1.81E-4 * ybelow * ybelow - 0.1705 * ybelow + 4.0;
        d -= rand.nextDouble() * 0.1;
        return (d = Math.pow(d, 5.0)) > 0.005;
    }

    private void reef(World world, Random rand, int chunkX, int chunkZ) {
        this.noise = CORAL_REEF_NOISE.func_76304_a(this.noise, chunkX * 16, 0, chunkZ * 16, 16, 1, 16, 0.03125, 1.0, 0.03125);
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                BlockPos pos = GeneratorReef.getTop(world, chunkX * 16 + x + 8, chunkZ * 16 + z + 8);
                if (!this.reefFromNoise(x, pos.func_177956_o(), z, rand) || !ArrayUtils.isEmpty((Object[])CoralReef.ConfigHandler.biomes) && !ArrayUtils.contains((Object[])CoralReef.ConfigHandler.biomes, (Object)world.func_180494_b(pos).getRegistryName().func_110623_a().toLowerCase())) continue;
                this.genReef.func_180709_b(world, rand, pos);
            }
        }
    }

    public static BlockPos getTop(World world, int x, int z) {
        IBlockState state;
        Chunk chunk = world.func_175726_f(new BlockPos(x, 0, z));
        BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos(world.func_175672_r(new BlockPos(x, 0, z)));
        while (blockPos.func_177956_o() >= 0 && (!(state = chunk.func_177435_g((BlockPos)blockPos)).func_185904_a().func_76230_c() || state.func_185904_a() == Material.field_151588_w || state.func_185904_a() == Material.field_151584_j || state.func_177230_c().isFoliage((IBlockAccess)world, (BlockPos)blockPos))) {
            blockPos.func_185336_p(blockPos.func_177956_o() - 1);
        }
        return blockPos;
    }
}

