/*
 * Decompiled with CFR 0.152.
 */
package cursedflames.bountifulbaubles.entity;

import cursedflames.bountifulbaubles.util.Util;
import elucent.albedo.event.GatherLightsEvent;
import elucent.albedo.lighting.ILightProvider;
import elucent.albedo.lighting.Light;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Optional.Interface(modid="albedo", iface="elucent.albedo.lighting.ILightProvider")
public class EntityFlare
extends EntityArrow
implements ILightProvider {
    protected boolean field_70254_i;
    protected BlockPos tilePos;
    protected Block field_145790_g;
    protected double tileX;
    protected double tileY;
    protected double tileZ;
    protected int field_145791_d;
    protected int field_145792_e;
    protected int field_145789_f;
    protected int field_70252_j = 0;

    public EntityFlare(World world) {
        super(world);
    }

    public EntityFlare(World world, double x, double y, double z) {
        super(world);
        this.func_70107_b(x, y, z);
    }

    public EntityFlare(World world, EntityLivingBase thrower) {
        this(world, thrower.field_70165_t, thrower.field_70163_u + (double)thrower.func_70047_e() - (double)0.1f, thrower.field_70161_v);
        this.field_70250_c = thrower;
    }

    public void func_70186_c(double x, double y, double z, float velocity, float inaccuracy) {
        double f = MathHelper.func_76133_a((double)(x * x + y * y + z * z));
        x /= f;
        y /= f;
        z /= f;
        x += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        y += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        z += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        this.field_70159_w = x *= (double)velocity;
        this.field_70181_x = y *= (double)velocity;
        this.field_70179_y = z *= (double)velocity;
        double f1 = MathHelper.func_76133_a((double)(x * x + z * z));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)x, (double)z) * 57.29577951308232);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)y, (double)f1) * 57.29577951308232);
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
    }

    public void shoot(EntityLivingBase entityThrower, float rotationPitchIn, float rotationYawIn, float pitchOffset, float velocity, float inaccuracy) {
        this.field_70250_c = entityThrower;
        float f = -MathHelper.func_76126_a((float)(rotationYawIn * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(rotationPitchIn * ((float)Math.PI / 180)));
        float f1 = -MathHelper.func_76126_a((float)((rotationPitchIn + pitchOffset) * ((float)Math.PI / 180)));
        float f2 = MathHelper.func_76134_b((float)(rotationYawIn * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(rotationPitchIn * ((float)Math.PI / 180)));
        this.func_70186_c(f, f1, f2, velocity, inaccuracy);
        this.field_70159_w += entityThrower.field_70159_w;
        this.field_70179_y += entityThrower.field_70179_y;
        if (!entityThrower.field_70122_E) {
            this.field_70181_x += entityThrower.field_70181_x;
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
    }

    public void func_70037_a(NBTTagCompound compound) {
        this.field_70254_i = compound.func_74767_n("inGround");
        if (compound.func_74764_b("tilePos")) {
            NBTTagCompound pos = compound.func_74775_l("tilePos");
            this.tilePos = Util.blockPosFromNBT(pos);
        }
        if (compound.func_150297_b("inTile", 8)) {
            this.field_145790_g = Block.func_149684_b((String)compound.func_74779_i("inTile"));
        }
        if (compound.func_186855_b("thrower")) {
            UUID thrower = compound.func_186857_a("thrower");
            this.field_70250_c = this.field_70170_p.func_152378_a(thrower);
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        ResourceLocation resourcelocation;
        compound.func_74757_a("inGround", this.field_70254_i);
        if (this.tilePos != null) {
            NBTTagCompound pos = Util.blockPosToNBT(this.tilePos);
            compound.func_74782_a("tilePos", (NBTBase)pos);
        }
        compound.func_74778_a("inTile", (resourcelocation = (ResourceLocation)Block.field_149771_c.func_177774_c((Object)this.field_145790_g)) == null ? "" : resourcelocation.toString());
        if (this.field_70250_c != null) {
            compound.func_186854_a("thrower", this.field_70250_c.func_110124_au());
        }
    }

    protected float getGravityVelocity() {
        return 0.03f;
    }

    public void func_70071_h_() {
        int particleRate;
        super.func_70030_z();
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70177_z = (float)(MathHelper.func_181159_b((double)this.field_70159_w, (double)this.field_70179_y) * 57.29577951308232);
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)this.field_70181_x, (double)f) * 57.29577951308232);
            this.field_70126_B = this.field_70177_z;
            this.field_70127_C = this.field_70125_A;
        }
        int n = particleRate = this.field_70254_i ? 6 : 2;
        if (this.field_70170_p.field_72995_K && this.field_70170_p.func_82737_E() % (long)particleRate == 1L) {
            Vec3d vel = new Vec3d(0.0, 0.0, -1.0).func_178789_a((float)((double)this.field_70125_A * (Math.PI / 180))).func_178785_b((float)((double)this.field_70177_z * (Math.PI / 180)));
            this.field_70170_p.func_175688_a(EnumParticleTypes.FLAME, this.field_70165_t + vel.field_72450_a * 0.3, this.field_70163_u + vel.field_72448_b * 0.3, this.field_70161_v + vel.field_72449_c * 0.3, vel.field_72450_a * 0.055, vel.field_72448_b * 0.055, vel.field_72449_c * 0.055, new int[0]);
        }
        if (this.field_70173_aa > 12000) {
            this.func_70106_y();
        }
        if (this.field_70254_i && this.tilePos != null) {
            if (this.field_70170_p.func_180495_p(this.tilePos).func_177230_c() == this.field_145790_g) {
                ++this.field_70252_j;
                return;
            }
            this.field_70254_i = false;
            this.field_70159_w *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
            this.field_70181_x *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
            this.field_70179_y *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
        }
        Vec3d vec3d = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        Vec3d vec3d1 = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        RayTraceResult raytraceresult = this.field_70170_p.func_147447_a(vec3d, vec3d1, false, true, false);
        vec3d = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        vec3d1 = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        if (raytraceresult != null) {
            vec3d1 = new Vec3d(raytraceresult.field_72307_f.field_72450_a, raytraceresult.field_72307_f.field_72448_b, raytraceresult.field_72307_f.field_72449_c);
        }
        Entity entity = null;
        List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_186662_g(1.0));
        double d0 = 0.0;
        for (Entity entity1 : list) {
            double d1;
            AxisAlignedBB axisalignedbb;
            RayTraceResult raytraceresult1;
            if (!entity1.func_70067_L() || entity1 == this.field_70250_c && this.field_70173_aa < 5 || (raytraceresult1 = (axisalignedbb = entity1.func_174813_aQ().func_186662_g((double)0.3f)).func_72327_a(vec3d, vec3d1)) == null || !((d1 = vec3d.func_72436_e(raytraceresult1.field_72307_f)) < d0) && d0 != 0.0) continue;
            entity = entity1;
            d0 = d1;
        }
        if (entity != null) {
            raytraceresult = new RayTraceResult(entity);
        }
        if (raytraceresult != null) {
            if (raytraceresult.field_72313_a == RayTraceResult.Type.BLOCK && this.field_70170_p.func_180495_p(raytraceresult.func_178782_a()).func_177230_c() == Blocks.field_150427_aO) {
                this.func_181015_d(raytraceresult.func_178782_a());
            } else if (!ForgeEventFactory.onProjectileImpact((EntityArrow)this, (RayTraceResult)raytraceresult)) {
                this.func_184549_a(raytraceresult);
            }
        }
        this.field_70165_t += this.field_70159_w;
        this.field_70163_u += this.field_70181_x;
        this.field_70161_v += this.field_70179_y;
        float f = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)this.field_70159_w, (double)this.field_70179_y) * 57.29577951308232);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)this.field_70181_x, (double)f) * 57.29577951308232);
        double velMultiplier = 0.995;
        float gravity = this.getGravityVelocity();
        if (this.func_70090_H()) {
            for (int j = 0; j < 4; ++j) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_BUBBLE, this.field_70165_t - this.field_70159_w * 0.25, this.field_70163_u - this.field_70181_x * 0.25, this.field_70161_v - this.field_70179_y * 0.25, this.field_70159_w, this.field_70181_x, this.field_70179_y, new int[0]);
            }
            velMultiplier = 0.8;
        }
        this.field_70159_w *= velMultiplier;
        this.field_70181_x *= velMultiplier;
        this.field_70179_y *= velMultiplier;
        if (!this.func_189652_ae()) {
            this.field_70181_x -= (double)gravity;
        }
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        if (this.field_70254_i) {
            // empty if block
        }
    }

    protected void func_184549_a(RayTraceResult raytraceResultIn) {
        Entity entity = raytraceResultIn.field_72308_g;
        if (entity != null) {
            if (entity instanceof EntityLivingBase) {
                EntityLivingBase entitylivingbase = (EntityLivingBase)entity;
                if (!this.field_70170_p.field_72995_K) {
                    entitylivingbase.func_85034_r(entitylivingbase.func_85035_bI() + 1);
                }
            }
        } else {
            BlockPos blockpos;
            this.tilePos = blockpos = raytraceResultIn.func_178782_a();
            IBlockState iblockstate = this.field_70170_p.func_180495_p(blockpos);
            this.field_145790_g = iblockstate.func_177230_c();
            this.field_70159_w = (float)(raytraceResultIn.field_72307_f.field_72450_a - this.field_70165_t);
            this.field_70181_x = (float)(raytraceResultIn.field_72307_f.field_72448_b - this.field_70163_u);
            this.field_70179_y = (float)(raytraceResultIn.field_72307_f.field_72449_c - this.field_70161_v);
            float f2 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y));
            this.field_70165_t -= this.field_70159_w / (double)f2 * (double)0.05f;
            this.field_70163_u -= this.field_70181_x / (double)f2 * (double)0.05f;
            this.field_70161_v -= this.field_70179_y / (double)f2 * (double)0.05f;
            this.field_70254_i = true;
            if (iblockstate.func_185904_a() != Material.field_151579_a) {
                this.field_145790_g.func_180634_a(this.field_70170_p, blockpos, iblockstate, (Entity)this);
            }
        }
    }

    protected ItemStack func_184550_j() {
        return ItemStack.field_190927_a;
    }

    @SideOnly(value=Side.CLIENT)
    public Light provideLight() {
        return Light.builder().pos((Entity)this).color(0.7f, 0.21f, 0.21f).radius(20.0f).build();
    }

    public void gatherLights(GatherLightsEvent event, Entity context) {
    }
}

