/*
 * Decompiled with CFR 0.152.
 */
package dttraverse.trees;

import com.ferreusveritas.dynamictrees.api.IGenFeature;
import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenConiferTopper;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import dttraverse.DynamicTreesTraverse;
import dttraverse.ModContent;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import prospector.traverse.init.TraverseBlocks;

public final class TreeFir
extends TreeFamily {
    public TreeFir() {
        super(new ResourceLocation("dttraverse", "fir"));
        Block firLog = (Block)TraverseBlocks.blocks.get("fir_log");
        ItemBlock firLeavesItem = new ItemBlock(firLog);
        firLeavesItem.setRegistryName(firLog.getRegistryName());
        GameRegistry.findRegistry(Item.class).register((IForgeRegistryEntry)firLeavesItem);
        IBlockState primLog = firLog.func_176223_P();
        DynamicTreesTraverse.logger.info("FIRLOG:" + firLog + " " + new ItemStack(firLog, 1));
        this.setPrimitiveLog(primLog, new ItemStack(Item.func_150898_a((Block)firLog), 1));
        this.hasConiferVariants = true;
        ModContent.firLeavesProperties.setTree((TreeFamily)this);
    }

    public void createSpecies() {
        this.setCommonSpecies(new SpeciesFir(this));
    }

    public static final class SpeciesFir
    extends Species {
        SpeciesFir(TreeFamily treeFamily) {
            super(treeFamily.getName(), treeFamily, ModContent.firLeavesProperties);
            this.setBasicGrowingParameters(0.3f, 26.0f, 7, 6, 0.9f);
            this.setGrowthLogicKit(TreeRegistry.findGrowthLogicKit((String)"conifer"));
            this.envFactor(BiomeDictionary.Type.HOT, 0.5f);
            this.envFactor(BiomeDictionary.Type.DRY, 0.25f);
            this.envFactor(BiomeDictionary.Type.WET, 0.75f);
            this.generateSeed();
            this.setupStandardSeedDropping();
            this.addGenFeature((IGenFeature)new FeatureGenConiferTopper(this.getLeavesProperties()));
        }

        public boolean isBiomePerfect(Biome biome) {
            return BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.CONIFEROUS);
        }
    }
}

