/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.traits.abilities;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import xzeroair.trinkets.races.dwarf.config.DwarfConfig;
import xzeroair.trinkets.traits.abilities.Ability;
import xzeroair.trinkets.traits.abilities.interfaces.IMiningAbility;
import xzeroair.trinkets.util.TrinketsConfig;
import xzeroair.trinkets.util.config.ConfigHelper;
import xzeroair.trinkets.util.helpers.BlockHelperUtil;

public class AbilitySkilledMiner
extends Ability
implements IMiningAbility {
    public static final DwarfConfig serverConfig = TrinketsConfig.SERVER.races.dwarf;

    public AbilitySkilledMiner() {
        super("skilled_miner");
    }

    @Override
    public float breakingBlock(EntityLivingBase entity, IBlockState state, BlockPos pos, float originalSpeed, float newSpeed) {
        if (AbilitySkilledMiner.serverConfig.static_mining) {
            ItemStack heldItemStack = entity.func_184614_ca();
            Item heldItem = heldItemStack.func_77973_b();
            int toolLevel = heldItem.getHarvestLevel(heldItemStack, "pickaxe", null, state);
            int level = state.func_177230_c().getHarvestLevel(state);
            float hardness = state.func_185887_b(entity.field_70170_p, pos);
            if (!heldItem.getToolClasses(heldItemStack).isEmpty() && heldItem.getToolClasses(heldItemStack).contains("pickaxe") && (toolLevel >= level || toolLevel == level - 1)) {
                newSpeed = hardness * 5.0f;
            }
        }
        return newSpeed;
    }

    @Override
    public int brokeBlock(EntityLivingBase entity, World world, IBlockState state, BlockPos pos, int expToDrop) {
        boolean isClient = world.field_72995_K;
        ItemStack heldItemStack = entity.func_184614_ca();
        Block block = state.func_177230_c();
        if (!heldItemStack.func_190926_b() && !block.getHarvestTool(state).contentEquals("pickaxe")) {
            return expToDrop;
        }
        ItemStack toolUsed = heldItemStack.func_77946_l();
        int fortuneLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)heldItemStack);
        boolean silkTouching = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)toolUsed) > 0;
        try {
            if (AbilitySkilledMiner.serverConfig.fortune && !silkTouching) {
                Enchantment fortune = Enchantments.field_185308_t;
                int fortuneMaxLevel = fortune.func_77325_b();
                if (fortuneLevel > 0) {
                    if (AbilitySkilledMiner.serverConfig.fortune_mix) {
                        String[] nbttaglist = toolUsed.func_77986_q();
                        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                            NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
                            Enchantment enchantment = Enchantment.func_185262_c((int)nbttagcompound.func_74765_d("id"));
                            if (enchantment != fortune) continue;
                            nbttagcompound.func_74777_a("lvl", (short)((byte)fortuneLevel + fortuneMaxLevel));
                        }
                    }
                } else {
                    toolUsed.func_77966_a(fortune, fortuneMaxLevel);
                }
            }
        }
        catch (Exception fortune) {
            // empty catch block
        }
        Item toolItem = toolUsed.func_77973_b();
        if (!toolItem.getToolClasses(toolUsed).isEmpty() && toolItem.getToolClasses(toolUsed).contains("pickaxe")) {
            int tempExp = 0;
            if (!silkTouching && !isClient) {
                ConfigHelper.ConfigObject object;
                if (AbilitySkilledMiner.serverConfig.BLOCKS.bonus_exp) {
                    for (String s : AbilitySkilledMiner.serverConfig.BLOCKS.xPBlocks) {
                        object = new ConfigHelper.ConfigObject(s);
                        if (!object.doesBlockMatchEntry(state)) continue;
                        int bonusExp = AbilitySkilledMiner.serverConfig.BLOCKS.bonus_exp_max;
                        int min = AbilitySkilledMiner.serverConfig.BLOCKS.bonus_exp_min;
                        int rXP = bonusExp < 1 ? min : this.random.nextInt(bonusExp);
                        tempExp += Math.max(min, rXP);
                        break;
                    }
                }
                if (AbilitySkilledMiner.serverConfig.BLOCKS.minXpBlocks && tempExp < 1) {
                    for (String s : AbilitySkilledMiner.serverConfig.BLOCKS.MinBlocks) {
                        object = new ConfigHelper.ConfigObject(s);
                        if (!object.doesBlockMatchEntry(state)) continue;
                        tempExp = 1;
                        break;
                    }
                }
            }
            int droppedExp = tempExp;
            if (AbilitySkilledMiner.serverConfig.skilled_miner && entity instanceof EntityPlayer && BlockHelperUtil.canBreakBlock(toolUsed, world, (EntityPlayer)entity, pos, pos, 1)) {
                BlockHelperUtil.breakBlock((EntityPlayer)entity, toolUsed, world, state, pos, pos, false, 1, xp -> {
                    if (xp < -1) {
                        return droppedExp;
                    }
                    return xp + droppedExp;
                });
                return 0;
            }
            return expToDrop + droppedExp;
        }
        return expToDrop;
    }
}

