/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.traits.abilities;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.Arrays;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import xzeroair.trinkets.api.TrinketHelper;
import xzeroair.trinkets.capabilities.Capabilities;
import xzeroair.trinkets.capabilities.magic.MagicStats;
import xzeroair.trinkets.client.keybinds.ModKeyBindings;
import xzeroair.trinkets.init.ModItems;
import xzeroair.trinkets.items.trinkets.TrinketPolarized;
import xzeroair.trinkets.traits.AbilityHandler;
import xzeroair.trinkets.traits.abilities.Ability;
import xzeroair.trinkets.traits.abilities.interfaces.IHeldAbility;
import xzeroair.trinkets.traits.abilities.interfaces.IKeyBindInterface;
import xzeroair.trinkets.traits.abilities.interfaces.ITickableAbility;
import xzeroair.trinkets.traits.abilities.interfaces.ITickableInventoryAbility;
import xzeroair.trinkets.traits.abilities.interfaces.IToggleAbility;
import xzeroair.trinkets.util.TrinketsConfig;
import xzeroair.trinkets.util.config.trinkets.ConfigPolarizedStone;
import xzeroair.trinkets.util.handlers.Counter;
import xzeroair.trinkets.util.helpers.TranslationHelper;

public class AbilityRepel
extends Ability
implements ITickableAbility,
IHeldAbility,
ITickableInventoryAbility,
IToggleAbility,
IKeyBindInterface {
    private static final ConfigPolarizedStone serverConfig = TrinketsConfig.SERVER.Items.POLARIZED_STONE;

    public AbilityRepel() {
        super("repel");
    }

    @Override
    public void tickAbility(EntityLivingBase entity) {
        if (this.abilityEnabled()) {
            this.blockArrows(entity);
        }
    }

    @Override
    public void onUpdate(ItemStack stack, World world, Entity entity, int itemSlot, boolean inHand) {
        if (stack.func_77973_b() instanceof TrinketPolarized) {
            Capabilities.getTrinketProperties(stack, prop -> this.toggleAbility(prop.altAbility()));
        }
    }

    public void blockArrows(EntityLivingBase entity) {
        MagicStats magic;
        Predicate filter;
        boolean flag;
        if (AbilityRepel.serverConfig.exhaustion && (flag = (filter = Predicates.and((Predicate)EntitySelectors.field_188444_d, (Predicate)EntitySelectors.field_94557_a)).apply((Object)entity)) && (magic = Capabilities.getMagicStats((Entity)entity)) != null) {
            float exhaustRate = AbilityRepel.serverConfig.exhaust_rate;
            this.tickHandler.addCounter("repel.ticks", AbilityRepel.serverConfig.exhaust_ticks, false, true, false);
            Counter counter = this.tickHandler.getCounter("repel.ticks");
            if (exhaustRate <= magic.getMana()) {
                if (counter != null && counter.Tick()) {
                    magic.spendMana(exhaustRate);
                }
            } else {
                return;
            }
        }
        try {
            AxisAlignedBB bBox = entity.func_174813_aQ();
            List<String> cfg = Arrays.asList(AbilityRepel.serverConfig.repelledEntities);
            Predicate Targets = Predicates.and((Predicate[])new Predicate[]{EntitySelectors.field_188444_d, EntitySelectors.field_94557_a, ent -> ent != null && !(ent instanceof EntityPlayer) && EntityRegistry.getEntry(ent.getClass()) != null && EntityRegistry.getEntry(ent.getClass()).getRegistryName() != null && cfg.contains(EntityRegistry.getEntry(ent.getClass()).getRegistryName().toString())});
            List entityList = entity.field_70170_p.func_175647_a(Entity.class, bBox.func_186662_g(AbilityRepel.serverConfig.repelRange), Targets);
            for (Entity repelledEntity : entityList) {
                Vec3d playerVec3 = entity.func_70040_Z();
                repelledEntity.field_70159_w = playerVec3.field_72450_a * 0.3;
                repelledEntity.field_70181_x = playerVec3.field_72448_b * 0.3;
                repelledEntity.field_70179_y = playerVec3.field_72449_c * 0.3;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean abilityEnabled() {
        return this.enabled;
    }

    @Override
    public IToggleAbility toggleAbility(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @Override
    public IToggleAbility toggleAbility(int value) {
        this.value = value;
        return this;
    }

    @Override
    public boolean onKeyPress(Entity entity, boolean Aux) {
        if (Aux) {
            boolean enabled = this.abilityEnabled();
            boolean client = entity.field_70170_p.field_72995_K;
            this.toggleAbility(!enabled);
            if (client && entity instanceof EntityPlayer) {
                TranslationHelper helper = TranslationHelper.INSTANCE;
                ItemStack s = new ItemStack(ModItems.trinkets.TrinketPolarized);
                String repelMode = new TextComponentTranslation(s.func_77977_a() + ".repelmode", new Object[0]).func_150254_d();
                TranslationHelper.OptionEntry key = new TranslationHelper.OptionEntry("repeltoggle", AbilityRepel.serverConfig.repell, helper.toggleCheckTranslation(!enabled));
                ((EntityPlayer)entity).func_146105_b((ITextComponent)new TextComponentString(helper.formatAddVariables(repelMode, key)), true);
            }
            Capabilities.getEntityProperties(entity, prop -> {
                ItemStack stack;
                TrinketHelper.SlotInformation info;
                AbilityHandler.AbilityHolder holder = prop.getAbilityHandler().getAbilityHolder(this.getRegistryName().toString());
                TrinketHelper.SlotInformation slotInformation = info = holder != null ? holder.getInfo() : null;
                if (info != null && entity instanceof EntityLivingBase && (stack = info.getStackFromHandler((EntityLivingBase)entity)).func_77973_b() instanceof TrinketPolarized) {
                    Capabilities.getTrinketProperties(stack, cap -> {
                        cap.toggleAltAbility(this.abilityEnabled());
                        cap.sendInformationToPlayer((EntityLivingBase)((EntityPlayer)entity), (EntityLivingBase)((EntityPlayer)entity));
                    });
                }
            });
        }
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getKey() {
        return ModKeyBindings.POLARIZED_STONE_ABILITY.getDisplayName();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getAuxKey() {
        return ModKeyBindings.AUX_KEY.getDisplayName();
    }

    @Override
    public NBTTagCompound saveStorage(NBTTagCompound compound) {
        compound.func_74757_a("enabled", this.enabled);
        return compound;
    }

    @Override
    public void loadStorage(NBTTagCompound compound) {
        if (compound.func_74764_b("enabled")) {
            this.enabled = compound.func_74767_n("enabled");
        }
    }
}

