/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.traits.abilities;

import java.util.Map;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import xzeroair.trinkets.traits.abilities.Ability;
import xzeroair.trinkets.traits.abilities.interfaces.IAttackAbility;
import xzeroair.trinkets.traits.abilities.interfaces.IPotionAbility;
import xzeroair.trinkets.traits.abilities.interfaces.ITickableAbility;
import xzeroair.trinkets.util.TrinketsConfig;
import xzeroair.trinkets.util.config.trinkets.ConfigPoisonStone;

public class AbilityPoisonAffinity
extends Ability
implements IAttackAbility,
IPotionAbility,
ITickableAbility {
    private final ConfigPoisonStone serverConfig;

    public AbilityPoisonAffinity() {
        super("poison_affinity");
        this.serverConfig = TrinketsConfig.SERVER.Items.POISON_STONE;
    }

    @Override
    public void tickAbility(EntityLivingBase entity) {
        Map potMap = entity.func_193076_bZ();
        if (!potMap.isEmpty()) {
            for (String immunities : TrinketsConfig.SERVER.Items.POISON_STONE.immunities) {
                Potion effect = Potion.func_180142_b((String)immunities);
                if (effect == null) continue;
                entity.func_184589_d(effect);
            }
        }
    }

    @Override
    public boolean attacked(EntityLivingBase attacked, DamageSource source, float dmg, boolean cancel) {
        if (source.field_76373_n.contentEquals("poison") || source.field_76373_n.contentEquals("xat.poison")) {
            return true;
        }
        return cancel;
    }

    @Override
    public float hurtEntity(EntityLivingBase target, DamageSource source, float dmg) {
        if (!(!this.serverConfig.poison || target.func_70644_a(MobEffects.field_76436_u) || source.func_82725_o() || source.func_76347_k() || source.func_94541_c() || this.serverConfig.poison_chance != 0 && (this.serverConfig.poison_chance <= 0 || this.random.nextInt(this.serverConfig.poison_chance) != 0))) {
            target.func_70690_d(new PotionEffect(MobEffects.field_76436_u, this.serverConfig.poison_duration, 0, false, true));
        }
        if (!target.func_70644_a(MobEffects.field_76436_u) || source.func_82725_o() || source.func_76347_k() || source.func_94541_c()) {
            return dmg;
        }
        float damage = dmg;
        if (this.serverConfig.bonus_damage) {
            float multipliedDamage = damage * this.serverConfig.bonus_damage_amount;
            return multipliedDamage;
        }
        return damage;
    }

    @Override
    public boolean potionApplied(EntityLivingBase entity, PotionEffect effect, boolean cancel) {
        String e = effect.func_188419_a().getRegistryName().toString();
        for (String immunity : TrinketsConfig.SERVER.Items.POISON_STONE.immunities) {
            Potion pot = Potion.func_180142_b((String)immunity);
            if (pot == null || !e.contentEquals(pot.getRegistryName().toString())) continue;
            return true;
        }
        return cancel;
    }
}

