/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.traits.abilities;

import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.BlockPos;
import xzeroair.trinkets.capabilities.Capabilities;
import xzeroair.trinkets.capabilities.magic.MagicStats;
import xzeroair.trinkets.traits.abilities.Ability;
import xzeroair.trinkets.traits.abilities.interfaces.IMiningAbility;
import xzeroair.trinkets.traits.abilities.interfaces.IPotionAbility;
import xzeroair.trinkets.traits.abilities.interfaces.ITickableAbility;
import xzeroair.trinkets.util.handlers.Counter;

public class AbilityFlying
extends Ability
implements ITickableAbility,
IPotionAbility,
IMiningAbility {
    protected boolean flightEnabled = false;
    protected boolean speedModified = false;
    protected float speed = 0.0f;
    protected float cost = 0.0f;

    public AbilityFlying() {
        super("creative_flight");
    }

    public AbilityFlying setFlightEnabled(boolean enabled) {
        this.flightEnabled = enabled;
        return this;
    }

    public AbilityFlying setSpeedEnabled(boolean enabled) {
        this.speedModified = enabled;
        return this;
    }

    public AbilityFlying setFlightSpeed(float speed) {
        this.speed = speed;
        return this;
    }

    public AbilityFlying setFlightCost(float cost) {
        this.cost = cost;
        return this;
    }

    @Override
    public void tickAbility(EntityLivingBase entity) {
        boolean flag = Capabilities.getEntityProperties((Entity)entity, true, (prop, canFly) -> prop.getRaceHandler().canFly());
        if (this.flightEnabled && flag) {
            this.addFlyingAbility(entity);
        } else {
            this.removeFlyingAbility(entity);
        }
    }

    @Override
    public boolean potionApplied(EntityLivingBase entity, PotionEffect effect, boolean cancel) {
        if (effect.func_188419_a().getRegistryName().toString().contentEquals("minecraft:levitation")) {
            return true;
        }
        return cancel;
    }

    @Override
    public float breakingBlock(EntityLivingBase entity, IBlockState state, BlockPos pos, float originalSpeed, float newSpeed) {
        if (!entity.func_70055_a(Material.field_151586_h)) {
            float speed = originalSpeed;
            if (!entity.field_70122_E) {
                speed *= 5.0f;
            }
            if (newSpeed < speed) {
                return speed;
            }
        }
        return newSpeed;
    }

    protected void setFlyingSpeed(EntityLivingBase entity, float flightSpeed) {
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            if (!this.isCreativePlayer((Entity)player)) {
                if (this.speedModified && player.field_70170_p.field_72995_K && player.field_71075_bZ.func_75093_a() != flightSpeed && flightSpeed > 0.0f && flightSpeed != Float.NaN) {
                    player.field_71075_bZ.func_75092_a(flightSpeed);
                    player.func_71016_p();
                }
            } else if (player.field_70170_p.field_72995_K && player.field_71075_bZ.func_75093_a() == flightSpeed) {
                player.field_71075_bZ.func_75092_a(0.05f);
                player.func_71016_p();
            }
        }
    }

    protected void addFlyingAbility(EntityLivingBase entity) {
        EntityPlayer player;
        if (entity instanceof EntityPlayer && !this.isCreativePlayer((Entity)(player = (EntityPlayer)entity))) {
            MagicStats magic = Capabilities.getMagicStats((Entity)entity);
            if (this.cost > 0.0f && magic != null) {
                boolean flying = player.field_71075_bZ.field_75100_b;
                float mp = magic.getMana();
                if (mp >= this.cost) {
                    if (!player.field_71075_bZ.field_75101_c) {
                        player.field_71075_bZ.field_75101_c = true;
                        this.setFlyingSpeed(entity, this.speed);
                        if (player instanceof EntityPlayerMP) {
                            player.func_71016_p();
                        }
                    }
                } else if (flying) {
                    this.removeFlyingAbility((EntityLivingBase)player);
                }
                if (player.field_71075_bZ.field_75100_b) {
                    this.setFlyingSpeed(entity, this.speed);
                    player.field_70143_R = 0.0f;
                    Counter counter = this.tickHandler.getCounter("fly_timer", 20, true, true, true, true);
                    if (counter != null && !player.func_184218_aH() && counter.Tick() && !magic.spendMana(this.cost)) {
                        this.removeFlyingAbility((EntityLivingBase)player);
                    }
                }
            } else {
                if (!player.field_71075_bZ.field_75101_c) {
                    player.field_71075_bZ.field_75101_c = true;
                    if (player instanceof EntityPlayerMP) {
                        player.func_71016_p();
                    }
                }
                if (player.field_71075_bZ.field_75100_b) {
                    player.field_70143_R = 0.0f;
                }
            }
        }
    }

    protected void removeFlyingAbility(EntityLivingBase entity) {
        EntityPlayer player;
        if (entity instanceof EntityPlayer && !this.isCreativePlayer((Entity)(player = (EntityPlayer)entity)) && player.field_71075_bZ.field_75101_c) {
            player.field_71075_bZ.field_75101_c = false;
            player.field_71075_bZ.field_75100_b = false;
            if (player instanceof EntityPlayerMP) {
                player.func_71016_p();
            }
            if (player.field_70170_p.field_72995_K && player.field_71075_bZ.func_75093_a() != 0.05f) {
                player.field_71075_bZ.func_75092_a(0.05f);
                player.func_71016_p();
            }
            player.field_70143_R = 0.0f;
        }
    }

    @Override
    public void onAbilityAdded(EntityLivingBase entity) {
        this.addFlyingAbility(entity);
    }

    @Override
    public void onAbilityRemoved(EntityLivingBase entity) {
        this.removeFlyingAbility(entity);
        this.tickHandler.removeCounter("fly_timer");
    }
}

