/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.traits.abilities;

import java.util.List;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import xzeroair.trinkets.api.TrinketHelper;
import xzeroair.trinkets.capabilities.Capabilities;
import xzeroair.trinkets.capabilities.Vip.VipStatus;
import xzeroair.trinkets.capabilities.magic.MagicStats;
import xzeroair.trinkets.client.keybinds.ModKeyBindings;
import xzeroair.trinkets.init.ModItems;
import xzeroair.trinkets.init.TrinketsDamageSource;
import xzeroair.trinkets.traits.abilities.Ability;
import xzeroair.trinkets.traits.abilities.interfaces.IAttackAbility;
import xzeroair.trinkets.traits.abilities.interfaces.IKeyBindInterface;
import xzeroair.trinkets.traits.abilities.interfaces.IPotionAbility;
import xzeroair.trinkets.traits.abilities.interfaces.ITickableAbility;
import xzeroair.trinkets.util.Reference;
import xzeroair.trinkets.util.TrinketsConfig;
import xzeroair.trinkets.util.compat.lycanitesmobs.LycanitesCompat;
import xzeroair.trinkets.util.config.trinkets.ConfigEnderCrown;
import xzeroair.trinkets.util.handlers.Counter;
import xzeroair.trinkets.util.helpers.StringUtils;

public class AbilityEnderQueen
extends Ability
implements ITickableAbility,
IPotionAbility,
IAttackAbility,
IKeyBindInterface {
    protected static final ConfigEnderCrown serverConfig = TrinketsConfig.SERVER.Items.ENDER_CROWN;

    public AbilityEnderQueen() {
        super("ender_queen");
    }

    @Override
    public void tickAbility(EntityLivingBase entity) {
        Counter counter;
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        LycanitesCompat.removeInstability(entity);
        if (AbilityEnderQueen.serverConfig.water_hurts && (counter = this.tickHandler.getCounter("water_hurt", 20, true, true, true, true)).Tick() && (entity.func_70090_H() || entity.func_70026_G())) {
            MagicStats magic = Capabilities.getMagicStats((Entity)entity);
            if (magic != null && magic.spendMana(5.0f)) {
                magic.setManaRegenTimeout(TrinketsConfig.SERVER.mana.mana_regen_timeout * 2);
            } else if (TrinketHelper.AccessoryCheck(entity, ModItems.trinkets.TrinketDragonsEye)) {
                entity.func_70097_a(TrinketsDamageSource.water.func_76348_h().func_82726_p(), 4.0f);
            } else {
                entity.func_70097_a(TrinketsDamageSource.water.func_76348_h().func_82726_p(), 2.0f);
            }
        }
    }

    @Override
    public boolean potionApplied(EntityLivingBase entity, PotionEffect effect, boolean cancel) {
        String e = effect.func_188419_a().getRegistryName().toString();
        Potion instability = LycanitesCompat.getPotionEffectByName("instability");
        if (instability != null && e.contentEquals(instability.getRegistryName().toString())) {
            return true;
        }
        return cancel;
    }

    @Override
    public boolean attacked(EntityLivingBase attacked, DamageSource source, float dmg, boolean cancel) {
        boolean client = attacked.func_130014_f_().field_72995_K;
        Entity attacker = source.func_76346_g();
        if (attacker instanceof EntityLivingBase && attacker != attacked && dmg > 0.0f) {
            int chance;
            int chanceNum;
            if ((AbilityEnderQueen.serverConfig.dmgChance || AbilityEnderQueen.serverConfig.spawnChance) && (chanceNum = AbilityEnderQueen.serverConfig.chance) > 0 && (chance = this.random.nextInt(chanceNum)) == 0) {
                String quote;
                VipStatus vip;
                String string = "The void protects me!";
                String string2 = "Go, my loyal subject!";
                if (TrinketsConfig.SERVER.misc.retrieveVIP && (vip = Capabilities.getVipStatus((Entity)attacked)) != null && !(quote = vip.getRandomQuote()).isEmpty()) {
                    string = quote;
                }
                if (AbilityEnderQueen.serverConfig.spawnChance) {
                    if (client) {
                        StringUtils.sendMessageToPlayer((Entity)attacked, TextFormatting.BOLD + "" + TextFormatting.GOLD + "Go, my loyal subject!", false);
                    }
                    if (!client) {
                        try {
                            EntityEnderman knight = new EntityEnderman(attacked.func_130014_f_());
                            double x = attacked.func_180425_c().func_177958_n();
                            double y = attacked.func_180425_c().func_177956_o();
                            double z = attacked.func_180425_c().func_177952_p();
                            knight.func_70107_b(x, y, z);
                            knight.getEntityData().func_74757_a("xat:summoned", true);
                            knight.func_98053_h(false);
                            attacked.func_130014_f_().func_72838_d((Entity)knight);
                            knight.func_70624_b((EntityLivingBase)attacker);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                if (AbilityEnderQueen.serverConfig.dmgChance) {
                    cancel = true;
                    if (client) {
                        StringUtils.sendMessageToPlayer((Entity)attacked, TextFormatting.BOLD + "" + TextFormatting.GOLD + string, false);
                    }
                }
            }
            if (AbilityEnderQueen.serverConfig.teleportOnHurt && source instanceof EntityDamageSourceIndirect && (chanceNum = AbilityEnderQueen.serverConfig.teleportChance) > 0 && (chance = this.random.nextInt(chanceNum)) == 0) {
                boolean isBoss = source.func_76346_g() != null && !source.func_76346_g().func_184222_aU();
                MagicStats magic = Capabilities.getMagicStats((Entity)attacked);
                if (!isBoss && !attacked.func_184585_cz() && magic != null && magic.getMana() >= magic.getMaxMana() * 0.5f) {
                    for (int i = 0; i < 32; ++i) {
                        if (!this.teleportRandomly(attacked) || !magic.spendMana(magic.getMaxMana() * 0.5f)) continue;
                        cancel = true;
                        break;
                    }
                }
            }
        }
        return cancel;
    }

    @Override
    public void targetedByEnemy(EntityLivingBase enemy) {
        EntityLivingBase target;
        if (!AbilityEnderQueen.serverConfig.attackBack && enemy instanceof EntityEnderman && enemy instanceof EntityLiving && (target = ((EntityLiving)enemy).func_70638_az()) != null) {
            ((EntityLiving)enemy).func_70624_b(null);
        }
    }

    @Override
    public int killedEntityExpDrop(EntityLivingBase target, int originalExp, int droppedExp) {
        if (!AbilityEnderQueen.serverConfig.expDrop && target instanceof EntityEnderman) {
            return 0;
        }
        return droppedExp;
    }

    @Override
    public void killedEntityItemDrops(EntityLivingBase target, DamageSource source, int lootingLevel, List<EntityItem> drops) {
        if (!AbilityEnderQueen.serverConfig.itemDrop && target instanceof EntityEnderman && !drops.isEmpty()) {
            drops.clear();
        }
    }

    @Override
    public float damageEntity(EntityLivingBase target, DamageSource source, float dmg) {
        if (target instanceof EntityEnderman && dmg > 0.0f) {
            try {
                EntityEnderman enderman = (EntityEnderman)target;
                NBTTagCompound data = enderman.getEntityData();
                data.func_74757_a("xat:summoned", true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return dmg;
    }

    protected boolean teleportRandomly(EntityLivingBase entity) {
        double d0 = entity.field_70165_t + (Reference.random.nextDouble() - 0.5) * 32.0;
        double d1 = entity.field_70163_u + (double)(Reference.random.nextInt(16) - 8);
        double d2 = entity.field_70161_v + (Reference.random.nextDouble() - 0.5) * 32.0;
        boolean teleport = this.teleportTo(entity, d0, d1, d2);
        return teleport;
    }

    private boolean teleportTo(EntityLivingBase entity, double x, double y, double z) {
        EnderTeleportEvent event = new EnderTeleportEvent(entity, x, y, z, 0.0f);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return false;
        }
        if (entity instanceof EntityPlayer) {
            if (entity instanceof EntityPlayerMP) {
                if (entity.func_184218_aH()) {
                    entity.func_184210_p();
                }
                if (entity.func_184595_k(x, y, z)) {
                    if (entity.field_70143_R > 0.0f) {
                        entity.field_70143_R = 0.0f;
                    }
                    entity.field_70142_S = entity.field_70165_t;
                    entity.field_70137_T = entity.field_70163_u;
                    entity.field_70136_U = entity.field_70161_v;
                    entity.field_70170_p.func_184148_a(null, x, y, z, SoundEvents.field_187534_aX, SoundCategory.PLAYERS, 1.0f, 1.0f);
                    return true;
                }
            }
            return false;
        }
        boolean flag = this.attemptTeleport(entity, x, y, z);
        if (flag) {
            entity.field_70170_p.func_184148_a(null, entity.field_70169_q, entity.field_70167_r, entity.field_70166_s, SoundEvents.field_187534_aX, entity.func_184176_by(), 1.0f, 1.0f);
            entity.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
        }
        return flag;
    }

    protected boolean teleportToEntity(EntityLivingBase entity, Entity target) {
        Vec3d vec3d = new Vec3d(entity.field_70165_t - target.field_70165_t, entity.func_174813_aQ().field_72338_b + (double)(entity.field_70131_O / 2.0f) - target.field_70163_u + (double)target.func_70047_e(), entity.field_70161_v - target.field_70161_v);
        vec3d = vec3d.func_72432_b();
        double d0 = 16.0;
        double d1 = entity.field_70165_t + (Reference.random.nextDouble() - 0.5) * 8.0 - vec3d.field_72450_a * 16.0;
        double d2 = entity.field_70163_u + (double)(Reference.random.nextInt(16) - 8) - vec3d.field_72448_b * 16.0;
        double d3 = entity.field_70161_v + (Reference.random.nextDouble() - 0.5) * 8.0 - vec3d.field_72449_c * 16.0;
        return this.teleportTo(entity, d1, d2, d3);
    }

    protected boolean attemptTeleport(EntityLivingBase entity, double x, double y, double z) {
        double d0 = entity.field_70165_t;
        double d1 = entity.field_70163_u;
        double d2 = entity.field_70161_v;
        entity.field_70165_t = x;
        entity.field_70163_u = y;
        entity.field_70161_v = z;
        boolean flag = false;
        BlockPos blockpos = new BlockPos((Entity)entity);
        World world = entity.field_70170_p;
        Random random = this.random;
        if (world.func_175667_e(blockpos)) {
            boolean flag1 = false;
            while (!flag1 && blockpos.func_177956_o() > 0) {
                BlockPos blockpos1 = blockpos.func_177977_b();
                IBlockState iblockstate = world.func_180495_p(blockpos1);
                if (iblockstate.func_185904_a().func_76230_c()) {
                    flag1 = true;
                    continue;
                }
                entity.field_70163_u -= 1.0;
                blockpos = blockpos1;
            }
            if (flag1) {
                entity.func_70634_a(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
                if (world.func_184144_a((Entity)entity, entity.func_174813_aQ()).isEmpty() && !world.func_72953_d(entity.func_174813_aQ())) {
                    flag = true;
                }
            }
        }
        if (!flag) {
            entity.func_70634_a(d0, d1, d2);
            return false;
        }
        int i = 128;
        for (int j = 0; j < 128; ++j) {
            double d6 = (double)j / 127.0;
            float f = (random.nextFloat() - 0.5f) * 0.2f;
            float f1 = (random.nextFloat() - 0.5f) * 0.2f;
            float f2 = (random.nextFloat() - 0.5f) * 0.2f;
            double d3 = d0 + (entity.field_70165_t - d0) * d6 + (random.nextDouble() - 0.5) * (double)entity.field_70130_N * 2.0;
            double d4 = d1 + (entity.field_70163_u - d1) * d6 + random.nextDouble() * (double)entity.field_70131_O;
            double d5 = d2 + (entity.field_70161_v - d2) * d6 + (random.nextDouble() - 0.5) * (double)entity.field_70130_N * 2.0;
            world.func_175688_a(EnumParticleTypes.PORTAL, d3, d4, d5, (double)f, (double)f1, (double)f2, new int[0]);
        }
        if (entity instanceof EntityCreature) {
            ((EntityCreature)entity).func_70661_as().func_75499_g();
        }
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getKey() {
        return ModKeyBindings.RACE_ABILITY.getDisplayName();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getAuxKey() {
        return ModKeyBindings.AUX_KEY.getDisplayName();
    }

    @Override
    public boolean onKeyPress(Entity entity, boolean Aux) {
        World world = entity.func_130014_f_();
        return true;
    }
}

