/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.proxy;

import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.IThreadListener;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import xzeroair.trinkets.client.gui.TrinketGui;
import xzeroair.trinkets.client.gui.entityPropertiesGui.GuiAttributesScreen;
import xzeroair.trinkets.client.gui.entityPropertiesGui.GuiEntityProperties;
import xzeroair.trinkets.client.gui.entityPropertiesGui.GuiRaceSelectionScreen;
import xzeroair.trinkets.client.gui.hud.mana.ManaHud;
import xzeroair.trinkets.client.keybinds.ModKeyBindings;
import xzeroair.trinkets.client.particles.ParticleFireBreath;
import xzeroair.trinkets.client.particles.ParticleLightning;
import xzeroair.trinkets.client.particles.ParticleLightningOrb;
import xzeroair.trinkets.client.renderLayers.TrinketsRenderLayer;
import xzeroair.trinkets.proxy.CommonProxy;
import xzeroair.trinkets.util.registry.EventRegistry;

public class ClientProxy
extends CommonProxy {
    @Override
    public Side getSide() {
        return Side.CLIENT;
    }

    @Override
    public void preInit(FMLPreInitializationEvent e) {
        ModKeyBindings.init();
        super.preInit(e);
        EventRegistry.clientPreInit();
    }

    @Override
    public void init(FMLInitializationEvent e) {
        Map skinMap = Minecraft.func_71410_x().func_175598_ae().getSkinMap();
        RenderPlayer render = (RenderPlayer)skinMap.get("default");
        render.func_177094_a((LayerRenderer)new TrinketsRenderLayer(false, render));
        render = (RenderPlayer)skinMap.get("slim");
        render.func_177094_a((LayerRenderer)new TrinketsRenderLayer(true, render));
        super.init(e);
        EventRegistry.clientInit();
    }

    @Override
    public void postInit(FMLPostInitializationEvent e) {
        super.postInit(e);
        EventRegistry.clientPostInit();
    }

    @Override
    public void spawnParticle(int effectID, World world, double x, double y, double z, double motX, double motY, double motZ, int color, float alpha) {
        ParticleFireBreath effect = null;
        if (effectID == 3) {
            effect = new ParticleFireBreath(world, x, y, z, 0.0, 0.0, 0.0, color, alpha);
            effect.func_70536_a((int)alpha);
        }
        if (effect != null) {
            Minecraft.func_71410_x().field_71452_i.func_78873_a(effect);
        }
    }

    @Override
    public void renderEffect(int effectID, World world, double x, double y, double z, double x2, double y2, double z2, int color, float alpha, float intensity) {
        Object effect = null;
        Minecraft mc = Minecraft.func_71410_x();
        if (effectID == 1) {
            effect = new ParticleLightning(world, x, y, z, x2, y2, z2, color, alpha, false, intensity);
            mc.field_71439_g.field_70170_p.func_184134_a(x, y, z, SoundEvents.field_187752_dd, SoundCategory.WEATHER, 0.2f, 0.6f, true);
        } else if (effectID == 2) {
            effect = new ParticleLightningOrb(world, x, y, z, x2, y2, z2, color, alpha, false, intensity);
            mc.field_71439_g.field_70170_p.func_184134_a(x, y, z, SoundEvents.field_187752_dd, SoundCategory.WEATHER, 0.2f, 0.6f, true);
        } else if (effectID == 3) {
            world.func_175688_a(EnumParticleTypes.SWEEP_ATTACK, x, y, z, 0.0, 0.0, 0.0, new int[0]);
        } else if (effectID == 4) {
            effect = new ParticleFireBreath(world, x, y, z, 0.0, 0.0, 0.0, color, alpha);
        } else if (effectID == 5) {
            world.func_175688_a(EnumParticleTypes.EXPLOSION_HUGE, x, y, z, 0.0, 0.0, 0.0, new int[0]);
            mc.field_71439_g.field_70170_p.func_184134_a(x, y, z, SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 4.0f, (1.0f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.2f) * 0.7f, true);
        }
        if (effect != null) {
            mc.field_71452_i.func_78873_a(effect);
        }
    }

    @Override
    public void registerItemRenderer(Item item, int meta, String id) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName().toString(), id));
    }

    @Override
    public IThreadListener getThreadListener(MessageContext context) {
        if (context.side.isClient()) {
            return Minecraft.func_71410_x();
        }
        return context.getServerHandler().field_147369_b.func_71121_q();
    }

    @Override
    public EntityPlayer getPlayer(MessageContext context) {
        if (context.side.isClient()) {
            return Minecraft.func_71410_x().field_71439_g;
        }
        return context.getServerHandler().field_147369_b;
    }

    @Override
    @Nullable
    public EntityLivingBase getEntityLivingBase(MessageContext context, int entityID) {
        EntityPlayerSP player = context.side.isClient() ? Minecraft.func_71410_x().field_71439_g : context.getServerHandler().field_147369_b;
        Entity entity = player.field_70170_p.func_73045_a(entityID);
        return entity instanceof EntityLivingBase ? (EntityLivingBase)entity : null;
    }

    @Override
    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        if (world instanceof WorldClient) {
            switch (ID) {
                case 0: {
                    return new TrinketGui(player);
                }
                case 1: {
                    return new ManaHud();
                }
                case 2: {
                    return new GuiEntityProperties(player);
                }
                case 3: {
                    return new GuiAttributesScreen(player);
                }
                case 4: {
                    return new GuiRaceSelectionScreen(player);
                }
            }
        }
        return null;
    }
}

