/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.events;

import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerPickupXpEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import xzeroair.trinkets.Trinkets;
import xzeroair.trinkets.api.TrinketHelper;
import xzeroair.trinkets.capabilities.Capabilities;
import xzeroair.trinkets.capabilities.Vip.VipStatus;
import xzeroair.trinkets.capabilities.magic.MagicStats;
import xzeroair.trinkets.capabilities.race.EntityProperties;
import xzeroair.trinkets.traits.AbilityHandler;
import xzeroair.trinkets.traits.abilities.interfaces.IAbilityInterface;
import xzeroair.trinkets.traits.abilities.interfaces.ISleepAbility;
import xzeroair.trinkets.util.TrinketsConfig;

public class PlayerEventMC {
    @SubscribeEvent
    public void startTracking(PlayerEvent.StartTracking event) {
        EntityPlayer player = event.getEntityPlayer();
        Entity entity = event.getTarget();
        Capabilities.getEntityProperties(entity, cap -> cap.sendInformationToPlayer((EntityLivingBase)player));
        if (TrinketsConfig.SERVER.misc.retrieveVIP) {
            Capabilities.getVipStatus(entity, cap -> cap.sendStatusToPlayer(player));
        }
    }

    @SubscribeEvent
    public void playerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        EntityPlayer player = event.player;
        boolean client = player.field_70170_p.field_72995_K;
        if (!client && player.func_70089_S()) {
            Capabilities.getMagicStats((Entity)player, cap -> cap.sendManaToPlayer((EntityLivingBase)player));
            TrinketHelper.applyToAccessories((EntityLivingBase)player, stack -> Capabilities.getTrinketProperties(stack, prop -> {
                prop.turnOff();
                prop.sendInformationToPlayer((EntityLivingBase)player, (EntityLivingBase)player);
            }));
        }
    }

    @SubscribeEvent
    public void playerSleep(PlayerSleepInBedEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        Capabilities.getEntityProperties((Entity)entity, prop -> {
            Map<String, AbilityHandler.AbilityHolder> abilities = prop.getAbilityHandler().getActiveAbilities();
            for (Map.Entry<String, AbilityHandler.AbilityHolder> entry : abilities.entrySet()) {
                String key = entry.getKey();
                AbilityHandler.AbilityHolder value = entry.getValue();
                try {
                    IAbilityInterface ability = value.getAbility();
                    if (!(ability instanceof ISleepAbility)) continue;
                    EntityPlayer.SleepResult defaultResult = event.getResultStatus();
                    EntityPlayer.SleepResult result = ((ISleepAbility)ability).onStartSleeping(entity, event.getPos(), event.getResultStatus());
                    if (result == null) continue;
                    boolean ok = true;
                    if (defaultResult != null) {
                        boolean bl = ok = result.compareTo((Enum)defaultResult) != 0;
                    }
                    if (!ok) continue;
                    event.setResult(result);
                }
                catch (Exception e) {
                    Trinkets.log.error("Trinkets had an Error with Ability:" + key);
                    e.printStackTrace();
                }
            }
        });
    }

    @SubscribeEvent
    public void playerWakeUp(PlayerWakeUpEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        Capabilities.getEntityProperties((Entity)entity, prop -> {
            Map<String, AbilityHandler.AbilityHolder> abilities = prop.getAbilityHandler().getActiveAbilities();
            for (Map.Entry<String, AbilityHandler.AbilityHolder> entry : abilities.entrySet()) {
                String key = entry.getKey();
                AbilityHandler.AbilityHolder value = entry.getValue();
                try {
                    IAbilityInterface ability = value.getAbility();
                    if (!(ability instanceof ISleepAbility)) continue;
                    ((ISleepAbility)ability).onWakeUp(entity, event.wakeImmediately(), event.updateWorld(), event.shouldSetSpawn());
                }
                catch (Exception e) {
                    Trinkets.log.error("Trinkets had an Error with Ability:" + key);
                    e.printStackTrace();
                }
            }
        });
    }

    @SubscribeEvent
    public void playerClone(PlayerPickupXpEvent event) {
    }

    @SubscribeEvent
    public void playerClone(PlayerEvent.Clone event) {
        EntityPlayer oldPlayer = event.getOriginal();
        EntityPlayer newPlayer = event.getEntityPlayer();
        boolean wasDeath = event.isWasDeath();
        boolean keepInv = event.getOriginal().func_130014_f_().func_82736_K().func_82766_b("keepInventory");
        try {
            Capabilities.getVipStatus((Entity)oldPlayer, oldVIP -> Capabilities.getVipStatus((Entity)newPlayer, newVIP -> newVIP.copyFrom((VipStatus)oldVIP, wasDeath, keepInv)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            Capabilities.getEntityProperties((Entity)oldPlayer, oldProp -> Capabilities.getEntityProperties((Entity)newPlayer, newProp -> newProp.copyFrom((EntityProperties)oldProp, wasDeath, keepInv)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            Capabilities.getMagicStats((Entity)oldPlayer, oldMagic -> Capabilities.getMagicStats((Entity)newPlayer, newMagic -> newMagic.copyFrom((MagicStats)oldMagic, wasDeath, keepInv)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

