/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.events;

import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.event.PlayerSPPushOutOfBlocksEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import xzeroair.trinkets.Trinkets;
import xzeroair.trinkets.attributes.JumpAttribute;
import xzeroair.trinkets.capabilities.Capabilities;
import xzeroair.trinkets.events.EventBaseHandler;
import xzeroair.trinkets.traits.AbilityHandler;
import xzeroair.trinkets.traits.abilities.interfaces.IAbilityInterface;
import xzeroair.trinkets.traits.abilities.interfaces.IJumpAbility;
import xzeroair.trinkets.util.TrinketsConfig;

public class MovementHandler
extends EventBaseHandler {
    @SubscribeEvent
    public void onCollideWithBlock(PlayerSPPushOutOfBlocksEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        Capabilities.getEntityProperties((Entity)player, prop -> {
            if (!prop.isNormalSize()) {
                event.setCanceled(true);
            }
        });
    }

    @SubscribeEvent
    public void livingJump(LivingEvent.LivingJumpEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        IAttributeInstance attribute = entity.func_110140_aT().func_111151_a(JumpAttribute.Jump);
        if (attribute != null && !attribute.func_111122_c().isEmpty()) {
            entity.field_70181_x += attribute.func_111126_e() - (double)0.42f;
            if (entity.func_70051_ag()) {
                entity.field_70159_w *= attribute.func_111126_e() / (double)0.42f;
                entity.field_70179_y *= attribute.func_111126_e() / (double)0.42f;
            }
        }
        Capabilities.getEntityProperties((Entity)entity, prop -> {
            if (TrinketsConfig.SERVER.misc.movement && prop.getRaceHandler().isTransforming()) {
                entity.field_70181_x = 0.0;
                return;
            }
            prop.getRaceHandler().jump();
            Map<String, AbilityHandler.AbilityHolder> abilities = prop.getAbilityHandler().getActiveAbilities();
            for (Map.Entry<String, AbilityHandler.AbilityHolder> entry : abilities.entrySet()) {
                String key = entry.getKey();
                AbilityHandler.AbilityHolder value = entry.getValue();
                try {
                    IAbilityInterface ability = value.getAbility();
                    if (!(ability instanceof IJumpAbility)) continue;
                    ((IJumpAbility)ability).jump(entity);
                }
                catch (Exception e) {
                    Trinkets.log.error("Trinkets had an Error with Ability:" + key);
                    e.printStackTrace();
                }
            }
        });
    }

    @SubscribeEvent
    public void livingFall(LivingFallEvent event) {
        boolean cancel;
        EntityLivingBase entity = event.getEntityLiving();
        float baseDistance = event.getDistance();
        float baseMultiplier = event.getDamageMultiplier();
        IAttributeInstance attribute = entity.func_110140_aT().func_111151_a(JumpAttribute.Jump);
        if (attribute != null) {
            double value = attribute.func_111126_e();
            float multi = (float)(value / (double)0.42f);
            float distance = 3.0f * (multi - 1.0f);
            event.setDistance(baseDistance - distance);
        }
        if (cancel = Capabilities.getEntityProperties((Entity)entity, false, (prop, bool) -> {
            float fallDistance = event.getDistance();
            float damageMultiplier = event.getDamageMultiplier();
            Map<String, AbilityHandler.AbilityHolder> abilities = prop.getAbilityHandler().getActiveAbilities();
            for (Map.Entry<String, AbilityHandler.AbilityHolder> entry : abilities.entrySet()) {
                String key = entry.getKey();
                AbilityHandler.AbilityHolder value = entry.getValue();
                try {
                    float abilityModifier;
                    IAbilityInterface ability = value.getAbility();
                    if (!(ability instanceof IJumpAbility)) continue;
                    IJumpAbility fall = (IJumpAbility)ability;
                    float abilityDistance = fall.fallDistance(entity, fallDistance);
                    if (fallDistance != abilityDistance) {
                        fallDistance = abilityDistance;
                    }
                    if (damageMultiplier != (abilityModifier = fall.fallDamageMultiplier(entity, damageMultiplier))) {
                        damageMultiplier = abilityModifier;
                    }
                    boolean abilityCancel = fall.fall(entity, fallDistance, damageMultiplier, (boolean)bool);
                    if (bool == abilityCancel) continue;
                    bool = abilityCancel;
                }
                catch (Exception e) {
                    Trinkets.log.error("Trinkets had an Error with Ability:" + key);
                    e.printStackTrace();
                }
            }
            if (fallDistance != baseDistance) {
                event.setDistance(MathHelper.func_76131_a((float)fallDistance, (float)0.0f, (float)fallDistance));
            }
            if (damageMultiplier != baseMultiplier) {
                event.setDamageMultiplier(MathHelper.func_76131_a((float)damageMultiplier, (float)0.0f, (float)damageMultiplier));
            }
            prop.getRaceHandler().fall(event);
            return event.isCanceled() || event.getDistance() <= 0.0f || event.getDamageMultiplier() <= 0.0f || bool != false;
        }).booleanValue()) {
            this.cancelEvent((Event)event);
        }
    }
}

