/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.events;

import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.ArrowNockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import xzeroair.trinkets.Trinkets;
import xzeroair.trinkets.capabilities.Capabilities;
import xzeroair.trinkets.events.EventBaseHandler;
import xzeroair.trinkets.traits.AbilityHandler;
import xzeroair.trinkets.traits.abilities.interfaces.IAbilityInterface;
import xzeroair.trinkets.traits.abilities.interfaces.IAttackAbility;
import xzeroair.trinkets.traits.abilities.interfaces.IBowAbility;
import xzeroair.trinkets.traits.abilities.interfaces.IHealAbility;

public class CombatHandler
extends EventBaseHandler {
    @SubscribeEvent
    public void arrowLooseEvent(ArrowLooseEvent event) {
        Capabilities.getEntityProperties((Entity)event.getEntityLiving(), prop -> {
            try {
                prop.getRaceHandler().bowUsed(event);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (!event.isCanceled()) {
                Map<String, AbilityHandler.AbilityHolder> abilities = prop.getAbilityHandler().getActiveAbilities();
                for (Map.Entry<String, AbilityHandler.AbilityHolder> entry : abilities.entrySet()) {
                    String key = entry.getKey();
                    AbilityHandler.AbilityHolder value = entry.getValue();
                    if (event.isCanceled()) break;
                    try {
                        IAbilityInterface ability = value.getAbility();
                        if (!(ability instanceof IBowAbility)) continue;
                        ((IBowAbility)ability).looseArrow(event);
                    }
                    catch (Exception e) {
                        Trinkets.log.error("Trinkets had an Error with Ability:" + key);
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    @SubscribeEvent
    public void arrowNockEvent(ArrowNockEvent event) {
        Capabilities.getEntityProperties((Entity)event.getEntityLiving(), prop -> {
            try {
                prop.getRaceHandler().bowNocked(event);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Map<String, AbilityHandler.AbilityHolder> abilities = prop.getAbilityHandler().getActiveAbilities();
            for (Map.Entry<String, AbilityHandler.AbilityHolder> entry : abilities.entrySet()) {
                String key = entry.getKey();
                AbilityHandler.AbilityHolder value = entry.getValue();
                try {
                    IAbilityInterface ability = value.getAbility();
                    if (!(ability instanceof IBowAbility)) continue;
                    ((IBowAbility)ability).knockArrow(event);
                }
                catch (Exception e) {
                    Trinkets.log.error("Trinkets had an Error with Ability:" + key);
                    e.printStackTrace();
                }
            }
        });
    }

    @SubscribeEvent
    public void ArrowImpactEvent(ProjectileImpactEvent.Arrow event) {
        if (event.getArrow().field_70250_c instanceof EntityLivingBase) {
            Capabilities.getEntityProperties(event.getArrow().field_70250_c, prop -> {
                Map<String, AbilityHandler.AbilityHolder> abilities = prop.getAbilityHandler().getActiveAbilities();
                for (Map.Entry<String, AbilityHandler.AbilityHolder> entry : abilities.entrySet()) {
                    String key = entry.getKey();
                    AbilityHandler.AbilityHolder value = entry.getValue();
                    if (event.isCanceled()) break;
                    try {
                        IAbilityInterface ability = value.getAbility();
                        if (!(ability instanceof IBowAbility)) continue;
                        ((IBowAbility)ability).arrowImpact(event);
                    }
                    catch (Exception e) {
                        Trinkets.log.error("Trinkets had an Error with Ability:" + key);
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    @SubscribeEvent
    public void TargetEvent(LivingSetAttackTargetEvent event) {
        EntityLivingBase enemy = event.getEntityLiving();
        Capabilities.getEntityProperties((Entity)event.getTarget(), prop -> {
            prop.getRaceHandler().targetedByEnemy(enemy);
            Map<String, AbilityHandler.AbilityHolder> abilities = prop.getAbilityHandler().getActiveAbilities();
            for (Map.Entry<String, AbilityHandler.AbilityHolder> entry : abilities.entrySet()) {
                String key = entry.getKey();
                AbilityHandler.AbilityHolder value = entry.getValue();
                if (enemy instanceof EntityLiving && ((EntityLiving)enemy).func_70638_az() == null) break;
                try {
                    IAbilityInterface ability = value.getAbility();
                    if (!(ability instanceof IAttackAbility)) continue;
                    ((IAttackAbility)ability).targetedByEnemy(enemy);
                }
                catch (Exception e) {
                    Trinkets.log.error("Trinkets had an Error with Ability:" + key);
                    e.printStackTrace();
                }
            }
        });
    }

    @SubscribeEvent
    public void attackEvent(LivingAttackEvent event) {
        DamageSource source = event.getSource();
        if (source.func_76357_e()) {
            return;
        }
        float damage = event.getAmount();
        EntityLivingBase attacked = event.getEntityLiving();
        if (source.func_76346_g() instanceof EntityLivingBase) {
            EntityLivingBase attacker = (EntityLivingBase)source.func_76346_g();
            Capabilities.getEntityProperties((Entity)attacker, prop -> {
                boolean isCanceled;
                boolean bl = isCanceled = !prop.getRaceHandler().attackedEntity(attacked, source, damage);
                if (!isCanceled) {
                    Map<String, AbilityHandler.AbilityHolder> abilities = prop.getAbilityHandler().getActiveAbilities();
                    for (Map.Entry<String, AbilityHandler.AbilityHolder> entry : abilities.entrySet()) {
                        String key = entry.getKey();
                        AbilityHandler.AbilityHolder value = entry.getValue();
                        try {
                            IAbilityInterface ability = value.getAbility();
                            if (!(ability instanceof IAttackAbility) || !(isCanceled = ((IAttackAbility)ability).attackEntity(attacked, source, damage, isCanceled))) continue;
                            break;
                        }
                        catch (Exception e) {
                            Trinkets.log.error("Trinkets had an Error with Ability:" + key);
                            e.printStackTrace();
                        }
                    }
                }
                if (isCanceled) {
                    this.cancelEvent((Event)event);
                }
            });
        }
        if (!event.isCanceled()) {
            Capabilities.getEntityProperties((Entity)attacked, prop -> {
                boolean isCanceled;
                boolean bl = isCanceled = !prop.getRaceHandler().isAttacked(source, damage);
                if (!isCanceled) {
                    Map<String, AbilityHandler.AbilityHolder> abilities = prop.getAbilityHandler().getActiveAbilities();
                    for (Map.Entry<String, AbilityHandler.AbilityHolder> entry : abilities.entrySet()) {
                        String key = entry.getKey();
                        AbilityHandler.AbilityHolder value = entry.getValue();
                        try {
                            IAbilityInterface ability = value.getAbility();
                            if (!(ability instanceof IAttackAbility) || !(isCanceled = ((IAttackAbility)ability).attacked(attacked, source, damage, isCanceled))) continue;
                            break;
                        }
                        catch (Exception e) {
                            Trinkets.log.error("Trinkets had an Error with Ability:" + key);
                            e.printStackTrace();
                        }
                    }
                }
                if (isCanceled) {
                    this.cancelEvent((Event)event);
                }
            });
        }
    }

    @SubscribeEvent
    public void HurtEvent(LivingHurtEvent event) {
        DamageSource source = event.getSource();
        float damage = event.getAmount();
        if (source.func_76357_e() || damage == 0.0f) {
            return;
        }
        EntityLivingBase attacked = event.getEntityLiving();
        if (source.func_76346_g() instanceof EntityLivingBase) {
            EntityLivingBase attacker = (EntityLivingBase)source.func_76346_g();
            damage = Capabilities.getEntityProperties((Entity)attacker, Float.valueOf(damage), (prop, dmg) -> {
                dmg = Float.valueOf(prop.getRaceHandler().hurtEntity(attacked, source, dmg.floatValue()));
                if (dmg.floatValue() > 0.0f) {
                    Map<String, AbilityHandler.AbilityHolder> abilities = prop.getAbilityHandler().getActiveAbilities();
                    for (Map.Entry<String, AbilityHandler.AbilityHolder> entry : abilities.entrySet()) {
                        String key = entry.getKey();
                        AbilityHandler.AbilityHolder value = entry.getValue();
                        try {
                            IAbilityInterface ability = value.getAbility();
                            if (!(ability instanceof IAttackAbility) || !((dmg = Float.valueOf(((IAttackAbility)ability).hurtEntity(attacked, source, dmg.floatValue()))).floatValue() <= 0.0f)) continue;
                            break;
                        }
                        catch (Exception e) {
                            Trinkets.log.error("Trinkets had an Error with Ability:" + key);
                            e.printStackTrace();
                        }
                    }
                }
                return dmg;
            }).floatValue();
        }
        if (damage > 0.0f) {
            damage = Capabilities.getEntityProperties((Entity)attacked, Float.valueOf(damage), (prop, dmg) -> {
                dmg = Float.valueOf(prop.getRaceHandler().isHurt(source, dmg.floatValue()));
                if (dmg.floatValue() > 0.0f) {
                    Map<String, AbilityHandler.AbilityHolder> abilities = prop.getAbilityHandler().getActiveAbilities();
                    for (Map.Entry<String, AbilityHandler.AbilityHolder> entry : abilities.entrySet()) {
                        String key = entry.getKey();
                        AbilityHandler.AbilityHolder value = entry.getValue();
                        try {
                            IAbilityInterface ability = value.getAbility();
                            if (!(ability instanceof IAttackAbility) || !((dmg = Float.valueOf(((IAttackAbility)ability).hurt(attacked, source, dmg.floatValue()))).floatValue() <= 0.0f)) continue;
                            break;
                        }
                        catch (Exception e) {
                            Trinkets.log.error("Trinkets had an Error with Ability:" + key);
                            e.printStackTrace();
                        }
                    }
                }
                return dmg;
            }).floatValue();
        }
        if (damage <= 0.0f) {
            this.cancelEvent((Event)event);
        } else {
            event.setAmount(damage);
        }
    }

    @SubscribeEvent
    public void applyDamageEvent(LivingDamageEvent event) {
        DamageSource source = event.getSource();
        float damage = event.getAmount();
        if (source.func_76357_e() || damage == 0.0f) {
            return;
        }
        EntityLivingBase attacked = event.getEntityLiving();
        if (source.func_76346_g() instanceof EntityLivingBase) {
            EntityLivingBase attacker = (EntityLivingBase)source.func_76346_g();
            damage = Capabilities.getEntityProperties((Entity)attacker, Float.valueOf(damage), (prop, dmg) -> {
                dmg = Float.valueOf(prop.getRaceHandler().damagedEntity(attacked, source, dmg.floatValue()));
                if (dmg.floatValue() > 0.0f) {
                    Map<String, AbilityHandler.AbilityHolder> abilities = prop.getAbilityHandler().getActiveAbilities();
                    for (Map.Entry<String, AbilityHandler.AbilityHolder> entry : abilities.entrySet()) {
                        String key = entry.getKey();
                        AbilityHandler.AbilityHolder value = entry.getValue();
                        try {
                            IAbilityInterface ability = value.getAbility();
                            if (!(ability instanceof IAttackAbility) || !((dmg = Float.valueOf(((IAttackAbility)ability).damageEntity(attacked, source, dmg.floatValue()))).floatValue() <= 0.0f)) continue;
                            break;
                        }
                        catch (Exception e) {
                            Trinkets.log.error("Trinkets had an Error with Ability:" + key);
                            e.printStackTrace();
                        }
                    }
                }
                return dmg;
            }).floatValue();
        }
        if (damage > 0.0f) {
            damage = Capabilities.getEntityProperties((Entity)attacked, Float.valueOf(damage), (prop, dmg) -> {
                dmg = Float.valueOf(prop.getRaceHandler().isDamaged(source, dmg.floatValue()));
                if (dmg.floatValue() > 0.0f) {
                    Map<String, AbilityHandler.AbilityHolder> abilities = prop.getAbilityHandler().getActiveAbilities();
                    for (Map.Entry<String, AbilityHandler.AbilityHolder> entry : abilities.entrySet()) {
                        String key = entry.getKey();
                        AbilityHandler.AbilityHolder value = entry.getValue();
                        try {
                            IAbilityInterface ability = value.getAbility();
                            if (!(ability instanceof IAttackAbility) || !((dmg = Float.valueOf(((IAttackAbility)ability).damaged(attacked, source, dmg.floatValue()))).floatValue() <= 0.0f)) continue;
                            break;
                        }
                        catch (Exception e) {
                            Trinkets.log.error("Trinkets had an Error with Ability:" + key);
                            e.printStackTrace();
                        }
                    }
                }
                return dmg;
            }).floatValue();
        }
        if (damage <= 0.0f) {
            this.cancelEvent((Event)event);
        } else {
            event.setAmount(damage);
        }
    }

    @SubscribeEvent
    public void onDeathEvent(LivingDeathEvent event) {
        DamageSource source = event.getSource();
        EntityLivingBase attacked = event.getEntityLiving();
        if (attacked instanceof EntityPlayer && attacked.field_70170_p.field_72995_K) {
            return;
        }
        if (source.func_76346_g() instanceof EntityLivingBase) {
            EntityLivingBase attacker = (EntityLivingBase)source.func_76346_g();
            Capabilities.getEntityProperties((Entity)attacker, prop -> {
                Map<String, AbilityHandler.AbilityHolder> abilities = prop.getAbilityHandler().getActiveAbilities();
                for (Map.Entry<String, AbilityHandler.AbilityHolder> entry : abilities.entrySet()) {
                    String key = entry.getKey();
                    AbilityHandler.AbilityHolder value = entry.getValue();
                    try {
                        IAbilityInterface ability = value.getAbility();
                        if (!(ability instanceof IAttackAbility)) continue;
                        ((IAttackAbility)ability).killedEntity(attacked, source);
                    }
                    catch (Exception e) {
                        Trinkets.log.error("Trinkets had an Error with Ability:" + key);
                        e.printStackTrace();
                    }
                }
            });
        }
        Capabilities.getEntityProperties((Entity)attacked, prop -> {
            boolean notDead = false;
            Map<String, AbilityHandler.AbilityHolder> abilities = prop.getAbilityHandler().getActiveAbilities();
            for (Map.Entry<String, AbilityHandler.AbilityHolder> entry : abilities.entrySet()) {
                String key = entry.getKey();
                AbilityHandler.AbilityHolder value = entry.getValue();
                try {
                    IAbilityInterface ability = value.getAbility();
                    if (!(ability instanceof IAttackAbility) || !(notDead = ((IAttackAbility)ability).died(attacked, source, notDead))) continue;
                    break;
                }
                catch (Exception e) {
                    Trinkets.log.error("Trinkets had an Error with Ability:" + key);
                    e.printStackTrace();
                }
            }
            if (notDead) {
                this.cancelEvent((Event)event);
            }
        });
    }

    @SubscribeEvent
    public void experienceDropEvent(LivingExperienceDropEvent event) {
        EntityLivingBase attacked = event.getEntityLiving();
        try {
            NBTTagCompound nbt = attacked.getEntityData();
            if (nbt != null && nbt.func_74764_b("xat:summoned")) {
                event.setDroppedExperience(0);
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        EntityPlayer attacker = event.getAttackingPlayer();
        Capabilities.getEntityProperties((Entity)attacker, prop -> {
            int originalDropped;
            int originalExp = event.getOriginalExperience();
            int droppedExp = originalDropped = event.getDroppedExperience();
            Map<String, AbilityHandler.AbilityHolder> abilities = prop.getAbilityHandler().getActiveAbilities();
            for (Map.Entry<String, AbilityHandler.AbilityHolder> entry : abilities.entrySet()) {
                String key = entry.getKey();
                AbilityHandler.AbilityHolder value = entry.getValue();
                try {
                    IAbilityInterface ability = value.getAbility();
                    if (!(ability instanceof IAttackAbility) || (droppedExp = ((IAttackAbility)ability).killedEntityExpDrop(attacked, originalExp, droppedExp)) > 0) continue;
                    break;
                }
                catch (Exception e) {
                    Trinkets.log.error("Trinkets had an Error with Ability:" + key);
                    e.printStackTrace();
                }
            }
            if (originalDropped != droppedExp) {
                if (droppedExp > 0) {
                    event.setDroppedExperience(droppedExp);
                } else if (!this.isEventCanceled((Event)event)) {
                    this.cancelEvent((Event)event);
                }
            }
        });
    }

    @SubscribeEvent
    public void ItemDropEvent(LivingDropsEvent event) {
        EntityLivingBase attacked = event.getEntityLiving();
        try {
            NBTTagCompound nbt = attacked.getEntityData();
            if (nbt != null && nbt.func_74764_b("xat:summoned")) {
                if (!event.getDrops().isEmpty()) {
                    event.getDrops().clear();
                }
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        DamageSource source = event.getSource();
        if (source.func_76346_g() instanceof EntityLivingBase) {
            EntityLivingBase attacker = (EntityLivingBase)source.func_76346_g();
            Capabilities.getEntityProperties((Entity)attacker, prop -> {
                Map<String, AbilityHandler.AbilityHolder> abilities = prop.getAbilityHandler().getActiveAbilities();
                for (Map.Entry<String, AbilityHandler.AbilityHolder> entry : abilities.entrySet()) {
                    String key = entry.getKey();
                    AbilityHandler.AbilityHolder value = entry.getValue();
                    try {
                        IAbilityInterface ability = value.getAbility();
                        if (!(ability instanceof IAttackAbility)) continue;
                        ((IAttackAbility)ability).killedEntityItemDrops(attacked, source, event.getLootingLevel(), event.getDrops());
                    }
                    catch (Exception e) {
                        Trinkets.log.error("Trinkets had an Error with Ability:" + key);
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    @SubscribeEvent
    public void healEvent(LivingHealEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        Capabilities.getEntityProperties((Entity)entity, prop -> {
            float amount;
            float finalAmount = amount = event.getAmount();
            Map<String, AbilityHandler.AbilityHolder> abilities = prop.getAbilityHandler().getActiveAbilities();
            for (Map.Entry<String, AbilityHandler.AbilityHolder> entry : abilities.entrySet()) {
                String key = entry.getKey();
                AbilityHandler.AbilityHolder value = entry.getValue();
                try {
                    IAbilityInterface ability = value.getAbility();
                    if (!(ability instanceof IHealAbility)) continue;
                    finalAmount = ((IHealAbility)ability).onHeal(entity, finalAmount);
                }
                catch (Exception e) {
                    Trinkets.log.error("Trinkets had an Error with Ability:" + key);
                    e.printStackTrace();
                }
            }
            finalAmount = prop.getRaceHandler().onHeal(finalAmount);
            if (amount != finalAmount) {
                if (finalAmount > 0.0f) {
                    event.setAmount(finalAmount);
                } else if (!this.isEventCanceled((Event)event)) {
                    this.cancelEvent((Event)event);
                }
            }
        });
    }
}

