/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.events;

import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import xzeroair.trinkets.Trinkets;
import xzeroair.trinkets.capabilities.Capabilities;
import xzeroair.trinkets.events.EventBaseHandler;
import xzeroair.trinkets.traits.AbilityHandler;
import xzeroair.trinkets.traits.abilities.interfaces.IAbilityInterface;
import xzeroair.trinkets.traits.abilities.interfaces.IMiningAbility;

public class BlockBreakEvents
extends EventBaseHandler {
    @SubscribeEvent
    public void BreakSpeed(PlayerEvent.BreakSpeed event) {
        Capabilities.getEntityProperties((Entity)event.getEntityLiving(), prop -> {
            prop.getRaceHandler().breakingBlock(event);
            if (!event.isCanceled()) {
                float newOriginal = event.getNewSpeed();
                float newSpeed = event.getNewSpeed();
                Map<String, AbilityHandler.AbilityHolder> abilities = prop.getAbilityHandler().getActiveAbilities();
                for (Map.Entry<String, AbilityHandler.AbilityHolder> entry : abilities.entrySet()) {
                    if (newSpeed <= 0.0f || newSpeed >= 100.0f) break;
                    String key = entry.getKey();
                    AbilityHandler.AbilityHolder holder = entry.getValue();
                    try {
                        IAbilityInterface ability = holder.getAbility();
                        if (!(ability instanceof IMiningAbility)) continue;
                        newSpeed = ((IMiningAbility)ability).breakingBlock(event.getEntityLiving(), event.getState(), event.getPos(), newOriginal, newSpeed);
                    }
                    catch (Exception e) {
                        Trinkets.log.error("Trinkets had an Error with Ability:" + key);
                        e.printStackTrace();
                    }
                }
                if (newSpeed != newOriginal) {
                    if (newSpeed <= 0.0f) {
                        this.cancelEvent((Event)event);
                    } else {
                        event.setNewSpeed(newSpeed);
                    }
                }
            }
        });
    }

    @SubscribeEvent
    public void breakEvent(BlockEvent.BreakEvent event) {
        EntityPlayer player = event.getPlayer();
        Capabilities.getEntityProperties((Entity)player, prop -> {
            prop.getRaceHandler().blockBroken(event);
            if (!event.isCanceled()) {
                int defaultExp = event.getExpToDrop();
                int exp = event.getExpToDrop();
                Map<String, AbilityHandler.AbilityHolder> abilities = prop.getAbilityHandler().getActiveAbilities();
                for (Map.Entry<String, AbilityHandler.AbilityHolder> entry : abilities.entrySet()) {
                    if (exp < 0) break;
                    String key = entry.getKey();
                    AbilityHandler.AbilityHolder holder = entry.getValue();
                    try {
                        IAbilityInterface ability = holder.getAbility();
                        if (ability instanceof IMiningAbility) {
                            int result;
                            exp = result = ((IMiningAbility)ability).brokeBlock((EntityLivingBase)player, event.getWorld(), event.getState(), event.getPos(), exp);
                        }
                    }
                    catch (Exception e) {
                        Trinkets.log.error("Trinkets had an Error with Ability:" + key);
                        e.printStackTrace();
                    }
                    if (exp >= 0) continue;
                    break;
                }
                if (exp != defaultExp) {
                    if (exp < 0) {
                        this.cancelEvent((Event)event);
                    } else {
                        event.setExpToDrop(exp);
                    }
                }
            }
        });
    }

    @SubscribeEvent
    public void blockDrops(BlockEvent.HarvestDropsEvent event) {
        Capabilities.getEntityProperties((Entity)event.getHarvester(), prop -> {
            prop.getRaceHandler().blockDrops(event);
            if (!event.isCanceled()) {
                float defaultChance = event.getDropChance();
                float dropChance = event.getDropChance();
                Map<String, AbilityHandler.AbilityHolder> abilities = prop.getAbilityHandler().getActiveAbilities();
                for (Map.Entry<String, AbilityHandler.AbilityHolder> entry : abilities.entrySet()) {
                    if (dropChance <= 0.0f) break;
                    String key = entry.getKey();
                    AbilityHandler.AbilityHolder holder = entry.getValue();
                    try {
                        IAbilityInterface ability = holder.getAbility();
                        if (!(ability instanceof IMiningAbility)) continue;
                        dropChance = ((IMiningAbility)ability).blockDrops((EntityLivingBase)event.getHarvester(), event.getWorld(), event.getState(), event.getPos(), event.getDrops(), dropChance, event.isSilkTouching(), event.getFortuneLevel());
                    }
                    catch (Exception e) {
                        Trinkets.log.error("Trinkets had an Error with Ability:" + key);
                        e.printStackTrace();
                    }
                }
                if (dropChance != defaultChance) {
                    if (dropChance <= 0.0f) {
                        this.cancelEvent((Event)event);
                    } else {
                        event.setDropChance(dropChance);
                    }
                }
            }
        });
    }
}

