/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.api;

import baubles.api.BaublesApi;
import baubles.api.cap.IBaublesItemHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import xzeroair.trinkets.Trinkets;
import xzeroair.trinkets.capabilities.Capabilities;
import xzeroair.trinkets.capabilities.InventoryContainerCapability.ITrinketContainerHandler;
import xzeroair.trinkets.util.compat.baubles.BaublesHelper;

public class TrinketHelper {
    public static ITrinketContainerHandler getTrinketHandler(EntityLivingBase entity) {
        return Capabilities.getTrinketContainer((Entity)entity);
    }

    public static ITrinketContainerHandler getTrinketHandler(EntityLivingBase entity, Consumer<ITrinketContainerHandler> consumer) {
        return Capabilities.getTrinketContainer((Entity)entity, consumer);
    }

    public static <R> R getTrinketHandler(EntityLivingBase entity, R ret, BiFunction<ITrinketContainerHandler, R, R> func) {
        return Capabilities.getTrinketContainer((Entity)entity, ret, func);
    }

    @Nullable
    public static SlotInformation getSlotInfoForItem(EntityLivingBase entity, Predicate<ItemStack> predicate) {
        SlotInformation info = TrinketHelper.getSlotInfoForItemFromAccessory(entity, predicate);
        if (info == null) {
            SlotInformation equipmentInfo = TrinketHelper.getSlotInfoForItemFromEquipment(entity, predicate);
            if (equipmentInfo == null) {
                SlotInformation heldInfo = TrinketHelper.getSlotInfoForItemFromHeldEquipment(entity, predicate);
                if (heldInfo == null && entity instanceof EntityPlayer) {
                    return TrinketHelper.getSlotInfoForItemFromPlayerInventory(entity, predicate, true);
                }
                return heldInfo;
            }
            return equipmentInfo;
        }
        return info;
    }

    @Nullable
    public static SlotInformation getSlotInfoForItemFromAccessory(EntityLivingBase entity, Predicate<ItemStack> predicate) {
        SlotInformation info = TrinketHelper.getTrinketSlotInformation(entity, predicate);
        if (info == null) {
            SlotInformation baubleInfo = TrinketHelper.getBaubleSlotInformation(entity, predicate);
            if (baubleInfo == null) {
                return null;
            }
            return baubleInfo;
        }
        return info;
    }

    @Nullable
    public static SlotInformation getSlotInfoForItemFromEquipment(EntityLivingBase entity, Predicate<ItemStack> predicate) {
        if (entity == null) {
            return null;
        }
        ItemStack head = entity.func_184582_a(EntityEquipmentSlot.HEAD);
        if (predicate.test(head)) {
            return TrinketHelper.getSlotInfo(head, SlotInformation.ItemHandlerType.HEAD.getName(), EntityEquipmentSlot.HEAD.func_188452_c());
        }
        ItemStack chest = entity.func_184582_a(EntityEquipmentSlot.CHEST);
        if (predicate.test(chest)) {
            return TrinketHelper.getSlotInfo(chest, SlotInformation.ItemHandlerType.CHEST.getName(), EntityEquipmentSlot.CHEST.func_188452_c());
        }
        ItemStack legs = entity.func_184582_a(EntityEquipmentSlot.LEGS);
        if (predicate.test(legs)) {
            return TrinketHelper.getSlotInfo(legs, SlotInformation.ItemHandlerType.LEGS.getName(), EntityEquipmentSlot.LEGS.func_188452_c());
        }
        ItemStack feet = entity.func_184582_a(EntityEquipmentSlot.FEET);
        if (predicate.test(feet)) {
            return TrinketHelper.getSlotInfo(feet, SlotInformation.ItemHandlerType.FEET.getName(), EntityEquipmentSlot.FEET.func_188452_c());
        }
        return null;
    }

    @Nullable
    public static SlotInformation getSlotInfoForItemFromHeldEquipment(EntityLivingBase entity, Predicate<ItemStack> predicate) {
        if (entity == null) {
            return null;
        }
        ItemStack mainHand = entity.func_184582_a(EntityEquipmentSlot.MAINHAND);
        if (predicate.test(mainHand)) {
            return TrinketHelper.getSlotInfo(mainHand, SlotInformation.ItemHandlerType.MAINHAND.getName(), EntityEquipmentSlot.MAINHAND.func_188452_c());
        }
        ItemStack offHand = entity.func_184582_a(EntityEquipmentSlot.OFFHAND);
        if (predicate.test(offHand)) {
            return TrinketHelper.getSlotInfo(offHand, SlotInformation.ItemHandlerType.OFFHAND.getName(), EntityEquipmentSlot.OFFHAND.func_188452_c());
        }
        return null;
    }

    @Nullable
    public static SlotInformation getSlotInfoForItemFromPlayerInventory(EntityLivingBase entity, Predicate<ItemStack> predicate, boolean onHotbar) {
        if (entity instanceof EntityPlayer) {
            InventoryPlayer inventory = ((EntityPlayer)entity).field_71071_by;
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                boolean flag;
                ItemStack stack = inventory.func_70301_a(i);
                boolean isHotBar = InventoryPlayer.func_184435_e((int)i);
                boolean bl = onHotbar ? isHotBar : (flag = !isHotBar);
                if (!predicate.test(stack) || !flag) continue;
                String type = isHotBar ? SlotInformation.ItemHandlerType.HOTBAR.getName() : SlotInformation.ItemHandlerType.INVENTORY.getName();
                return TrinketHelper.getSlotInfo(stack, type, i);
            }
        }
        return null;
    }

    @Nonnull
    public static SlotInformation getSlotInfo(ItemStack stack, String handler, int slot) {
        return new SlotInformation(stack, handler, slot);
    }

    public static List<SlotInformation> getSlotInfoForAccessories(EntityLivingBase entity, Predicate<ItemStack> predicate) {
        ArrayList<SlotInformation> list = new ArrayList<SlotInformation>();
        List<SlotInformation> trinkets2 = TrinketHelper.getSlotInfoForTrinkets(entity, predicate);
        List<SlotInformation> baubles2 = TrinketHelper.getSlotInfoForBaubles(entity, predicate);
        list.addAll(trinkets2);
        list.addAll(baubles2);
        return list;
    }

    public static List<SlotInformation> getSlotInfoForEquipment(EntityLivingBase entity, Predicate<ItemStack> predicate) {
        ArrayList<SlotInformation> list = new ArrayList<SlotInformation>();
        list.addAll(TrinketHelper.getSlotInfoForArmor(entity, predicate));
        list.addAll(TrinketHelper.getSlotInfoForHeldEquipment(entity, predicate));
        return list;
    }

    public static List<SlotInformation> getSlotInfoForArmor(EntityLivingBase entity, Predicate<ItemStack> predicate) {
        ItemStack feet;
        ItemStack legs;
        ItemStack chest;
        ArrayList<SlotInformation> list = new ArrayList<SlotInformation>();
        if (entity == null) {
            return list;
        }
        ItemStack head = entity.func_184582_a(EntityEquipmentSlot.HEAD);
        if (predicate.test(head)) {
            SlotInformation info = TrinketHelper.getSlotInfo(head, SlotInformation.ItemHandlerType.HEAD.getName(), EntityEquipmentSlot.HEAD.func_188452_c());
            list.add(info);
        }
        if (predicate.test(chest = entity.func_184582_a(EntityEquipmentSlot.CHEST))) {
            SlotInformation info = TrinketHelper.getSlotInfo(chest, SlotInformation.ItemHandlerType.CHEST.getName(), EntityEquipmentSlot.CHEST.func_188452_c());
            list.add(info);
        }
        if (predicate.test(legs = entity.func_184582_a(EntityEquipmentSlot.LEGS))) {
            SlotInformation info = TrinketHelper.getSlotInfo(legs, SlotInformation.ItemHandlerType.LEGS.getName(), EntityEquipmentSlot.LEGS.func_188452_c());
            list.add(info);
        }
        if (predicate.test(feet = entity.func_184582_a(EntityEquipmentSlot.FEET))) {
            SlotInformation info = TrinketHelper.getSlotInfo(feet, SlotInformation.ItemHandlerType.FEET.getName(), EntityEquipmentSlot.FEET.func_188452_c());
            list.add(info);
        }
        return list;
    }

    public static List<SlotInformation> getSlotInfoForHeldEquipment(EntityLivingBase entity, Predicate<ItemStack> predicate) {
        ItemStack offHand;
        ArrayList<SlotInformation> list = new ArrayList<SlotInformation>();
        if (entity == null) {
            return list;
        }
        ItemStack mainHand = entity.func_184582_a(EntityEquipmentSlot.MAINHAND);
        if (predicate.test(mainHand)) {
            SlotInformation info = TrinketHelper.getSlotInfo(mainHand, SlotInformation.ItemHandlerType.MAINHAND.getName(), EntityEquipmentSlot.MAINHAND.func_188452_c());
            list.add(info);
        }
        if (predicate.test(offHand = entity.func_184582_a(EntityEquipmentSlot.OFFHAND))) {
            SlotInformation info = TrinketHelper.getSlotInfo(offHand, SlotInformation.ItemHandlerType.OFFHAND.getName(), EntityEquipmentSlot.OFFHAND.func_188452_c());
            list.add(info);
        }
        return list;
    }

    public static List<SlotInformation> getSlotInfoForItems(EntityLivingBase entity, Predicate<ItemStack> predicate, boolean onHotbar) {
        ArrayList<SlotInformation> list = new ArrayList<SlotInformation>();
        if (entity instanceof EntityPlayer) {
            InventoryPlayer inventory = ((EntityPlayer)entity).field_71071_by;
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                boolean flag;
                ItemStack stack = inventory.func_70301_a(i);
                boolean isHotBar = InventoryPlayer.func_184435_e((int)i);
                boolean bl = onHotbar ? isHotBar : (flag = !isHotBar);
                if (!predicate.test(stack) || !flag) continue;
                String type = isHotBar ? SlotInformation.ItemHandlerType.HOTBAR.getName() : SlotInformation.ItemHandlerType.INVENTORY.getName();
                SlotInformation info = TrinketHelper.getSlotInfo(stack, type, i);
                list.add(info);
            }
        }
        return list;
    }

    public static boolean AccessoryCheck(EntityLivingBase entity, Item item) {
        if (item == null) {
            return false;
        }
        return TrinketHelper.AccessoryCheck(entity, (ItemStack stack) -> !stack.func_190926_b() && stack.func_77973_b().getRegistryName().toString().contentEquals(item.getRegistryName().toString()));
    }

    public static boolean AccessoryCheck(EntityLivingBase entity, Predicate<ItemStack> predicate) {
        if (!TrinketHelper.getTrinketStack(entity, predicate).func_190926_b()) {
            return true;
        }
        return !TrinketHelper.getBaubleStack(entity, predicate).func_190926_b();
    }

    public static boolean AccessoryCheck(EntityLivingBase entity, List<Item> items) {
        boolean found = false;
        for (Item item : items) {
            if (!TrinketHelper.AccessoryCheck(entity, item)) continue;
            found = true;
            break;
        }
        return found;
    }

    public static ItemStack getAccessory(EntityLivingBase entity, Item item) {
        if (item == null) {
            return ItemStack.field_190927_a;
        }
        return TrinketHelper.getAccessory(entity, (ItemStack stack) -> !stack.func_190926_b() && stack.func_77973_b().getRegistryName().toString().contentEquals(item.getRegistryName().toString()));
    }

    public static ItemStack getAccessory(EntityLivingBase entity, Predicate<ItemStack> predicate) {
        ItemStack stack1 = TrinketHelper.getTrinketStack(entity, predicate);
        return stack1.func_190926_b() ? TrinketHelper.getBaubleStack(entity, predicate) : stack1;
    }

    public static void applyToAccessories(EntityLivingBase entity, Consumer<ItemStack> consumer) {
        TrinketHelper.applyToTrinkets(entity, consumer);
        TrinketHelper.applyToBaubles(entity, consumer);
    }

    public static int countAccessories(EntityLivingBase entity, Predicate<ItemStack> predicate) {
        int amount = 0;
        amount += TrinketHelper.countTrinkets(entity, predicate);
        return amount += TrinketHelper.countBaubles(entity, predicate);
    }

    public static boolean TrinketCheck(EntityLivingBase entity, Item item) {
        return !TrinketHelper.getTrinketStack(entity, item).func_190926_b();
    }

    public static ItemStack getTrinketStack(EntityLivingBase entity, Item item) {
        if (item == null) {
            return ItemStack.field_190927_a;
        }
        return TrinketHelper.getTrinketStack(entity, (ItemStack stack) -> !stack.func_190926_b() && stack.func_77973_b().getRegistryName().toString().contentEquals(item.getRegistryName().toString()));
    }

    public static ItemStack getTrinketStack(EntityLivingBase entity, Predicate<ItemStack> predicate) {
        ITrinketContainerHandler Trinket = TrinketHelper.getTrinketHandler(entity);
        if (Trinket != null) {
            for (int i = 0; i < Trinket.getSlots(); ++i) {
                ItemStack stack;
                if (Trinket.getStackInSlot(i).func_190926_b() || !predicate.test(stack = Trinket.getStackInSlot(i))) continue;
                return stack;
            }
        }
        return ItemStack.field_190927_a;
    }

    public static void applyToTrinkets(EntityLivingBase entity, Consumer<ItemStack> consumer) {
        TrinketHelper.getTrinketHandler(entity, Trinket -> {
            for (int i = 0; i < Trinket.getSlots(); ++i) {
                if (Trinket.getStackInSlot(i).func_190926_b()) continue;
                ItemStack stack = Trinket.getStackInSlot(i);
                if (consumer == null) continue;
                consumer.accept(stack);
            }
        });
    }

    public static int countTrinkets(EntityLivingBase entity, Predicate<ItemStack> predicate) {
        int ret = 0;
        ITrinketContainerHandler Trinket = TrinketHelper.getTrinketHandler(entity);
        if (Trinket != null) {
            for (int i = 0; i < Trinket.getSlots(); ++i) {
                ItemStack stack;
                if (Trinket.getStackInSlot(i).func_190926_b() || !predicate.test(stack = Trinket.getStackInSlot(i))) continue;
                ++ret;
            }
        }
        return ret;
    }

    public static SlotInformation getTrinketSlotInformation(EntityLivingBase entity, Predicate<ItemStack> predicate) {
        ITrinketContainerHandler Trinket = TrinketHelper.getTrinketHandler(entity);
        if (Trinket != null) {
            for (int i = 0; i < Trinket.getSlots(); ++i) {
                ItemStack stack;
                if (Trinket.getStackInSlot(i).func_190926_b() || !predicate.test(stack = Trinket.getStackInSlot(i))) continue;
                return TrinketHelper.getSlotInfo(stack, SlotInformation.ItemHandlerType.TRINKETS.getName(), i);
            }
        }
        return null;
    }

    public static List<SlotInformation> getSlotInfoForTrinkets(EntityLivingBase entity, Predicate<ItemStack> predicate) {
        ArrayList<SlotInformation> list = new ArrayList<SlotInformation>();
        ITrinketContainerHandler Trinket = TrinketHelper.getTrinketHandler(entity);
        if (Trinket != null) {
            for (int i = 0; i < Trinket.getSlots(); ++i) {
                ItemStack stack;
                if (Trinket.getStackInSlot(i).func_190926_b() || !predicate.test(stack = Trinket.getStackInSlot(i))) continue;
                SlotInformation info = TrinketHelper.getSlotInfo(stack, SlotInformation.ItemHandlerType.TRINKETS.getName(), i);
                list.add(info);
            }
        }
        return list;
    }

    public static boolean baubleCheck(EntityLivingBase entity, Item item) {
        return !TrinketHelper.getBaubleStack(entity, item).func_190926_b();
    }

    public static ItemStack getBaubleStack(EntityLivingBase entity, Item item) {
        if (item == null) {
            return ItemStack.field_190927_a;
        }
        return TrinketHelper.getBaubleStack(entity, (ItemStack stack) -> !stack.func_190926_b() && stack.func_77973_b().getRegistryName().toString().contentEquals(item.getRegistryName().toString()));
    }

    public static ItemStack getBaubleStack(EntityLivingBase entity, Predicate<ItemStack> predicate) {
        IBaublesItemHandler baubles2;
        if (Trinkets.Baubles && entity instanceof EntityPlayer && (baubles2 = BaublesApi.getBaublesHandler((EntityPlayer)((EntityPlayer)entity))) != null) {
            for (int i = 0; i < baubles2.getSlots(); ++i) {
                ItemStack stack = baubles2.getStackInSlot(i);
                if (!predicate.test(stack)) continue;
                return stack;
            }
        }
        return ItemStack.field_190927_a;
    }

    public static void applyToBaubles(EntityLivingBase entity, Consumer<ItemStack> consumer) {
        IBaublesItemHandler baubles2;
        if (Trinkets.Baubles && entity instanceof EntityPlayer && (baubles2 = BaublesApi.getBaublesHandler((EntityPlayer)((EntityPlayer)entity))) != null) {
            for (int i = 0; i < baubles2.getSlots(); ++i) {
                if (baubles2.getStackInSlot(i).func_190926_b()) continue;
                ItemStack stack = baubles2.getStackInSlot(i);
                if (consumer == null) continue;
                consumer.accept(stack);
            }
        }
    }

    public static int countBaubles(EntityLivingBase entity, Predicate<ItemStack> predicate) {
        IBaublesItemHandler baubles2;
        int ret = 0;
        if (Trinkets.Baubles && entity instanceof EntityPlayer && (baubles2 = BaublesApi.getBaublesHandler((EntityPlayer)((EntityPlayer)entity))) != null) {
            for (int i = 0; i < baubles2.getSlots(); ++i) {
                ItemStack stack;
                if (baubles2.getStackInSlot(i).func_190926_b() || !predicate.test(stack = baubles2.getStackInSlot(i))) continue;
                ++ret;
            }
        }
        return ret;
    }

    public static SlotInformation getBaubleSlotInformation(EntityLivingBase entity, Predicate<ItemStack> predicate) {
        IBaublesItemHandler baubles2;
        if (Trinkets.Baubles && entity instanceof EntityPlayer && (baubles2 = BaublesApi.getBaublesHandler((EntityPlayer)((EntityPlayer)entity))) != null) {
            for (int i = 0; i < baubles2.getSlots(); ++i) {
                ItemStack stack;
                if (baubles2.getStackInSlot(i).func_190926_b() || !predicate.test(stack = baubles2.getStackInSlot(i))) continue;
                return TrinketHelper.getSlotInfo(stack, SlotInformation.ItemHandlerType.BAUBLES.getName(), i);
            }
        }
        return null;
    }

    public static List<SlotInformation> getSlotInfoForBaubles(EntityLivingBase entity, Predicate<ItemStack> predicate) {
        IBaublesItemHandler baubles2;
        ArrayList<SlotInformation> list = new ArrayList<SlotInformation>();
        if (Trinkets.Baubles && entity instanceof EntityPlayer && (baubles2 = BaublesApi.getBaublesHandler((EntityPlayer)((EntityPlayer)entity))) != null) {
            for (int i = 0; i < baubles2.getSlots(); ++i) {
                ItemStack stack;
                if (baubles2.getStackInSlot(i).func_190926_b() || !predicate.test(stack = baubles2.getStackInSlot(i))) continue;
                SlotInformation info = TrinketHelper.getSlotInfo(stack, SlotInformation.ItemHandlerType.BAUBLES.getName(), i);
                list.add(info);
            }
        }
        return list;
    }

    public static ItemStack getItemStackFromSlot(EntityLivingBase player, int slot, int handler) {
        if (player instanceof EntityPlayer && slot >= 0) {
            IBaublesItemHandler baubles2;
            if (handler == 1) {
                ITrinketContainerHandler Trinket = TrinketHelper.getTrinketHandler(player);
                if (!Trinket.getStackInSlot(slot).func_190926_b()) {
                    return Trinket.getStackInSlot(slot);
                }
            } else if (Trinkets.Baubles && handler == 2 && !(baubles2 = BaublesApi.getBaublesHandler((EntityPlayer)((EntityPlayer)player))).getStackInSlot(slot).func_190926_b()) {
                return baubles2.getStackInSlot(slot);
            }
        }
        return ItemStack.field_190927_a;
    }

    public static NBTTagCompound getTagCompoundSafe(ItemStack stack) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
            stack.func_77982_d(tagCompound);
        }
        return tagCompound;
    }

    public static boolean entityHasAbility(String ability, EntityLivingBase entity) {
        return Capabilities.getEntityProperties((Entity)entity, false, (prop, rtn) -> {
            try {
                return prop.getAbilityHandler().getAbility(ability) != null;
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        });
    }

    public static class SlotInformation {
        protected int Slot = -1;
        protected String handler;
        protected ItemStack stack;

        public SlotInformation(ItemHandlerType handler) {
            this(handler.getName(), -1);
        }

        public SlotInformation(ItemHandlerType handler, int slot) {
            this(handler.getName(), slot);
        }

        public SlotInformation(String handler, int slot) {
            this(ItemStack.field_190927_a, handler, slot);
        }

        public SlotInformation(ItemStack stack, ItemHandlerType handler, int slot) {
            this(stack, handler.getName(), slot);
        }

        public SlotInformation(ItemStack stack, String handler, int slot) {
            if (stack == null) {
                stack = ItemStack.field_190927_a;
            }
            this.stack = stack;
            this.Slot = slot;
            this.handler = handler;
        }

        public void setSlot(int slot) {
            this.Slot = slot;
        }

        public int getSlot() {
            return this.Slot;
        }

        public void setHandler(ItemHandlerType handler) {
            this.handler = handler.getName();
        }

        public void setHandler(String handler) {
            this.handler = handler;
        }

        public String getItemID() {
            return this.stack.func_190926_b() ? "EMPTY" : this.stack.func_77973_b().getRegistryName().toString();
        }

        public String getHandler() {
            return this.handler;
        }

        public ItemHandlerType getHandlerType() {
            return ItemHandlerType.byName(this.handler);
        }

        public ItemStack getSourceStack() {
            return this.stack;
        }

        public ItemStack getStackFromHandler(EntityLivingBase entity) {
            if (entity == null) {
                return ItemStack.field_190927_a;
            }
            switch (this.getHandlerType()) {
                case TRINKETS: {
                    ITrinketContainerHandler TrinketHandler = TrinketHelper.getTrinketHandler(entity);
                    return TrinketHandler != null ? TrinketHelper.getTrinketHandler(entity).getStackInSlot(this.getSlot()) : ItemStack.field_190927_a;
                }
                case BAUBLES: {
                    IBaublesItemHandler BaublesHandler;
                    if (Trinkets.Baubles && (BaublesHandler = BaublesHelper.getBaublesHandler(entity)) != null) {
                        return BaublesHandler.getStackInSlot(this.getSlot());
                    }
                    return ItemStack.field_190927_a;
                }
                case HEAD: {
                    return entity.func_184582_a(EntityEquipmentSlot.HEAD);
                }
                case CHEST: {
                    return entity.func_184582_a(EntityEquipmentSlot.CHEST);
                }
                case LEGS: {
                    return entity.func_184582_a(EntityEquipmentSlot.LEGS);
                }
                case FEET: {
                    return entity.func_184582_a(EntityEquipmentSlot.FEET);
                }
                case OFFHAND: {
                    return entity.func_184582_a(EntityEquipmentSlot.OFFHAND);
                }
                case MAINHAND: {
                    return entity.func_184582_a(EntityEquipmentSlot.MAINHAND);
                }
                case HOTBAR: {
                    return entity instanceof EntityPlayer && InventoryPlayer.func_184435_e((int)this.getSlot()) ? ((EntityPlayer)entity).field_71071_by.func_70301_a(this.getSlot()) : ItemStack.field_190927_a;
                }
                case INVENTORY: {
                    return entity instanceof EntityPlayer ? ((EntityPlayer)entity).field_71071_by.func_70301_a(this.getSlot()) : ItemStack.field_190927_a;
                }
            }
            return ItemStack.field_190927_a;
        }

        public String toString() {
            return "ID:" + this.getItemID() + ", Handler:" + this.getHandler() + ", Slot:" + this.getSlot();
        }

        public static enum ItemHandlerType {
            NONE(0, "None"),
            RACE(1, "Race"),
            TRINKETS(2, "Trinkets"),
            BAUBLES(3, "Baubles"),
            INVENTORY(4, "Inventory"),
            HOTBAR(5, "Hotbar"),
            HEAD(6, "Head"),
            CHEST(7, "Chest"),
            LEGS(8, "Legs"),
            FEET(9, "Feet"),
            OFFHAND(10, "OffHand"),
            MAINHAND(11, "MainHand"),
            POTION(12, "Potion"),
            OTHER(13, "Other");

            private static final ItemHandlerType[] ID;
            private int id;
            private String name;

            private ItemHandlerType(int id, String name) {
                this.id = id;
                this.name = name;
            }

            public int getId() {
                return this.id;
            }

            public String getName() {
                return this.name;
            }

            public static ItemHandlerType byName(String name) {
                for (int i = 0; i < ItemHandlerType.values().length; ++i) {
                    if (!ItemHandlerType.byID(i).getName().contentEquals(name)) continue;
                    return ItemHandlerType.byID(i);
                }
                return NONE;
            }

            public static ItemHandlerType byID(int value) {
                if (value < 0 || value >= ItemHandlerType.values().length) {
                    value = 0;
                }
                return ItemHandlerType.values()[value];
            }

            static {
                ID = new ItemHandlerType[ItemHandlerType.values().length];
            }
        }
    }
}

