/*
 * Decompiled with CFR 0.152.
 */
package shadows.placebo.patreon;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import shadows.placebo.Placebo;

@Mod.EventBusSubscriber(modid="placebo", value={Side.CLIENT})
public class PatreonManager {
    public static final Int2ObjectMap<Consumer<String>> DATA_PARSERS = new Int2ObjectOpenHashMap();
    public static final Map<UUID, EnumParticleTypes> PATREONS = new HashMap<UUID, EnumParticleTypes>();

    @SubscribeEvent
    public static void init(ModelRegistryEvent e) {
        new Thread(() -> {
            Placebo.LOG.info("Loading patreon data...");
            try {
                URL url = new URL("https://raw.githubusercontent.com/Shadows-of-Fire/Placebo/master/PatreonInfo.txt");
                BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
                while (reader.ready()) {
                    String s = reader.readLine();
                    String[] split = s.split(" ", 2);
                    if (split.length != 2) {
                        Placebo.LOG.error("Invalid patreon data entry {} will be ignored.", (Object)s);
                        continue;
                    }
                    int dataVer = Integer.parseInt(split[0]);
                    Consumer func = (Consumer)DATA_PARSERS.get(dataVer);
                    if (func == null) {
                        Placebo.LOG.error("Invalid patreon data entry {} with invalid data version {} will be ignored.", (Object)s, (Object)dataVer);
                        continue;
                    }
                    func.accept(split[1]);
                }
                reader.close();
            }
            catch (IOException ex) {
                Placebo.LOG.error("Exception loading patreon data!");
                ex.printStackTrace();
            }
        }, "Placebo Patreon Loader").start();
    }

    static void parseV0Data(String s) {
        String[] split = s.split(" ");
        if (split.length != 2) {
            Placebo.LOG.error("Invalid patreon data entry (version 0) {} will be ignored.", (Object)s);
            return;
        }
        UUID id = UUID.fromString(split[0]);
        EnumParticleTypes type = EnumParticleTypes.func_186831_a((String)split[1]);
        PATREONS.put(id, type);
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent e) {
        Random rand;
        if (e.player.field_70170_p.field_72995_K && (rand = Minecraft.func_71410_x().field_71441_e.field_73012_v).nextInt(35) == 0) {
            EnumParticleTypes type = PATREONS.get(e.player.func_146103_bH().getId());
            if (type == null) {
                return;
            }
            double x = e.player.field_70169_q;
            double y = e.player.field_70167_r;
            double z = e.player.field_70166_s;
            Minecraft.func_71410_x().field_71441_e.func_175682_a(type, true, x, y + 0.7, z, MathHelper.func_82716_a((Random)rand, (double)-0.05, (double)0.05), MathHelper.func_82716_a((Random)rand, (double)0.03, (double)0.15), MathHelper.func_82716_a((Random)rand, (double)-0.05, (double)0.05), new int[0]);
        }
    }

    static {
        DATA_PARSERS.put(0, PatreonManager::parseV0Data);
    }
}

