/*
 * Decompiled with CFR 0.152.
 */
package melonslise.locks.common.container;

import melonslise.locks.client.gui.LockPickingGui;
import melonslise.locks.common.init.LocksDamageSources;
import melonslise.locks.common.init.LocksEnchantments;
import melonslise.locks.common.init.LocksNetworks;
import melonslise.locks.common.init.LocksSoundEvents;
import melonslise.locks.common.item.LockPickItem;
import melonslise.locks.common.network.toclient.CheckPinResultPacket;
import melonslise.locks.common.util.Lockable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LockPickingContainer
extends Container {
    public static final ITextComponent TITLE = new TextComponentTranslation("locks.gui.lockpicking.title", new Object[0]);
    public EntityPlayer player;
    public EnumHand hand;
    public Vec3d pos;
    public Lockable lockable;
    protected int currentIndex = 0;
    public int shocking;
    public int sturdy;
    public int complexity;

    public LockPickingContainer(EntityPlayer player, EnumHand hand, Lockable lockable) {
        this.player = player;
        this.hand = hand;
        this.lockable = lockable;
        Lockable.State state = lockable.getLockState(player.field_70170_p);
        this.pos = state == null ? lockable.box.center() : state.pos;
        this.shocking = EnchantmentHelper.func_77506_a((Enchantment)LocksEnchantments.SHOCKING, (ItemStack)this.lockable.stack);
        this.sturdy = EnchantmentHelper.func_77506_a((Enchantment)LocksEnchantments.STURDY, (ItemStack)this.lockable.stack);
        this.complexity = EnchantmentHelper.func_77506_a((Enchantment)LocksEnchantments.COMPLEXITY, (ItemStack)this.lockable.stack);
    }

    public int getCurrentIndex() {
        return this.currentIndex;
    }

    public boolean func_75145_c(EntityPlayer player) {
        return this.lockable.lock.isLocked() && this.isValidPick(player.func_184586_b(this.hand));
    }

    protected float getBreakChanceMultiplier(int pin) {
        return Math.abs(this.lockable.lock.getPin(this.currentIndex) - pin) == 1 ? 0.33f : 1.0f;
    }

    public void checkPin(int currentPin) {
        if (this.isOpen()) {
            return;
        }
        boolean correct = false;
        boolean reset = false;
        if (this.lockable.lock.checkPin(this.currentIndex, currentPin)) {
            ++this.currentIndex;
            correct = true;
            this.player.field_70170_p.func_184148_a(null, this.pos.field_72450_a, this.pos.field_72448_b, this.pos.field_72449_c, LocksSoundEvents.PIN_MATCH, SoundCategory.BLOCKS, 1.0f, 1.0f);
        } else if (!this.tryBreakPick(this.player, currentPin)) {
            int pinDistance = Math.abs(this.lockable.lock.getPin(this.currentIndex) - currentPin);
            this.player.field_70170_p.func_184148_a(null, this.pos.field_72450_a, this.pos.field_72448_b, this.pos.field_72449_c, LocksSoundEvents.PIN_FAIL, SoundCategory.BLOCKS, 1.0f, pinDistance <= 1 ? 1.25f : 1.0f);
        } else {
            reset = true;
            this.reset();
            if (this.shocking > 0) {
                this.player.func_70097_a(LocksDamageSources.SHOCK, (float)this.shocking * 1.5f);
                this.player.field_70170_p.func_184148_a(null, this.player.field_70165_t, this.player.field_70163_u, this.player.field_70161_v, LocksSoundEvents.SHOCK, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
        }
        LocksNetworks.MAIN.sendTo((IMessage)new CheckPinResultPacket(correct, reset), (EntityPlayerMP)this.player);
    }

    @SideOnly(value=Side.CLIENT)
    public void handlePin(boolean correct, boolean reset) {
        GuiScreen screen = Minecraft.func_71410_x().field_71462_r;
        if (screen instanceof LockPickingGui) {
            ((LockPickingGui)screen).handlePin(correct, reset);
        }
        if (correct) {
            ++this.currentIndex;
        }
        if (reset) {
            this.reset();
            this.player.func_184586_b(this.hand).func_190918_g(1);
        }
    }

    public boolean isOpen() {
        return this.currentIndex == this.lockable.lock.getLength();
    }

    protected void reset() {
        this.currentIndex = 0;
    }

    public boolean isValidPick(ItemStack stack) {
        return stack.func_77973_b() instanceof LockPickItem && LockPickItem.canPick(stack, this.complexity);
    }

    protected boolean tryBreakPick(EntityPlayer player, int pin) {
        ItemStack pickStack = player.func_184586_b(this.hand);
        if (!this.isValidPick(pickStack)) {
            return false;
        }
        float sturdyModifier = this.sturdy == 0 ? 1.0f : 0.75f + (float)this.sturdy * 0.5f;
        float ch = LockPickItem.getStrength(pickStack) / sturdyModifier;
        float ex = (1.0f - ch) * (1.0f - this.getBreakChanceMultiplier(pin));
        if (player.field_70170_p.field_73012_v.nextFloat() < ex + ch) {
            return false;
        }
        this.player.func_70669_a(pickStack);
        pickStack.func_190918_g(1);
        return true;
    }

    public void func_75134_a(EntityPlayer player) {
        super.func_75134_a(player);
        if (!this.isOpen() || !this.lockable.lock.isLocked()) {
            return;
        }
        this.lockable.lock.setLocked(!this.lockable.lock.isLocked());
        this.player.field_70170_p.func_184148_a(player, this.pos.field_72450_a, this.pos.field_72448_b, this.pos.field_72449_c, LocksSoundEvents.LOCK_OPEN, SoundCategory.BLOCKS, 1.0f, 1.0f);
    }
}

