/*
 * Decompiled with CFR 0.152.
 */
package levelup2.skills.crafting;

import com.google.common.collect.Lists;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import levelup2.api.IProcessor;
import levelup2.capability.CapabilityFurnace;
import levelup2.capability.PlayerCapability;
import levelup2.skills.BaseSkill;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.UsernameCache;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

public class FurnaceEfficiencyBonus
extends BaseSkill {
    @Override
    public String getSkillName() {
        return "levelup:furnacespeed";
    }

    @Override
    public byte getSkillType() {
        return 1;
    }

    @Override
    public boolean hasSubscription() {
        return true;
    }

    @Override
    public ItemStack getRepresentativeStack() {
        return new ItemStack(Blocks.field_150460_al);
    }

    @SubscribeEvent
    public void registerFurnaceCapability(AttachCapabilitiesEvent<TileEntity> evt) {
        if (evt.getObject() instanceof TileEntityFurnace) {
            final TileEntityFurnace furnace = (TileEntityFurnace)evt.getObject();
            evt.addCapability(new ResourceLocation("levelup", "furnacemods"), (ICapabilityProvider)new ICapabilitySerializable<NBTTagCompound>(){
                IProcessor instance;
                {
                    this.instance = new CapabilityFurnace(furnace);
                }

                public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
                    return capability == PlayerCapability.MACHINE_PROCESSING;
                }

                public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
                    return (T)(capability == PlayerCapability.MACHINE_PROCESSING ? PlayerCapability.MACHINE_PROCESSING.cast((Object)this.instance) : null);
                }

                public NBTTagCompound serializeNBT() {
                    return (NBTTagCompound)PlayerCapability.MACHINE_PROCESSING.getStorage().writeNBT(PlayerCapability.MACHINE_PROCESSING, (Object)this.instance, null);
                }

                public void deserializeNBT(NBTTagCompound tag) {
                    PlayerCapability.MACHINE_PROCESSING.getStorage().readNBT(PlayerCapability.MACHINE_PROCESSING, (Object)this.instance, null, (NBTBase)tag);
                }
            });
        }
    }

    @SubscribeEvent
    public void onTileInteracted(PlayerInteractEvent.RightClickBlock evt) {
        if (!evt.getWorld().field_72995_K && evt.getEntityPlayer() != null) {
            IProcessor cap;
            EntityPlayer player = evt.getEntityPlayer();
            if (player instanceof FakePlayer || !player.func_70093_af() || !evt.getItemStack().func_190926_b()) {
                return;
            }
            TileEntity tile = evt.getWorld().func_175625_s(evt.getPos());
            if (tile != null && tile.hasCapability(PlayerCapability.MACHINE_PROCESSING, EnumFacing.UP) && (cap = (IProcessor)tile.getCapability(PlayerCapability.MACHINE_PROCESSING, EnumFacing.UP)) != null) {
                String name = UsernameCache.getLastKnownUsername((UUID)player.func_146103_bH().getId());
                if (cap.getPlayerFromUUID() == null) {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("levelup.interact.register", new Object[]{name}), true);
                    cap.setUUID(player.func_146103_bH().getId());
                } else if (cap.getPlayerFromUUID().func_146103_bH().getId() == player.func_146103_bH().getId()) {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("levelup.interact.unregister", new Object[]{name}), true);
                    cap.setUUID(null);
                } else {
                    name = UsernameCache.getLastKnownUsername((UUID)cap.getPlayerFromUUID().func_146103_bH().getId());
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("levelup.interact.notowned", new Object[]{name}), true);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void doFurnaceTicks(TickEvent.WorldTickEvent evt) {
        if (evt.world.field_72995_K || evt.phase == TickEvent.Phase.END || evt.side != Side.SERVER) {
            return;
        }
        List<Object> tiles = Lists.newArrayList();
        try {
            List list = evt.world.field_147482_g;
            synchronized (list) {
                tiles = evt.world.field_147482_g.stream().filter(t -> t != null && t.hasCapability(PlayerCapability.MACHINE_PROCESSING, EnumFacing.UP)).map(t -> (IProcessor)t.getCapability(PlayerCapability.MACHINE_PROCESSING, EnumFacing.UP)).collect(Collectors.toList());
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
        tiles.forEach(this::processTick);
    }

    private void processTick(IProcessor tile) {
        if (tile != null && tile.getPlayerFromUUID() != null) {
            tile.extraProcessing(tile.getPlayerFromUUID());
        }
    }
}

