/*
 * Decompiled with CFR 0.152.
 */
package levelup2.skills.crafting;

import levelup2.skills.BaseSkill;
import levelup2.skills.SkillRegistry;
import levelup2.util.Library;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityFishHook;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class FishingLootBonus
extends BaseSkill {
    @Override
    public String getSkillName() {
        return "levelup:fishbonus";
    }

    @Override
    public byte getSkillType() {
        return 1;
    }

    @Override
    public boolean hasSubscription() {
        return true;
    }

    @Override
    public ItemStack getRepresentativeStack() {
        return new ItemStack((Item)Items.field_151112_aM);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onFishInteract(PlayerInteractEvent.RightClickItem evt) {
        ItemStack loot;
        EntityFishHook hook;
        if (!this.isActive()) {
            return;
        }
        if (evt.getResult() != Event.Result.DENY && (hook = evt.getEntityPlayer().field_71104_cf) != null && hook.field_146043_c == null && hook.field_146045_ax > 0 && !(loot = this.getFishingLoot(evt.getWorld(), evt.getEntityPlayer())).func_190926_b()) {
            ItemStack stack = evt.getEntityPlayer().field_71071_by.func_70448_g();
            int i = stack.func_190916_E();
            int j = stack.func_77952_i();
            stack.func_77972_a(1, (EntityLivingBase)evt.getEntityPlayer());
            evt.getEntityPlayer().func_184609_a(evt.getHand());
            evt.getEntityPlayer().field_71071_by.func_70299_a(evt.getEntityPlayer().field_71071_by.field_70461_c, stack);
            if (evt.getEntityPlayer().field_71075_bZ.field_75098_d) {
                stack.func_190917_f(i);
                if (stack.func_77984_f()) {
                    stack.func_77964_b(j);
                }
            }
            if (stack.func_190916_E() <= 0) {
                evt.getEntityPlayer().field_71071_by.func_70299_a(evt.getEntityPlayer().field_71071_by.field_70461_c, ItemStack.field_190927_a);
                MinecraftForge.EVENT_BUS.post((Event)new PlayerDestroyItemEvent(evt.getEntityPlayer(), stack, evt.getHand()));
            }
            if (!evt.getEntityPlayer().func_184587_cr() && evt.getEntityPlayer() instanceof EntityPlayerMP) {
                ((EntityPlayerMP)evt.getEntityPlayer()).func_71120_a(evt.getEntityPlayer().field_71069_bz);
            }
            evt.setResult(Event.Result.DENY);
            if (!hook.field_70170_p.field_72995_K) {
                EntityItem item = new EntityItem(hook.field_70170_p, hook.field_70165_t, hook.field_70163_u, hook.field_70161_v, loot);
                double d5 = hook.func_190619_l().field_70165_t - hook.field_70165_t;
                double d6 = hook.func_190619_l().field_70163_u - hook.field_70163_u;
                double d7 = hook.func_190619_l().field_70161_v - hook.field_70161_v;
                double d8 = MathHelper.func_76133_a((double)(d5 * d5 + d6 * d6 + d7 * d7));
                double d9 = 0.1;
                item.field_70159_w = d5 * d9;
                item.field_70181_x = d6 * d9 + (double)MathHelper.func_76133_a((double)d8) * 0.08;
                item.field_70179_y = d7 * d9;
                hook.field_70170_p.func_72838_d((Entity)item);
                hook.func_190619_l().field_70170_p.func_72838_d((Entity)new EntityXPOrb(hook.func_190619_l().field_70170_p, hook.func_190619_l().field_70165_t, hook.func_190619_l().field_70163_u + 0.5, hook.func_190619_l().field_70161_v + 0.5, evt.getEntityPlayer().func_70681_au().nextInt(6) + 1));
            }
        }
    }

    private ItemStack getFishingLoot(World world, EntityPlayer player) {
        if (!world.field_72995_K && player.func_70681_au().nextDouble() <= (double)SkillRegistry.getSkillLevel(player, this.getSkillName()) * 0.05) {
            LootContext.Builder build = new LootContext.Builder((WorldServer)world);
            build.func_186469_a((float)EnchantmentHelper.func_185284_a((Enchantment)Enchantment.func_180305_b((String)"luck_of_the_sea"), (EntityLivingBase)player) + player.func_184817_da());
            return ((ItemStack)Library.getLootManager().getLootTableFromLocation(new ResourceLocation("levelup", "fishing/fishing_loot")).func_186462_a(player.func_70681_au(), build.func_186471_a()).get(0)).func_77946_l();
        }
        return ItemStack.field_190927_a;
    }
}

